#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Нужна ПРОД база
=cut

# project modules
use feature 'say';
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $chunk_size = 1_000;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    for my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $chunk;
        my $i = 0;
        do {
            $chunk = $app->partner_db->$model->get_all(
                filter => [AND => [[id => '<>' => \100500], [direct_block => '=' => \'240x400']]],
                limit  => $chunk_size,
                offset => $chunk_size * $i,
            );

            for my $block (@$chunk) {
                $block->{page_id} = $block->{campaign_id};
                my $design = $app->$model->get_bk_direct_design($block);

                # TODO: move to get_bk_direct_design?
                if ($design->{borderType} eq 'none') {
                    delete $design->{borderRadius};
                }
                $design->{limit} += 0;

                my $designs = {
                    0 => {
                        name   => '',
                        design => $design,
                    },
                };
                my $result;
                my $error;
                try {
                    $result = $app->api_format_system->validate(
                        design => $design,
                        role   => 'partner',
                        site   => $block->{site_version},
                    );
                }
                catch {
                    $error = $_[0];
                };

                my $id = {campaign_id => $block->{campaign_id}, id => $block->{id}};

                if ($error) {
                    say to_json({%$id, model => $model, design => $design, api_error => $error->message});
                } elsif ($result->{valid}) {
                    say to_json({%$id, model => $model, design => $design});
                    $app->partner_db->$model->edit($id, {opts => to_json({designs => $designs})});
                } else {
                    say to_json({%$id, model => $model, design => $design, validation_error => $result});
                }
            }
            $i += 1;
        } while (@$chunk);
    }

    $app->post_run();

    print "#END\n";
}
