CREATE TABLE IF NOT EXISTS `statistics_indoor` (
  `dt` date NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `currency_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `an_fraud_shows` int(10) unsigned NOT NULL,
  `an_fraud_clicks` int(10) unsigned NOT NULL,
  PRIMARY KEY (`dt`,`page_id`,`currency_id`),
  KEY `fk_statistics_indoor__page_id___indoor__page_id` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `statistics_outdoor` (
  `dt` date NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `currency_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `an_fraud_shows` int(10) unsigned NOT NULL,
  `an_fraud_clicks` int(10) unsigned NOT NULL,
  PRIMARY KEY (`dt`,`page_id`,`currency_id`),
  KEY `fk_statistics_outdoor__page_id___outdoor__page_id` (`page_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `statistics_indoor_block` (
  `dt` date NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `block_id` int(10) unsigned NOT NULL,
  `dsp_id` int(10) unsigned NOT NULL,
  `currency_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `tag_id` bigint(20) unsigned NOT NULL,
  `indoor_block_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_direct_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_direct_clicks` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `partner_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `partner_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_partner_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_partner_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_block_bad_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_bad_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_bad_win_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_bad_win_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_bad_win_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_bad_win_partner_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_bad_win_partner_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_partner_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_partner_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `indoor_block_win_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_win_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `indoor_block_win_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dt`,`page_id`,`block_id`,`dsp_id`,`currency_id`,`tag_id`),
  KEY `statistics_indoor_block__page_id_block_id_dt` (`page_id`,`block_id`,`dt`),
  KEY `statistics_indoor_block__dsp_id_dt` (`dsp_id`,`dt`),
  KEY `fk_statistics_indoor_block__currency_id___currencies__id` (`currency_id`),
  CONSTRAINT `statistics_indoor_block_ibfk_1` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `statistics_outdoor_block` (
  `dt` date NOT NULL,
  `page_id` int(10) unsigned NOT NULL,
  `block_id` int(10) unsigned NOT NULL,
  `dsp_id` int(10) unsigned NOT NULL,
  `currency_id` tinyint(3) unsigned NOT NULL DEFAULT '2',
  `tag_id` bigint(20) unsigned NOT NULL,
  `outdoor_block_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_direct_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_direct_clicks` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `all_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `partner_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `partner_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_partner_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_partner_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_bad_shows` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_bad_shows_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_bad_win_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_bad_win_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_bad_win_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_bad_win_partner_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_bad_win_partner_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_partner_price_w_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `bad_win_partner_price_wo_nds` bigint(20) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_win_hits` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_win_hits_own_adv` int(10) unsigned NOT NULL DEFAULT '0',
  `outdoor_block_win_hits_unsold` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`dt`,`page_id`,`block_id`,`dsp_id`,`currency_id`,`tag_id`),
  KEY `statistics_outdoor_block__page_id_block_id_dt` (`page_id`,`block_id`,`dt`),
  KEY `statistics_outdoor_block_dsp_id_dt` (`dsp_id`,`dt`),
  KEY `fk_statistics_outdoor_block__currency_id___currencies__id` (`currency_id`),
  CONSTRAINT `statistics_outdoor_block_ibfk_1` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO `statistics_reports_level_order` VALUES 
('indoor',122) ON DUPLICATE KEY UPDATE `order`=122;
INSERT INTO `statistics_reports_level_order` VALUES 
('indoor_block',123) ON DUPLICATE KEY UPDATE `order`=123;
INSERT INTO `statistics_reports_level_order` VALUES 
('outdoor',126) ON DUPLICATE KEY UPDATE `order`=126;
INSERT INTO `statistics_reports_level_order` VALUES 
('outdoor_block',127) ON DUPLICATE KEY UPDATE `order`=127;

