CREATE TABLE IF NOT EXISTS `block_presets` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `owner_id` BIGINT UNSIGNED NOT NULL,
    `caption` VARCHAR(255) NOT NULL,
    `settings` JSON NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    PRIMARY KEY (`id`),
    FOREIGN KEY `fk_block_presets__owner_id___users__id` (`owner_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `block_presets_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `block_presets_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `block_presets_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_block_presets_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_block_presets_action_log__elem_id___block_presets__id` (`elem_id`)
        REFERENCES `block_presets` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';
