#!/usr/bin/perl
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;
my $LIMIT = 500;

sub main {
    my $app = Application->new();
    $app->pre_run();

    $app->set_cur_user({id => 671748233});
    my $tmp_rights = $app->add_all_tmp_rights();
    foreach my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $page_id_field_name = $app->$model->get_page_id_field_name;
        my $offset             = 0;
        while (my $blocks = $app->$model->get_all(fields => [qw(*)], limit => $LIMIT, offset => $offset)) {
            $offset += @$blocks;
            print `date` . $offset . "\n";
            last unless @$blocks;
            my @data_to_add;
            foreach my $block (@$blocks) {
                next
                  if (defined $block->{design_templates} && @{$block->{design_templates}})
                  || $block->{is_constructed_format};
                push @data_to_add,
                  {
                    page_id     => $block->{$page_id_field_name},
                    block_id    => $block->{id},
                    caption     => 'default design template',
                    order_num   => 0,
                    update_time => curdate(oformat => 'db_time'),
                    opts        => defined $block->{designs}
                    ? to_json(
                        {
                            design_settings => $block->{designs}{0}{design},
                            form_factor     => $block->{form_factor}
                        }
                      )
                    : to_json(
                        {
                            design_settings => $app->$model->_get_design_settings($block),
                            form_factor     => $block->{form_factor}
                        },
                        pretty => TRUE
                    )
                  };
            }
            $app->partner_db->design_templates->add_multi(\@data_to_add) if @data_to_add;
        }

    }
    $app->post_run();
}

main();
