CREATE TABLE IF NOT EXISTS `design_templates` (
`id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
`page_id` INT UNSIGNED NOT NULL,
`block_id` INT UNSIGNED NOT NULL,
`caption` VARCHAR(255) NOT NULL,
`order_num` INT UNSIGNED NOT NULL DEFAULT 0,
`opts` JSON NOT NULL,
`update_time` DATETIME NOT NULL,
`multistate` BIGINT UNSIGNED NOT NULL DEFAULT 0,
PRIMARY KEY (`id`),
INDEX `design_templates__page_block` (`page_id`, `block_id`),
INDEX `design_templates__multistate` (`multistate`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

ALTER TABLE `design_templates` AUTO_INCREMENT = 1000000;

CREATE TABLE IF NOT EXISTS `design_templates_action_log` (
`id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
`dt` DATETIME NOT NULL,
`user_id` BIGINT UNSIGNED NOT NULL,
`elem_id` BIGINT UNSIGNED NOT NULL,
`old_multistate` BIGINT UNSIGNED NOT NULL,
`action` VARCHAR(100) NOT NULL,
`new_multistate` BIGINT UNSIGNED NOT NULL,
`opts` TEXT NOT NULL,
`comment` VARCHAR(100) NOT NULL DEFAULT '', 
PRIMARY KEY (`id`),
INDEX `design_templates_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
INDEX `design_templates_action_log__elem_id_action` (`elem_id`, `action`),
FOREIGN KEY `fk_design_templates_action_log__elem_id___design_templates` (`elem_id`)
REFERENCES `design_templates` (`id`)
ON UPDATE RESTRICT
ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

