#!/usr/bin/perl

=encoding UTF-8
=cut

=head1 DESCRIPTION
    Нужна ПРОД база
=cut

# project modules
use feature 'say';
use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;

my $chunk_size = 1_000;

main();

sub main {
    my $app = Application->new();
    $app->pre_run();

    {
        no strict 'refs';
        no warnings 'redefine';
        *{'QBit::Application::check_rights'} = sub {TRUE};
    }

    $app->set_cur_user({id => 0, login => 'system-cron'});

    for my $model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
        my $chunk;
        my $i = 0;
        my @rows;
        do {
            $chunk = $app->partner_db->$model->get_all(
                fields => [qw(campaign_id id articles)],
                limit  => $chunk_size,
                offset => $chunk_size * $i,
            );

            for my $block (@$chunk) {
                next unless $block->{articles};
                my $articles = from_json($block->{articles});

                say to_json({model => $model, block => $block});

                for my $article (@{$articles}) {
                    push @rows,
                      {
                        page_id     => $block->{campaign_id},
                        block_id    => $block->{id},
                        article_sid => $article->{id},
                        cpm         => $article->{cpm},
                      };
                }
            }

            if (@rows > $chunk_size) {
                $app->partner_db->articles->add_multi(\@rows);
                @rows = ();
            }

            $i += 1;
        } while (@$chunk);
    }

    $app->post_run();

    print "#END\n";
}
