#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use Getopt::Long qw();

use qbit;
use Application;

use PiConstants qw($MIDROLL);

my $EXCLUDE_PAGE_LIST = [276119];
# settings for cyclic midroll block
my $SOLO_MIDROLL_SETTINGS = {
    repeat           => 1,
    repeat_after     => 600,
    max_repeat_count => 0,
};

my $DRY_RUN = TRUE;

sub main {

    my $debug_page_ids = _get_args_page_ids();

    my $app = Application->new()->pre_run();
    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    # all "VH:" categories
    my $VIDEO_CATEGORY_LIST = [$app->video_an_site_categories->get_category_ids_for_yahosting()];

    my $filter = [
        [page_id     => 'NOT IN' => $EXCLUDE_PAGE_LIST],
        {type        => $MIDROLL},
        {category_id => $VIDEO_CATEGORY_LIST},
        {multistate  => 'not deleted'},
    ];
    if ($debug_page_ids && @$debug_page_ids) {
        push $filter, {page_id => $debug_page_ids};
    }

    my $midroll_list = $app->video_an_site_instream->get_all(
        fields => [
            qw(page_id id start_time category_id is_custom_bk_data max_repeat_count repeat repeat_after server_side try_client)
        ],
        filter => [AND => $filter,],
    );

    my %by_vh_category;
    for my $block (@$midroll_list) {
        $by_vh_category{$block->{page_id}}->{$block->{category_id}} ||= [];
        push @{$by_vh_category{$block->{page_id}}->{$block->{category_id}}}, $block;
    }

    _reduce_midrolls($app, $_) for (values %by_vh_category);

    print "#END\n";
}

sub _reduce_midrolls {
    my ($app, $by_category) = @_;

    for my $block_list (values %$by_category) {
        my @block_list_sorted = (sort {($a->{start_time} // 0) <=> ($b->{start_time} // 0)} @$block_list);

        my @block_list_custom;
        my @block_list_normal;

        foreach (@block_list_sorted) {
            if (1 == $_->{is_custom_bk_data}) {
                push @block_list_custom, $_;
            } else {
                push @block_list_normal, $_;
            }
        }

        printf("s%s\n", to_json(\@block_list_custom)) if @block_list_custom;

        next unless @block_list_normal;

        try {
            $app->partner_db->transaction(
                sub {
                    unless ($DRY_RUN) {
                        $app->video_an_site_instream->do_action($block_list_normal[0], 'edit', %$SOLO_MIDROLL_SETTINGS)
                          unless _is_settings_equal($block_list_normal[0], $SOLO_MIDROLL_SETTINGS);
                    }
                    printf("*%s\n", to_json($block_list_normal[0]));

                    unless ($DRY_RUN) {
                        $app->video_an_site_instream->do_action($_, 'delete')
                          for (@block_list_normal[1 .. $#block_list_normal]);
                    }
                    printf("-%s\n", to_json([@block_list_normal[1 .. $#block_list_normal]]));
                }
            );
        }
        catch {
            my ($e) = @_;
            print to_json({first_block => $block_list_normal[0], error => $e->message}, canonical => 1);
            print "\n";
        };
    }
}

sub _is_settings_equal {
    my ($got, $new) = @_;
    return 0 == grep {($got->{$_} // '') ne $new->{$_}} keys %$new;
}

sub _get_args_page_ids {

    my $page_id_str = '';
    my $with_db     = '';

    Getopt::Long::GetOptions(
        'page_ids:s' => \$page_id_str,
        'with_db:s'  => \$with_db
    );

    my @page_id_list = split /,/, $page_id_str;

    $DRY_RUN = FALSE if ('1' eq $with_db);

    return \@page_id_list;
}

main();
