#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

my $PAGE_ID_LIST = [355271, 339619, 320575, 384649];

sub main {

    my $app = Application->new()->pre_run();
    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $block_list = $app->video_an_site_instream->get_all(
        fields => [qw(page_id id articles)],
        filter => [AND => [{page_id => $PAGE_ID_LIST}, {is_custom_bk_data => 0}]],
    );

    for my $block (@$block_list) {
        next unless $block->{articles};
        try {
            my $articles = from_json($block->{articles});
            if ($articles) {
                for my $item (@$articles) {
                    $item->{cpm} = 9999 if ($item->{cpm} > 9999);
                }
            }
            $app->partner_db->transaction(
                sub {
                    $app->video_an_site_instream->do_action($block, 'edit', articles => to_json($articles));
                    printf("*%s\n", to_json($block));
                }
            );
        }
        catch {
            my ($e) = @_;
            print to_json({block => $block, error => $e->message}, canonical => 1), "\n";
        };
    }

    print "#END\n";
}

main();
