#!/usr/bin/perl

use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;

use Getopt::Long qw();

sub main {

    my $app = Application->new()->pre_run();
    $app->set_cur_user({id => 0});

    {
        no warnings 'redefine';
        *QBit::Application::check_rights = sub {1};
    }

    my $log_file_path = _get_args_logfilepath();
    if (open(FH, '<', $log_file_path)) {
        while (my $line = <FH>) {
            _rollback($app, [$line]);
        }
        close FH;

    } else {
        die $!;
    }

    print "#END\n";
}

sub _rollback {
    my ($app, $log) = @_;

    foreach my $log_line (@$log) {
        if ('*' eq substr($log_line, 0, 1)) {

            my $block2update = from_json(substr($log_line, 1));
            my $block_pk = {
                page_id => $block2update->{page_id},
                id      => $block2update->{id},
            };
            try {

                delete $block2update->{$_} for (qw/max_repeat_count repeat_after page_id try_client category_id id/);

                $app->partner_db->transaction(
                    sub {
                        $app->video_an_site_instream->do_action($block_pk, 'edit', %$block2update);
                        printf("*%s\n", to_json($block2update));
                    }
                );
            }
            catch {
                my ($e) = @_;
                print to_json({first_block => $block2update, error => $e->message}, canonical => 1);
                print "\n";
            };
        }

        elsif ('-' eq substr($log_line, 0, 1)) {

            my $blocks2restore = from_json(substr($log_line, 1));
            try {

                $app->video_an_site_instream->do_action($_, 'restore') for (@$blocks2restore);

                printf("+%s\n", to_json($blocks2restore));
            }
            catch {
                my ($e) = @_;
                print to_json({first_block => $blocks2restore->[0], error => $e->message}, canonical => 1);
                print "\n";
            };

        }

        else {
            printf("!%s\n", $log_line);
        }
    }

}

sub _get_args_logfilepath {

    my $logfilepath = '';

    Getopt::Long::GetOptions('log:s' => \$logfilepath,);

    return $logfilepath;
}

main();
