#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION
    Миграция добавляет записи в таблицу articles, выбирая их из полей articles/opts->>'$.articles'

=head1 USAGE
  ./migrations/before_release/PI-16001_move_articles_2table_4all_models.pl
  ./migrations/before_release/PI-16001_move_articles_2table_4all_models.pl --append_logs

=head1 OPTIONS
=cut

use lib::abs qw(
  ../../lib
  );
use qbit;
use Application;
use Utils::ScriptWrapper;

my $chunk_size = 5_000;

run(
    sub {
        my ($app, $opts) = @_;

        my @model_list =
          grep {$app->$_->DOES('Application::Model::Role::Has::Articles::FromField')}
          @{$app->product_manager->get_block_model_names()};

        for my $model (@model_list) {
            print logstr("starting [$model]");

            my $page_id_field = $app->$model->get_page_id_field_name;
            my @fields        = ('id', $page_id_field);
            my $is_opts_field = 'opts' eq $app->$model->storage_method_of_articles();
            push @fields, ($is_opts_field ? 'opts' : 'articles');
            my $filter =
              $is_opts_field
              ? [
                AND => [
                    {JSON_CONTAINS_PATH => ['opts', \'one', \'$.articles']},
                    [{JSON_UNQUOTE => [{JSON_EXTRACT => ['opts', \'$.articles']}]} => '<>' => \'null']
                ]
              ]
              : [{JSON_EXTRACT => [{JSON_UNQUOTE => ['articles']}, \'$[0]']} => 'IS NOT' => \undef];

            my $chunk;
            my $i = 0;
            my @rows;
            do {
                $chunk = $app->partner_db->$model->get_all(
                    fields => \@fields,
                    limit  => $chunk_size,
                    offset => $chunk_size * $i,
                    filter => $filter
                );

                print logstr("[$model] " . @$chunk . ' records to process') if @$chunk;

                for my $block (@$chunk) {
                    my $articles =
                      $is_opts_field
                      ? from_json($block->{opts})->{articles}
                      : from_json($block->{articles});

                    $articles = from_json($articles) unless 'ARRAY' eq ref($articles);

                    next unless @$articles;

                    print logstr(
                        to_json(
                            {
                                model => $model,
                                block => {
                                    page_id  => $block->{$page_id_field},
                                    block_id => $block->{id},
                                    articles => $articles,
                                }
                            },
                            canonical => 1
                        )
                    );

                    for my $article (@{$articles}) {
                        push @rows,
                          {
                            page_id     => $block->{$page_id_field},
                            block_id    => $block->{id},
                            article_sid => $article->{id},
                            cpm         => $article->{cpm},
                          };
                    }
                }

                if (@rows > $chunk_size || @$chunk < $chunk_size) {
                    $app->partner_db->articles->add_multi(\@rows, 'ignore' => 1);
                    @rows = ();
                }

                $i += 1;

            } while (@$chunk);
        }

        print logstr('#END');

    }
   );
