CREATE TABLE IF NOT EXISTS `context_on_site_natural` (
    `campaign_id` INT UNSIGNED,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `geo` MEDIUMTEXT,
    `comment` TEXT,
    `opts` JSON NOT NULL,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`campaign_id`, `id`),
    FOREIGN KEY `fk_context_on_site_natural__campaign_id___context_on_site_campa` (`campaign_id`)
        REFERENCES `context_on_site_campaign` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
);

CREATE TABLE IF NOT EXISTS `context_on_site_natural_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_campaign_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `context_on_site_natural_action_log__dt_elem_campaign_id_elem_id_` (`dt`, `elem_campaign_id`, `elem_id`, `action`),
    INDEX `context_on_site_natural_action_log__elem_campaign_id_elem_id_act` (`elem_campaign_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_context_on_site_natural_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_context_on_site_natural_action_log__elem_campaign_id_elem_id` (`elem_campaign_id`, `elem_id`)
        REFERENCES `context_on_site_natural` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
);

CREATE TABLE IF NOT EXISTS `internal_context_on_site_natural` (
    `campaign_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `geo` MEDIUMTEXT,
    `comment` TEXT,
    `opts` JSON NOT NULL,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    PRIMARY KEY (`campaign_id`, `id`),
    FOREIGN KEY `fk_internal_context_on_site_natural__campaign_id___internal_con` (`campaign_id`)
        REFERENCES `internal_context_on_site_campaign` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
);

CREATE TABLE IF NOT EXISTS `internal_context_on_site_natural_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_campaign_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `internal_context_on_site_natural_action_log__dt_elem_campaign_id` (`dt`, `elem_campaign_id`, `elem_id`, `action`),
    INDEX `internal_context_on_site_natural_action_log__elem_campaign_id_el` (`elem_campaign_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_internal_context_on_site_natural_action_log__user_id___users` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_internal_context_on_site_natural_action_log__elem_campaign_i` (`elem_campaign_id`, `elem_id`)
        REFERENCES `internal_context_on_site_natural` (`campaign_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
);
