#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'

YT_TABLE_TNS_IAB_PATH="${YT_PROJECT_PATH}/tns_iab_mapping"
YT_TABLE_TNS_IAB_SCHEMA='[{name=id;type=int32;sort_order=ascending;required=%true};{name=TNSID;type=string;required=%true};{name=PICategoryID;type=string;required=%true}]'

YT_TABLE_IAB_BM_CATEGORY_PATH="${YT_PROJECT_PATH}/iab_bm_category_mapping"
YT_TABLE_IAB_BM_CATEGORY_SCHEMA='[{name=id;type=int32;sort_order=ascending;required=%true};{name=PICategoryID;type=string;required=%true};{name=BMCategoryID;type=string;required=%true}]'

TABLE_PATHS=("$YT_TABLE_TNS_IAB_PATH" "$YT_TABLE_IAB_BM_CATEGORY_PATH")
TABLE_SCHEMAS=("$YT_TABLE_TNS_IAB_SCHEMA" "$YT_TABLE_IAB_BM_CATEGORY_SCHEMA")
TABLE_DATA=("PI-15309_tns_iab_mapping.json" "PI-15309_iab_bm_category_mapping.json")

for ((i=0; i < ${#TABLE_PATHS[@]}; i++))
do
YT_TABLE_SCHEMA=${TABLE_SCHEMAS[$i]}
YT_TABLE_PATH=${TABLE_PATHS[$i]}
YT_TABLE_DATA="migrations/before_release/${TABLE_DATA[$i]}"

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'
else
    echo "~using TEST config";
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_1 2>/dev/null || true
    yt remove $YT_TABLE_PATH --proxy $YT_REPLICA_CLUSTER_2 2>/dev/null || true
    yt remove $YT_TABLE_PATH --proxy $YT_META_CLUSTER      2>/dev/null || true
fi

REPLICATED_TABLE_ID=$(\
    yt create replicated_table $YT_TABLE_PATH --attr "{
      dynamic=%true;
      schema=$YT_TABLE_SCHEMA
    }"  --proxy $YT_META_CLUSTER
); echo $REPLICATED_TABLE_ID

REPLICA_ID_ClUSTER_1=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH\";
        cluster_name=$YT_REPLICA_CLUSTER_1;
        replica_path=\"$YT_TABLE_PATH\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_1

REPLICA_ID_ClUSTER_2=$( \
    yt create table_replica --attr "{
        table_path=\"$YT_TABLE_PATH\";
        cluster_name=$YT_REPLICA_CLUSTER_2;
        replica_path=\"$YT_TABLE_PATH\"
    }" --proxy $YT_META_CLUSTER
); echo $REPLICA_ID_ClUSTER_2

TABLE_ID_1=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_1\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_1
); echo $TABLE_ID_1

TABLE_ID_2=$( \
    yt create table $YT_TABLE_PATH --attr "{
       dynamic=%true;
       upstream_replica_id=\"$REPLICA_ID_ClUSTER_2\";
       schema=$YT_TABLE_SCHEMA
    }" --proxy $YT_REPLICA_CLUSTER_2
); echo $TABLE_ID_2

yt mount-table   $YT_TABLE_PATH    --proxy $YT_META_CLUSTER
yt mount-table   $YT_TABLE_PATH    --proxy $YT_REPLICA_CLUSTER_1
yt mount-table   $YT_TABLE_PATH    --proxy $YT_REPLICA_CLUSTER_2

yt alter-table-replica "$REPLICA_ID_ClUSTER_1" --enable --mode sync  --proxy $YT_META_CLUSTER
yt alter-table-replica "$REPLICA_ID_ClUSTER_2" --enable --mode sync  --proxy $YT_META_CLUSTER

sleep 15
cat $YT_TABLE_DATA | yt insert-rows $YT_TABLE_PATH  --no-require-sync-replica  --format json  --proxy $YT_META_CLUSTER
yt select "* from [$YT_TABLE_PATH] limit 10" --format json --proxy $YT_META_CLUSTER

done

exit 0;
