#!/bin/bash

export YT_TOKEN=`cat ~/.yt/robot_token`

set -e
set -x

YT_META_CLUSTER='pythia'
YT_REPLICA_CLUSTER_1='freud'
YT_REPLICA_CLUSTER_2='hume'

YT_PROJECT_PATH='//home/partner/dict'
YT_TABLE_PATH="${YT_PROJECT_PATH}/target_tags"

if [[ $1 && $1 == "prod" ]];
then
    echo "~using PRODUCTION config";
    YT_META_CLUSTER='markov'
    YT_REPLICA_CLUSTER_1='hahn'
    YT_REPLICA_CLUSTER_2='arnold'

    DATA='{"id":1,"name":"portal-trusted","descr":"portal-trusted"}'$'\n''{"id":2,"name":"app-metro","descr":"app-metro"}'
else
    echo "~using TEST config";
    DATA='{"id":1,"name":"name1","descr":"descr1"}'$'\n''{"id":2,"name":"name2","descr":"descr2"}'$'\n''{"id":3,"name":"name3","descr":"descr3"}'$'\n''{"id":4,"name":"name4","descr":"descr4"}'$'\n''{"id":5,"name":"name5","descr":"descr5"}'
fi

echo "$DATA" | yt insert-rows $YT_TABLE_PATH  --no-require-sync-replica  --format json  --proxy $YT_META_CLUSTER
yt select "* from [$YT_TABLE_PATH] limit 10" --format json --proxy $YT_META_CLUSTER

exit 0;
