#!/usr/bin/perl

=encoding UTF-8

=head1 DESCRIPTION

Скрипт для изменения таблицы статистики в clickhouse

=head1 USAGE

perl ./migrations/before_release/PI-15786_natural_block_statistics_ch.pl --stage=test --pasword=xxxxxxxx

=head1 OPTIONS

  stage    - DB stage (test / prod)
  password - DB password

=cut

use qbit;

use Pod::Usage;
use Getopt::Long qw();

my %hosts = (
    test => {
        hosts => [
            qw(
              man-1t71zs5e3qalyfvq.db.yandex.net
              sas-h69utjbj38jrgroj.db.yandex.net

              )
        ],
        cluster => 'partner_prestable_cluster',
    },
    prod => {
        hosts => [
            qw(
              sas-mw8x8a7kp009dvql.db.yandex.net
              man-whecdgrou6tfa07o.db.yandex.net
              vla-ry73njvx8dfz1kec.db.yandex.net
              )
        ],
        cluster => 'partner_production_cluster',
    },
);

my $sql_template = '
ALTER TABLE partner.statistics ON CLUSTER %s
    MODIFY COLUMN
    product_id Enum8(%s);
';

my $enum = "
        'context_on_site_adblock' = 1,
        'context_on_site_direct' = 2,
        'context_on_site_market' = 3,
        'context_on_site_market_api' = 4,
        'context_on_site_mcb' = 5,
        'context_on_site_rtb' = 6,
        'context_on_site_stripe' = 7,
        'dsp' = 8,
        'internal_context_on_site_direct' = 9,
        'internal_context_on_site_rtb' = 10,
        'internal_context_on_site_stripe' = 11,
        'internal_mobile_app_rtb' = 12,
        'internal_search_on_site_direct' = 13,
        'internal_search_on_site_premium' = 14,
        'mobile_app_rtb' = 15,
        'search_on_site_direct' = 16,
        'search_on_site_market' = 17,
        'search_on_site_market_api' = 18,
        'search_on_site_mcb' = 19,
        'search_on_site_premium' = 20,
        'ssp_context_on_site_rtb' = 21,
        'ssp_mobile_app_rtb' = 22,
        'ssp_video_an_site_rtb' = 23,
        'video_an_site_fullscreen' = 24,
        'video_an_site_inpage' = 25,
        'video_an_site_instream' = 26,
        'context_on_site_adfox' = 27,
        'context_on_site_campaign' = 28,
        'search_on_site_campaign' = 29,
        'internal_context_on_site_campaign' = 30,
        'internal_search_on_site_campaign' = 31,
        'mobile_app_settings' = 32,
        'video_an_site' = 33,
        'ssp_context_on_site_campaign' = 34,
        'ssp_mobile_app_settings' = 35,
        'ssp_video_an_site' = 36,
        'context_on_site_content' = 37,
        'mobile_mediation_block' = 38,
        'internal_context_on_site_content' = 39,
        'indoor' = 40,
        'indoor_block' = 41,
        'outdoor' = 42,
        'outdoor_block' = 43,
        'context_on_site_natural' = 44,
        'internal_context_on_site_natural' = 45
";

sub _get_args {
    my $password;
    my $help  = 0;
    my $stage = 'test';

    Getopt::Long::GetOptions(
        'stage=s'    => \$stage,
        'password=s' => \$password,
        'help|?|h'   => \$help,
    ) or pod2usage(1);

    pod2usage(1) if !defined $password;

    pod2usage(-verbose => 2, -noperldoc => 1) if $help;

    return ($stage, $password);
}

sub get_connect {
    my ($host, $password) = @_;
    return sprintf 'clickhouse-client --secure --host=%s --port=9440 --user=partner --password=%s --database=partner',
      $host, $password;
}

sub main {

    my ($stage, $password) = _get_args;
    my $host = $hosts{$stage};

    die "You need correctly set STAGE value before running script..." unless $host;

    my $connect = get_connect($host->{hosts}[0], $password);
    my $sql = sprintf $sql_template, $host->{cluster}, $enum;
    $sql =~ s/[\n\r]/ /g;
    print "START\n";
    my $result = `echo "$sql" | $connect`;

    print "ALTERED: '$result'\n";
    for my $h (@{$host->{hosts}}) {
        my $c = get_connect($h, $password);
        print `echo "optimize table partner.statistics" | $c`;

    }
    print "DONE\n";
}

main();
