#!/usr/bin/perl
use lib::abs qw(
  ../../lib
  );

use qbit;
use Application;
use Utils::ScriptWrapper;

my $logins = {
    'a-a-company'            => 259620303,
    'a-masterova2015'        => 306031316,
    'a-v-bertram'            => 373208477,
    'action-reklama'         => 465371812,
    'admediator'             => 572934001,
    'adnews2019'             => 832318220,
    'adtech-rsya'            => 769503905,
    'adv24smi-org'           => 115861022,
    'advert-partner'         => 571466161,
    'advert-vgtrk'           => 842631452,
    'advert@pravda-ru'       => 1130000037594234,
    'adverti-me'             => 135250727,
    'agentstvo-ps'           => 272335304,
    'aleksander-roshal-ip'   => 525306695,
    'alexandr-oborsky'       => 314640282,
    'alvbars'                => 166455756,
    'artnikitenko'           => 272598751,
    'bizledi9'               => 389034792,
    'brooho'                 => 1069620,
    'bufferbay'              => 120618768,
    'coolmoney2008'          => 26897233,
    'daniel-lourie'          => 24333275,
    'dm-skuratov'            => 275297362,
    'echomoscu'              => 268870317,
    'elconsuelo'             => 468126857,
    'everestsales'           => 286013230,
    'expansepro'             => 752235274,
    'expert-online-direct2'  => 822087740,
    'fandirect'              => 331581417,
    'ficbookads'             => 272004463,
    'flagrylsk'              => 398120399,
    'gdeposylka777'          => 319294924,
    'hipdircorp'             => 322365557,
    'i-kozitcin'             => 531055608,
    'iisdp'                  => 283966077,
    'iliamo'                 => 2388626,
    'infolinkcheb'           => 103903073,
    'infoxru'                => 55699555,
    'iplazutina'             => 432169268,
    'ipusoff'                => 770726765,
    'ipvasilevav'            => 428292735,
    'izd-7dn'                => 103772246,
    'izvestiareader'         => 126049547,
    'jkuchkina'              => 130731473,
    'kdsya'                  => 90275471,
    'konstantinlitkevich-ip' => 224784319,
    'kornilias'              => 78275843,
    'kosko-d'                => 605218234,
    'kossapryk'              => 33762526,
    'lem4ik2'                => 32539575,
    'lookatmediartb'         => 467341605,
    'm-moevideo2017'         => 448216100,
    'matseratip'             => 567407610,
    'mds-1'                  => 78759828,
    'medtochki'              => 331036537,
    'mirtesen-staff'         => 163931645,
    'montemedia'             => 333970083,
    'mr-antonsilin'          => 78053795,
    'msn-p'                  => 196618050,
    'msvetinele'             => 362727557,
    'mylove-kassa'           => 358064528,
    'novgaz2011'             => 126200628,
    'ntvvideo'               => 575108260,
    'oletarutin'             => 68184443,
    'paramon-usk'            => 14226974,
    'pawsh'                  => 90455226,
    'pogoda5-ru'             => 96139542,
    'proaudits'              => 587432965,
    'profinance2007'         => 24028441,
    'pronens'                => 270148034,
    'pushkarev-car'          => 554599419,
    'razlozhi-ru'            => 281124929,
    'rbcpartner'             => 235409923,
    'regmarkets2'            => 234465273,
    'regnumtn'               => 283313003,
    'remontblizko'           => 30351227,
    'reshuoge'               => 348634574,
    'ridusreklama'           => 253838696,
    'rt-advertising'         => 318239794,
    'ru-kazantsev'           => 221070475,
    'ruclickio'              => 565013818,
    'rusnovostiru'           => 140362645,
    'russianfood-com'        => 512493160,
    's-v-potemkin'           => 253934362,
    'sivarev'                => 13831466,
    'slimushkabestsonoff'    => 124771297,
    'smi2smi2'               => 127810257,
    'smiads'                 => 421389639,
    'spacepush-ru'           => 546019348,
    'spina001'               => 13690671,
    'sport-e'                => 27743282,
    'super-adres'            => 34418873,
    'taborpartner'           => 850722267,
    'tarantin555'            => 96478928,
    'tarantin5555'           => 638060435,
    'tass-rtb'               => 346621599,
    'tisunov-pavel'          => 134974787,
    'tv-tsargrad'            => 508312530,
    'uraruy'                 => 192558578,
    'uznayvseru'             => 79245423,
    'v-makoviy'              => 64761266,
    'visinitsyn'             => 42136889,
    'vladislav-chernysch'    => 503953594,
    'vladtimemedia'          => 291719389,
    'vmdaily2012'            => 155398759,
    'vomedia'                => 246308854,
    'wetogether2'            => 109526938,
    'whitemrak'              => 14890142,
    'www9111ru'              => 39448349,
    'wwwrg'                  => 30970366,
    'ya-klevo'               => 95970952,
    'ya-newstube'            => 123251048,
    'zr-ru'                  => 30380460,
};

run(
    sub {
        my ($app, $opts) = @_;

        $app->set_cur_user({id => 0});
        my $tmp_rights         = $app->add_all_tmp_rights();
        my $page_id_field_name = $app->context_on_site_rtb->get_page_id_field_name;
        foreach my $login (keys %$logins) {
            print logstr ("processing login $login");
            $app->user_features->add($logins->{$login}, 'design_auction');

            my $pages = $app->context_on_site_campaign->get_all(
                fields => [qw(page_id)],
                filter => [
                    'AND',
                    [{owner_id => $logins->{$login}}, {multistate => 'not deleted and not rejected and not blocked'},]
                ],
            );
            foreach my $page (@$pages) {
                next unless $page->{page_id};
                my $blocks = $app->context_on_site_rtb->get_all(
                    fields => [qw(*)],
                    filter => [
                        'AND',
                        [
                            {login               => $login},
                            {$page_id_field_name => $page->{page_id}},
                            {multistate          => 'not deleted'},
                            [id                  => '<>' => 0],
                            [id                  => '<>' => 100500],
                        ]
                    ],
                );
                my @data_to_add;
                print logstr("Page $page->{page_id} " . scalar @$blocks);
                foreach my $block (@$blocks) {
                    next if $block->{is_constructed_format} || $block->{is_custom_bk_data};
                    my $templates = $app->context_on_site_rtb->update_design_template_by_fields($block);
                    print logstr ({$block->{public_id} => {fields => $block, templates => $templates}});
                    try {
                        $app->context_on_site_rtb->maybe_do_action($block->{public_id}, "edit", "design_templates",
                            $templates);
                    }
                    catch {
                        print logstr ("error updating block $block->{public_id} : " . $@->{text});
                    }
                }
            }
        }
    }
   );
