CREATE TABLE IF NOT EXISTS `notification` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `type` ENUM('custom', 'auto') NOT NULL DEFAULT 'custom',
    `view_type` ENUM('default', 'common_offer', 'custom_link', 'survey', 'top') NOT NULL DEFAULT 'default',
    `ttl` INT UNSIGNED NOT NULL,
    `caption_en` VARCHAR(255) NOT NULL, `caption_ru` VARCHAR(255) NOT NULL,
    `icon_id` INT UNSIGNED NOT NULL,
    `message_en` VARCHAR(1000) NOT NULL, `message_ru` VARCHAR(1000) NOT NULL,
    `button_caption_en` VARCHAR(255), `button_caption_ru` VARCHAR(255),
    `url` VARCHAR(255),
    `expectation_caption_en` VARCHAR(255), `expectation_caption_ru` VARCHAR(255),
    `estimated_value` INT UNSIGNED DEFAULT '0',
    `opts` JSON NOT NULL,
    PRIMARY KEY (`id`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `notification_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `notification_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `notification_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_notification_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_notification_action_log__elem_id___notification__id` (`elem_id`)
        REFERENCES `notification` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `user_notifications` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `notification_id` BIGINT UNSIGNED NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `create_date` DATETIME NOT NULL,
    `accessor` VARCHAR(255),
    `opts` JSON NOT NULL,
    PRIMARY KEY (`id`),
    INDEX `user_notifications__user_id` (`user_id`),
    INDEX `user_notifications__notification_id` (`notification_id`),
    FOREIGN KEY `fk_user_notifications__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_user_notifications__notification_id___notification__id` (`notification_id`)
        REFERENCES `notification` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `user_notifications_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `user_notifications_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `user_notifications_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_user_notifications_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_user_notifications_action_log__elem_id___user_notifications_` (`elem_id`)
        REFERENCES `user_notifications` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

-- Initial filling
INSERT INTO `notification`
        (
            `id`,
            `create_date`,
            `type`,
            `ttl`,
            `caption_en`,
            `caption_ru`,
            `icon_id`,
            `message_en`,
            `message_ru`,
            `opts`
        )
    VALUES
        -- Moderation: First approve
        (
            1,
            '1000-01-01 00:00:00',
            'auto',
            0,
            "Your resource has been accepted to YAN. Let's begin!",
            'Ваш ресурс принят в РСЯ. Начинаем!',
            0,
            '',
            'Поздравляем, ваш ресурс "[% resource | html %]" успешно прошёл модерацию! Вы можете разместить блоки Рекламной сети Яндекса на вашем ресурсе и начать зарабатывать на показах рекламы.',
            '{}'
        ),
        -- Moderation: Approve
        (
            2,
            '1000-01-01 00:00:00',
            'auto',
            0,
            'Your resource has been accepted to YAN',
            'Ваш ресурс принят в РСЯ',
            0,
            '',
            'Поздравляем, ваш ресурс "[% resource | html %]" успешно прошёл модерацию! Размещайте блоки Рекламной сети Яндекса и зарабатывайте на показах рекламы.',
            '{}'
        ),
        -- Moderation: Reject
        (
            3,
            '1000-01-01 00:00:00',
            'auto',
            0,
            'Moderation results',
            'Результаты модерации',
            0,
            '',
            'К сожалению, ваша заявка на участие ресурса "[% resource | html %]" в Рекламной сети Яндекса отклонена.',
            '{}'
        ),
        -- Block: Page
        (
            4,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Ваша площадка в заблокирована',
            0,
            '',
            'К сожалению, ваша площадка в Рекламной сети Яндекса заблокирована — на ресурсе [% name_page | html %] (Page ID: [% page_id %]) обнаружены нарушения Правил участия в РСЯ.',
            '{}'
        ),
        -- Block: Domain
        (
            5,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Ваш домен заблокирован',
            0,
            '',
            'К сожалению, ваш домен в Рекламной сети Яндекса заблокирован — на ресурсе [% name_site | html %]</strong> обнаружены нарушения Правил участия в РСЯ.',
            '{}'
        ),
        -- Block: Login
        (
            6,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Ваш аккаунт заблокирован',
            0,
            '',
            'К сожалению, ваш аккаунт [% login | html %] в Рекламной сети Яндекса заблокирован — на ресурсе обнаружены нарушения Правил участия в РСЯ.',
            '{}'
        ),
        -- First block
        (
            7,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Начните получать доход от рекламы',
            0,
            '',
            'Ваш сайт прошел модерацию в Рекламной сети Яндекса, но пока не приносит дохода. Чтобы начать зарабатывать:\n * Создайте RTB-блок для тематической площадки.\n * Разместите код блока у себя на сайте.',
            '{}'
        ),
        -- Money
        (
            8,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Мы готовы выплатить ваш первый доход',
            0,
            '',
            'Поздравляем! Доход вашего ресурса приближается к порогу выплат — скоро вы сможете получить вознаграждение. Чтобы мы могли его выплатить, пожалуйста, укажите платёжные реквизиты и приложите документы: в разделе «Документы» нажмите кнопку «Платежные реквизиты», а затем заполните форму.',
            '{}'
        ),
        -- Delete Page
        (
            9,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Площадка заархивирована',
            0,
            '',
            'Ваша площадка [% name_page | html %] (Page ID: [% page_id %]) заархивирована.',
            '{}'
        ),
        -- Stop Page
        (
            10,
            '1000-01-01 00:00:00',
            'auto',
            0,
            '',
            'Площадка остановлена',
            0,
            '',
            'Ваша площадка [% name_page | html %] (Page ID: [% page_id %]) остановлена.',
            '{}'
        );
