use partner;

/* PI-8779 start */

alter table ssp_seller add column `tmpl_ssp_video_app` text NOT NULL;
alter table ssp_seller add column `video_app_page_id` bigint(20) unsigned DEFAULT NULL COMMENT 'default page_id';

ANALYZE TABLE `ssp_seller`;

REPLACE `partner`.`role_rights` VALUES
    (2, 'ssp_video_app_view_all'),
    (15, 'ssp_video_app_view_all'),
    (16, 'ssp_video_app_view_all'),
    (17, 'ssp_video_app_view_all'),
    (38, 'ssp_video_app_view_all');

CREATE TABLE IF NOT EXISTS `ssp_video_app` (
    `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
    `create_date` DATETIME NOT NULL,
    `page_id` INT UNSIGNED,
    `owner_id` INT UNSIGNED NOT NULL,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `block_title` VARCHAR(255) DEFAULT '',
    `pictures_enabled` BOOLEAN NOT NULL DEFAULT '1',
    `behavioral_targeting` BOOLEAN NOT NULL DEFAULT '1',
    `mirrors` MEDIUMTEXT NOT NULL,
    `banner_langs` VARCHAR(255) NOT NULL DEFAULT '[\"by\",\"en\",\"kz\",\"ru\",\"uk\"]',
    `excluded_phones` MEDIUMTEXT NOT NULL DEFAULT '',
    `excluded_domains` MEDIUMTEXT NOT NULL DEFAULT '',
    `data_brands` MEDIUMTEXT,
    `data_articles` MEDIUMTEXT,
    `dsps` MEDIUMTEXT NOT NULL DEFAULT '',
    `app_type` TINYINT UNSIGNED NOT NULL,
    `app_id` VARCHAR(255) NOT NULL,
    `media_block` VARCHAR(10) NOT NULL,
    `direct_block` VARCHAR(10) NOT NULL,
    `dsp_blocks` MEDIUMTEXT NOT NULL,
    `limit` INT UNSIGNED,
    `cpa` INT UNSIGNED NOT NULL,
    `articles` MEDIUMTEXT,
    `brands` MEDIUMTEXT,
    `geo` MEDIUMTEXT,
    `mincpm` VARCHAR(16) NOT NULL DEFAULT '0',
    `alternative_code` TEXT NOT NULL,
    `border_radius` BOOLEAN,
    `border_type` VARCHAR(8),
    `favicon` BOOLEAN NOT NULL DEFAULT '0',
    `no_sitelinks` BOOLEAN NOT NULL DEFAULT '0',
    `links_underline` BOOLEAN NOT NULL DEFAULT '1',
    `site_bg_color` VARCHAR(6) NOT NULL,
    `bg_color` VARCHAR(6),
    `border_color` VARCHAR(6),
    `header_bg_color` VARCHAR(6),
    `sitelinks_color` VARCHAR(6),
    `title_color` VARCHAR(6) NOT NULL,
    `text_color` VARCHAR(6) NOT NULL,
    `url_color` VARCHAR(6) NOT NULL,
    `hover_color` VARCHAR(6) NOT NULL,
    `font_family` VARCHAR(15),
    `font_size` VARCHAR(3),
    `title_font_size` TINYINT UNSIGNED,
    `comment` TEXT,
    `strategy` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    `percent_traffic` SMALLINT UNSIGNED,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `no_video_app` BOOLEAN NOT NULL DEFAULT '0',
    `media_active` BOOLEAN,
    `media_blocked` BOOLEAN,
    `media_cpm` SMALLINT UNSIGNED,
    `text_active` BOOLEAN,
    `text_blocked` BOOLEAN,
    `text_cpm` SMALLINT UNSIGNED,
    `context` BOOLEAN NOT NULL DEFAULT '0',
    `fast_context` BOOLEAN NOT NULL DEFAULT '0',
    `only_picture` BOOLEAN NOT NULL DEFAULT '1',
    `family_filter` BOOLEAN NOT NULL DEFAULT '1',
    `update_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `send_time` DATETIME NOT NULL DEFAULT '0000-00-00 00:00:00',
    `seller_id` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_ssp_video_app__page_id` (`page_id`),
    FOREIGN KEY `fk_ssp_video_app__seller_id___ssp_seller__id` (`seller_id`)
        REFERENCES `ssp_seller` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_video_app__owner_id___ssp_seller__user_id` (`owner_id`)
        REFERENCES `ssp_seller` (`user_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `ssp_link_video_app` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `application_id` BIGINT UNSIGNED NOT NULL,
    `video_app_id` INT UNSIGNED DEFAULT NULL,
    `tokens` VARCHAR(10000) COLLATE 'utf8_bin' NOT NULL,
    `weight` BIGINT UNSIGNED NOT NULL,
    `seller_id` INT UNSIGNED NOT NULL,
    `comment` VARCHAR(4000),
    `moderation_reason_id` INT UNSIGNED,
    PRIMARY KEY (`id`),
    UNIQUE INDEX `uniq_ssp_link_video_app__seller_id_application_id` (`seller_id`, `application_id`),
    INDEX `ssp_link_video_app__application_id` (`application_id`),
    INDEX `ssp_link_video_app__video_app_id` (`video_app_id`),
    INDEX `ssp_link_video_app__tokens` (`tokens`),
    FOREIGN KEY `fk_ssp_link_video_app__application_id___ssp_application__id` (`application_id`)
        REFERENCES `ssp_application` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_video_app__video_app_id___ssp_video_app__id` (`video_app_id`)
        REFERENCES `ssp_video_app` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_video_app__seller_id___ssp_seller__id` (`seller_id`)
        REFERENCES `ssp_seller` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `ssp_video_app_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `ssp_video_app_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `ssp_video_app_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_ssp_video_app_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_video_app_action_log__elem_id___ssp_video_app__id` (`elem_id`)
        REFERENCES `ssp_video_app` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `statistics_ssp_video_app_page` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED,
    `an_fraud_shows` INT UNSIGNED NOT NULL,
    `an_fraud_clicks` INT UNSIGNED NOT NULL,
    `an_cover_hits` INT UNSIGNED NOT NULL,
    `an_cover_direct_hits` INT UNSIGNED NOT NULL,
    `an_cover_market_hits` INT UNSIGNED NOT NULL,
    `an_cover_mcb_hits` INT UNSIGNED NOT NULL,
    `an_cover_senthits` INT UNSIGNED NOT NULL,
    `an_rtb_cover_hits` INT UNSIGNED NOT NULL,
    `an_rtb_cover_senthits` INT UNSIGNED NOT NULL,
    `an_rtb_cover_direct_hits` INT UNSIGNED NOT NULL,
    `direct_context_page_ad_shows` INT UNSIGNED NOT NULL,
    `direct_context_hits` INT UNSIGNED NOT NULL,
    `mcb_context_hits` INT UNSIGNED NOT NULL,
    `market_context_hits` INT UNSIGNED NOT NULL,
    PRIMARY KEY (`dt`, `page_id`),
    FOREIGN KEY `fk_statistics_ssp_video_app_page__page_id___ssp_video_app__page_` (`page_id`)
        REFERENCES `ssp_video_app` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `statistics_ssp_video_app_rtb` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `rtb_block_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_bad_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_bad_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_bad_win_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_bad_win_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_bad_win_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_direct_clicks` INT UNSIGNED NOT NULL DEFAULT '0',
    `rtb_block_direct_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`),
    INDEX `statistics_ssp_video_app_rtb__page_id_block_id_dt` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_ssp_video_app_rtb__dsp_id_dt` (`dsp_id`, `dt`),
    FOREIGN KEY `fk_statistics_ssp_video_app_rtb__currency_id___currencies__id` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_statistics_ssp_video_app_rtb__page_id___ssp_video_app__page_i` (`page_id`)
        REFERENCES `ssp_video_app` (`page_id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `ssp_link_video_app_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_id` BIGINT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `ssp_link_video_app_action_log__dt_elem_id_action` (`dt`, `elem_id`, `action`),
    INDEX `ssp_link_video_app_action_log__elem_id_action` (`elem_id`, `action`),
    FOREIGN KEY `fk_ssp_link_video_app_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_ssp_link_video_app_action_log__elem_id___ssp_link_video_app__` (`elem_id`)
        REFERENCES `ssp_link_video_app` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

/* PI-8779 end */
/* PI-8794 start */

ALTER TABLE role_rights MODIFY COLUMN `right` varchar(128) NOT NULL;
ANALYZE TABLE role_rights;

REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'queue_add_statistics_intake' AS `right` FROM role_rights WHERE `right` = 'add_queue_statistics_intake') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'queue_add_update_in_bk' AS `right` FROM role_rights WHERE `right` = 'add_queue_update_in_bk') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'content_brand_add_video_an_site' AS `right` FROM role_rights WHERE `right` = 'add_video_an_site_content_brand') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'devel_bk_pi_comparison' AS `right` FROM role_rights WHERE `right` = 'bk_pi_comparison') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_context_on_site_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_dsp') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_response_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_dsp_response') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_advnet_context_on_site_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_advnet_search_on_site_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_direct_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_rtb_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_stripe_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_mobile_app_rtb_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_direct_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_premium_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_internal_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_mobile_app_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_search_on_site_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_ssp_context_rtb_rtb_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_ssp_context_rtb_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_ssp_mobile_app_rtb_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_ssp_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_taxopark_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_taxopark') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_page_can_be_reloaded' AS `right` FROM role_rights WHERE `right` = 'can_be_statistics_reloaded_video_an_site_page') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_charging_view_field__login' AS `right` FROM role_rights WHERE `right` = 'charging_stat_view_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_adfox_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_adfox_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_direct_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_direct_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_rtb_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_rtb_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'devel_create_client' AS `right` FROM role_rights WHERE `right` = 'create_client') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'devel_die' AS `right` FROM role_rights WHERE `right` = 'die') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__all_hits' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__all_hits') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__all_real_price' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__all_real_price') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__average_rate' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__average_rate') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__campaign' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__campaign') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__internal_context_campaign_id' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__internal_context_campaign_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__is_internal_campaign' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__is_internal_campaign') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_view_field__login' AS `right` FROM role_rights WHERE `right` = 'dsp_stat_view_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_rtb_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_rtb_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_dsps_save_dsps' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_save_dsps') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_mobile_app_rtb_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_mobile_app_rtb_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_mobile_app_dsps_save_dsps' AS `right` FROM role_rights WHERE `right` = 'internal_mobile_app_rtb_save_dsps') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_mobile_app_rtb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_mobile_app_rtb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_view_field__direct_context_page_ad_shows' AS `right` FROM role_rights WHERE `right` = 'internal_view_field__direct_context_page_ad_shows') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_view_field__direct_search_page_ad_shows' AS `right` FROM role_rights WHERE `right` = 'internal_view_field__direct_search_page_ad_shows') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_view_field__premium_page_ad_shows' AS `right` FROM role_rights WHERE `right` = 'internal_view_field__premium_page_ad_shows') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_view' AS `right` FROM role_rights WHERE `right` = 'invites_view') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_view_all' AS `right` FROM role_rights WHERE `right` = 'invites_view_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_add' AS `right` FROM role_rights WHERE `right` = 'invite_add') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_an_manager_assistant' AS `right` FROM role_rights WHERE `right` = 'invite_an_manager_assistant') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_an_partner' AS `right` FROM role_rights WHERE `right` = 'invite_an_partner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_an_partner_assistant' AS `right` FROM role_rights WHERE `right` = 'invite_an_partner_assistant') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_application_an_partner' AS `right` FROM role_rights WHERE `right` = 'invite_application_an_partner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_dsp_partner' AS `right` FROM role_rights WHERE `right` = 'invite_dsp_partner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_taxopark' AS `right` FROM role_rights WHERE `right` = 'invite_taxopark') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'inviter_video_an_partner' AS `right` FROM role_rights WHERE `right` = 'invite_video_an_partner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__comment' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__comment') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__caption' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit__settings_caption') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__allowed_native' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__allowed_native') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__bk_languages' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__block_title' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__block_title') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__context' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__context') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__false_click' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__false_click') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__fast_context' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__fast_context') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__filters' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__filters') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__no_mobile_app' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__no_mobile_app') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__only_picture' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__only_picture') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_edit_field__quality_coef' AS `right` FROM role_rights WHERE `right` = 'mobile_app_edit_field__quality_coef') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_rtb_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_rtb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_view_dimension_field__currency_id' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_view_dimension_field__currency_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_view_dimension_field__dsp_caption' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_view_dimension_field__dsp_caption') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_view_dimension_field__dsp_id_name' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_view_dimension_field__dsp_id_name') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_view_all_stat_fields' AS `right` FROM role_rights WHERE `right` = 'mobile_app_rtb_view_stat_field_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__allowed_native' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__allowed_native') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__bk_languages' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__bk_languages') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__block_title' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__block_title') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__comment' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__comment') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__context' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__context') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__false_click' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__false_click') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__fast_context' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__fast_context') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__filters' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__filters') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__no_mobile_app' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__no_mobile_app') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__only_picture' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__only_picture') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__owner' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__owner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__quality_coef' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__quality_coef') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_field__statistics_exists' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_field__statistics_exists') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_filter__client_id' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_filter__client_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_filter__context_page_id' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_filter__context_page_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_filter__login' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_filter__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mobile_app_settings_view_filter__owner' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_filter__owner') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_view_all_stat_fields' AS `right` FROM role_rights WHERE `right` = 'mobile_app_view_stat_field_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_accountant_on_cc' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_accountant_on_cc') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_from' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_from') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_reply_to' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_reply_to') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_subject' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_subject') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_to_only_subscribed' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_to_only_subscribed') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__send_when' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_send_when') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__show' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_show') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__show_from' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_show_from') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_admin_view_field__show_to' AS `right` FROM role_rights WHERE `right` = 'notification_admin_view_field_show_to') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_accountant_on_cc' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_accountant_on_cc') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_from' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_from') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_reply_to' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_reply_to') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_subject' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_subject') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_to_only_subscribed' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_to_only_subscribed') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__send_when_days_delta' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_send_when_days_delta') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__show' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_show') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__show_from_days_delta' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_show_from_days_delta') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'notification_template_view_field__show_to_days_delta' AS `right` FROM role_rights WHERE `right` = 'notification_template_view_field_show_to_days_delta') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_direct_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_direct_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_premium_edit_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_premium_edit_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adblock_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_adblock') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adfox_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_adfox') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_dsp_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_dsp') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_direct_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_advnet_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_advnet_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_context_on_site_stripe_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_advnet_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_direct_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_advnet_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_advnet_search_on_site_premium_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_advnet_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_internal_mobile_app_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_internal_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_ssp_context_rtb_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_ssp_context_rtb_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_ssp_mobile_app_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_ssp_mobile_app_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_taxopark_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_taxopark') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_mcb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_search_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_api_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_market_api') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_direct_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_stripe_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_rtb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_api_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_search_on_site_market_api') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_direct_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_mcb_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_search_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_premium_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_inpage_an_site') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_publisher_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_video_an_site_inpage_publisher') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_video_an_site') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_publisher_always_view' AS `right` FROM role_rights WHERE `right` = 'statistics_always_view_video_an_site_instream_publisher') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adblock_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_adblock_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adfox_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_adfox_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_direct_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_direct_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_api_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_market_api_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_market_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_mcb_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_mcb_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_premium_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_premium_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_rtb_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_rtb_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_stripe_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_stripe_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_view_filter__login' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_view_filter__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_direct_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_direct_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_api_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_market_api_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_market_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_mcb_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_mcb_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_premium_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_premium_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_view_entity_field__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_view_entity_field__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_view_filter__login' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_view_filter__login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__client_id' AS `right` FROM role_rights WHERE `right` = 'users_view_field_client_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__contract_id' AS `right` FROM role_rights WHERE `right` = 'users_view_field_contract_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__email' AS `right` FROM role_rights WHERE `right` = 'users_view_field_email') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__login' AS `right` FROM role_rights WHERE `right` = 'users_view_field_login') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__multistate' AS `right` FROM role_rights WHERE `right` = 'users_view_field_multistate') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__roles' AS `right` FROM role_rights WHERE `right` = 'users_view_field_roles') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'content_brand_view_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_content_brand_view_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'content_type_view_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_content_type_view_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'dictionary_words_view_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_dictionary_words_view_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'video_an_site_inpage_dsps_save_dsps' AS `right` FROM role_rights WHERE `right` = 'video_an_site_inpage_save_dsps') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_view_dimension_field__currency_id' AS `right` FROM role_rights WHERE `right` = 'video_an_site_inpage_view_dimension_field__currency_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_view_dimension_field__dsp_caption' AS `right` FROM role_rights WHERE `right` = 'video_an_site_inpage_view_dimension_field__dsp_caption') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_view_dimension_field__dsp_id_name' AS `right` FROM role_rights WHERE `right` = 'video_an_site_inpage_view_dimension_field__dsp_id_name') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_inpage_view_stat_field_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_inpage_view_stat_field_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'video_an_site_instream_dsps_save_dsps' AS `right` FROM role_rights WHERE `right` = 'video_an_site_instream_save_dsps') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_view_dimension_field__currency_id' AS `right` FROM role_rights WHERE `right` = 'video_an_site_instream_view_dimension_field__currency_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_view_dimension_field__dsp_caption' AS `right` FROM role_rights WHERE `right` = 'video_an_site_instream_view_dimension_field__dsp_caption') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_view_dimension_field__dsp_id_name' AS `right` FROM role_rights WHERE `right` = 'video_an_site_instream_view_dimension_field__dsp_id_name') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_instream_view_stat_field_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_instream_view_stat_field_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_video_an_site_view_stat_field_all' AS `right` FROM role_rights WHERE `right` = 'video_an_site_view_stat_field_all') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'models_soap_api_view_bk_send_log' AS `right` FROM role_rights WHERE `right` = 'view_bk_send_log') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'mailer_view' AS `right` FROM role_rights WHERE `right` = 'view_info_about_mails') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_rtb_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_stripe_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_premium_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'video_an_site_view' AS `right` FROM role_rights WHERE `right` = 'view_video_an_site') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_adfox_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_adfox_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_direct_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_direct_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_rtb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_rtb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_view_field__direct_ad_coverage' AS `right` FROM role_rights WHERE `right` = 'context_view_field__direct_ad_coverage') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_view_field__direct_ad_reach' AS `right` FROM role_rights WHERE `right` = 'context_view_field__direct_ad_reach') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_direct_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_direct_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_premium_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_premium_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adblock_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_adblock_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_adfox_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_adfox_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_direct_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_direct_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_api_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_market_api_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_market_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_market_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_mcb_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_mcb_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_rtb_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_rtb_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_stripe_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_stripe_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_context_on_site_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_context_on_site_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_direct_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_direct_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_api_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_market_api_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_market_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_market_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_mcb_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_mcb_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_premium_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_premium_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_advnet_search_on_site_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_search_on_site_view_all_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_adfox_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_adfox') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_market_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_mcb_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_rtb_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_stripe_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_direct_view_blocks' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_market_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_mcb_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_premium_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'tns_dict_brand_view' AS `right` FROM role_rights WHERE `right` = 'view_tns_dict_brand') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_mobile_app_view_all_stat_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'statistics_mobile_app_rtb_view_all_fields' AS `right` FROM role_rights WHERE `right` = 'statistics_mobile_app_rtb_view_all_stat_fields') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_campaign_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_campaign_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_campaign_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_campaign_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_rtb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_rtb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'news_view_field__user_id' AS `right` FROM role_rights WHERE `right` = 'news_view_field_user_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'users_view_field__user_id' AS `right` FROM role_rights WHERE `right` = 'users_view_field_user_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'taxopark_view_field__user_id' AS `right` FROM role_rights WHERE `right` = 'taxopark_view_field_user_id') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_direct_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_direct_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_premium_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_search_on_site_premium_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_direct_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_direct_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_stripe_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_stripe_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_rtb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'internal_context_on_site_rtb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_market_api_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_market_api_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_mcb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_mcb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_market_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'context_on_site_market_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_market_api_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_market_api_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_mcb_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_mcb_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_market_view_field__bk_data' AS `right` FROM role_rights WHERE `right` = 'search_on_site_market_view_bk_data') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_view_widget' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_widget') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'resources_view' AS `right` FROM role_rights WHERE `right` = 'view_resources') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'geo_base_view' AS `right` FROM role_rights WHERE `right` = 'view_geo_base') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_adfox_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_adfox') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_market_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_mcb_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_rtb_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'context_on_site_stripe_view' AS `right` FROM role_rights WHERE `right` = 'view_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'info_about_mails_view' AS `right` FROM role_rights WHERE `right` = 'view_info_about_mails') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_rtb_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_rtb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_context_on_site_stripe_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_context_on_site_stripe') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'internal_search_on_site_premium_view' AS `right` FROM role_rights WHERE `right` = 'view_internal_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'rtb_settings_view' AS `right` FROM role_rights WHERE `right` = 'view_rtb_settings') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_direct_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_direct') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_market_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_market') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_mcb_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_mcb') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'search_on_site_premium_view' AS `right` FROM role_rights WHERE `right` = 'view_search_on_site_premium') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'tns_dict_brand_view' AS `right` FROM role_rights WHERE `right` = 'view_tns_dict_brand') t;
REPLACE INTO role_rights (role_id, `right`) select t.role_id, t.`right` from (SELECT role_id, 'video_an_site_view' AS `right` FROM role_rights WHERE `right` = 'view_video_an_site') t;

/* PI-8794 end */
INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report_by_login', 'advnet_on_site', 'Отчет по рекламе на сайтах для логина ${login} за 30 дней', 'Отчет по рекламе на сайтах для логина ${login} за 30 дней', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["an_campaign_caption","page_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах для логина ${login} за 30 дней',
    `caption_en`='Report on website advertisements for ${login} login for past 30 days',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["an_campaign_caption","page_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report', 'advnet_on_site', 'Отчет по рекламе на сайтах за ${period||30days}', 'Отчет по рекламе на сайтах за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["page_id","an_campaign_caption"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах за ${period||30days}',
    `caption_en`='Report on website advertisements for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["page_id","an_campaign_caption"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('all_payments', 'payment', 'Доход по всем видам рекламы за ${period||90days}', 'Доход по всем видам рекламы за ${period||90days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","mobile_rtb_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Доход по всем видам рекламы за ${period||90days}',
    `caption_en`='Revenue from all types of advertisements for ${period||90days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","mobile_rtb_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report_by_block_id', 'advnet_context_on_site_adblock', 'Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_shows_own_adv","adblock_block_hits","adblock_block_hits_own_adv","adblock_block_hits_unsold","adblock_partner_wo_nds","adblock_block_winrate","adblock_block_visibility","adblock_block_all_hits","adblock_block_cover_ratio","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Adblock block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_shows_own_adv","adblock_block_hits","adblock_block_hits_own_adv","adblock_block_hits_unsold","adblock_partner_wo_nds","adblock_block_winrate","adblock_block_visibility","adblock_block_all_hits","adblock_block_cover_ratio","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)', 'Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)',
    `caption_en`='Adblock blocks report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report_by_page_id', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adblock_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for Adblock blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adblock_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (без детализации по дням)', 'Отчет по блокам Adblock за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock за ${period||30days} (без детализации по дням)',
    `caption_en`='Adblock report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report_by_block_id', 'advnet_context_on_site_adfox', 'Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_shows_own_adv","adfox_block_hits","adfox_block_hits_own_adv","adfox_block_hits_unsold","adfox_partner_wo_nds","adfox_block_winrate","adfox_block_visibility","adfox_block_all_hits","adfox_block_cover_ratio","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the ADFOX ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_shows_own_adv","adfox_block_hits","adfox_block_hits_own_adv","adfox_block_hits_unsold","adfox_partner_wo_nds","adfox_block_winrate","adfox_block_visibility","adfox_block_all_hits","adfox_block_cover_ratio","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (с детализацией по дням)', 'Отчет по ADFOX за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по ADFOX за ${period||30days} (с детализацией по дням)',
    `caption_en`='ADFOX report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report_by_page_id', 'advnet_context_on_site_adfox', 'Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on ADFOX blocks for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (без детализации по дням)', 'Отчет по ADFOX за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по ADFOX за ${period||30days} (без детализации по дням)',
    `caption_en`='ADFOX report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report_by_block_id', 'advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the Direct ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Direct report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Отчет по Директу за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}', 'Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}',
    `caption_en`='Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report', 'advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_income', 'advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Доход по рекламе на тематических площадках за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Доход по рекламе на тематических площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on theme-based ad platforms for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_detailed_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (с детализацией по дням)', 'Отчет по API Маркета за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета за ${period||30days} (с детализацией по дням)',
    `caption_en`='API Market report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report_by_page_id', 'advnet_context_on_site_market_api', 'Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_context_clicks","market_api_context_shows","market_api_context_ctr","market_api_context_partner_wo_nds","market_api_context_cpm_market_api_context_partner_wo_nds","market_api_context_cpc_market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on API Market for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_context_clicks","market_api_context_shows","market_api_context_ctr","market_api_context_partner_wo_nds","market_api_context_cpm_market_api_context_partner_wo_nds","market_api_context_cpc_market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (без детализации по дням)', 'Отчет по API Маркета за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"market_api_context_all_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["currency_id","context_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета за ${period||30days} (без детализации по дням)',
    `caption_en`='API Market report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"market_api_context_all_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["currency_id","context_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report_by_page_id', 'advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_context_partner_wo_nds","stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_context_partner_wo_nds","stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report', 'advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Отчет по рекламе на тематических площадках за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Отчет по рекламе на тематических площадках за ${period||30days}',
    `caption_en`='Report on theme-based ad platform advertisement for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report_by_block_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_partner_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_partner_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (с детализацией по дням)',
    `caption_en`='RTB report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'Отчет по RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}', 'Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}',
    `caption_en`='RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report_by_block_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Stripe ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (с детализацией по дням)',
    `caption_en`='Stripe report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report_by_page_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Stripes report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (без детализации по дням)',
    `caption_en`='Stripe report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_by_dsp_id', 'dsp', 'Отчет для DSP ID ${dsp_id} «${name}»', 'Отчет для DSP ID ${dsp_id} «${name}»', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет для DSP ID ${dsp_id} «${name}»',
    `caption_en`='Report for DSP ID ${dsp_id} "${name}"',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report', 'dsp', 'Отчет по DSP за ${period||thismonth} (с детализацией по дням)', 'Отчет по DSP за ${period||thismonth} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP за ${period||thismonth} (с детализацией по дням)',
    `caption_en`='DSP report for ${period||thismonth} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_last_month', 'dsp', 'Отчет по DSP за ${period||lastmonth} (с детализацией по дням)', 'Отчет по DSP за ${period||lastmonth} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||lastmonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||lastmonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP за ${period||lastmonth} (с детализацией по дням)',
    `caption_en`='DSP report for ${period||lastmonth} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||lastmonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||lastmonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report_by_caption', 'dsp', 'Отчет по DSP ${caption} за ${period||30days}', 'Отчет по DSP ${caption} за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["dsp_bids","dsp_shows","dsp_charging_w_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["short_caption","LIKE","${caption}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP ${caption} за ${period||30days}',
    `caption_en`='DSP ${caption} report for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["dsp_bids","dsp_shows","dsp_charging_w_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["short_caption","LIKE","${caption}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report', 'dsp', 'Начислено DSP за ${period||90days} (без детализации по дням)', 'Начислено DSP за ${period||90days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Начислено DSP за ${period||90days} (без детализации по дням)',
    `caption_en`='DSP charged for ${period||90days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report_by_domain', 'internal_advnet_on_site', 'Отчет по домену ${domain} за ${period||30days}', 'Отчет по домену ${domain} за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_w_nds","rtb_all_w_nds","premium_all_w_nds","direct_context_all_w_nds","direct_search_all_w_nds","all_w_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":["AND",[["domain","LIKE","${domain}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_on_site',
    `caption_ru`='Отчет по домену ${domain} за ${period||30days}',
    `caption_en`='${domain} domain report for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_w_nds","rtb_all_w_nds","premium_all_w_nds","direct_context_all_w_nds","direct_search_all_w_nds","all_w_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":["AND",[["domain","LIKE","${domain}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report', 'internal_advnet_on_site', 'Отчет по рекламе на сайтах', 'Отчет по рекламе на сайтах', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day","page_id"],"dimension_filter":null,"entity_fields":["domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах',
    `caption_en`='Report on website advertisements',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day","page_id"],"dimension_filter":null,"entity_fields":["domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report_by_block_id', 'internal_advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the Direct ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","public_id"],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","public_id"],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Отчет по Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_income', 'internal_advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Доход по рекламе на тематических площадках за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Доход по рекламе на тематических площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on theme-based ad platforms for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report_by_page_id', 'internal_advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report', 'internal_advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Отчет по рекламе на тематических площадках за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Отчет по рекламе на тематических площадках за ${period||30days}',
    `caption_en`='Report on theme-based ad platform advertisement for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report_by_block_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_all_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_all_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (с детализацией по дням)',
    `caption_en`='RTB report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'Отчет по RTB за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_search_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"rtb_search_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report_by_block_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Stripe ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (с детализацией по дням)',
    `caption_en`='Stripe report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report_by_page_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Stripes report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (без детализации по дням)',
    `caption_en`='Stripe report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_income', 'internal_mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Доход по рекламе в мобильных приложениях за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Доход по рекламе в мобильных приложениях за ${period||10days}',
    `caption_en`='Revenue from mobile application advertisements for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report_by_page_id', 'internal_mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='${page_id} "${name}" mobile application report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report', 'internal_mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","caption"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","caption"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report_by_block_id', 'internal_mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_all_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Mobile RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_all_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report_by_page_id', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}', 'Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","=",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","IN",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","=",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","IN",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_detailed_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_all_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_all_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_income', 'internal_advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Доход по рекламе на поисковых площадках за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Доход по рекламе на поисковых площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on search ad platform for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report_by_block_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${period||30days} (с детализацией по дням)', 'Отчет по Спецразмещению ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${period||30days} (с детализацией по дням)',
    `caption_en`='Premium placement report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report_by_page_id', 'internal_advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report', 'internal_advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Отчет по рекламе на поисковых площадках за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Отчет по рекламе на поисковых площадках за ${period||30days}',
    `caption_en`='Report on search ad platform advertisements for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_income', 'mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Доход по рекламе в мобильных приложениях за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Доход по рекламе в мобильных приложениях за ${period||10days}',
    `caption_en`='Revenue from mobile application advertisements for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_login', 'mobile_app', 'Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","context_page_id"],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${login} login for past 30 days (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","context_page_id"],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_page_id', 'mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='${page_id} "${name}" mobile application report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report', 'mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report_by_block_id', 'mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_partner_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Mobile RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_partner_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report_by_page_id', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}', 'Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_all_payments', 'payment', 'Доход по всем видам рекламы за период ${period_current} со сравнением', 'Доход по всем видам рекламы за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Доход по всем видам рекламы за период ${period_current} со сравнением',
    `caption_en`='Revenue from all types of advertisements for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_adfox', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'Отчет по ADFOX за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по ADFOX за период ${period_current} со сравнением',
    `caption_en`='ADFOX report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_direct', 'payment', 'Отчет по Директу за период ${period_current} со сравнением', 'Отчет по Директу за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Директу за период ${period_current} со сравнением',
    `caption_en`='Direct report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_rtb', 'payment', 'Отчет по RTB за период ${period_current} со сравнением', 'Отчет по RTB за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по RTB за период ${period_current} со сравнением',
    `caption_en`='RTB report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_stripe', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'Отчет по ADFOX за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по ADFOX за период ${period_current} со сравнением',
    `caption_en`='ADFOX report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_mobile_rtb', 'payment', 'Отчет по мобильным RTB-блокам за период ${period_current} со сравнением', 'Отчет по мобильным RTB-блокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по мобильным RTB-блокам за период ${period_current} со сравнением',
    `caption_en`='Report on mobile RTB blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_direct', 'payment', 'Отчет по поисковому Директу за период ${period_current} со сравнением', 'Отчет по поисковому Директу за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по поисковому Директу за период ${period_current} со сравнением',
    `caption_en`='Search Direct report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_premium', 'payment', 'Отчет по Спецразмещению за период ${period_current} со сравнением', 'Отчет по Спецразмещению за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Спецразмещению за период ${period_current} со сравнением',
    `caption_en`='Premium placement report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_inpage_block', 'payment', 'Отчет по InPage видеоблокам за период ${period_current} со сравнением', 'Отчет по InPage видеоблокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по InPage видеоблокам за период ${period_current} со сравнением',
    `caption_en`='Report on InPage video blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_instream_block', 'payment', 'Отчет по Instream видеоблокам за период ${period_current} со сравнением', 'Отчет по Instream видеоблокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Instream видеоблокам за период ${period_current} со сравнением',
    `caption_en`='Report on Instream video blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report_by_block_id', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct ${block_id} "${name}" report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","tag_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","tag_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_income', 'advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Доход по рекламе на поисковых площадках за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Доход по рекламе на поисковых площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on search ad platforms for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_detailed_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search API Market report for ${period||30days} (with daily details)',
    `query`='{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report_by_page_id', 'advnet_search_on_site_market_api', 'Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_search_clicks","market_api_search_shows","market_api_search_ctr","market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_cpc_market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on search API Market for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_search_clicks","market_api_search_shows","market_api_search_ctr","market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_cpc_market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)', 'Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_all_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)',
    `caption_en`='Search API Market report for ${period||30days} (without daily details)',
    `query`='{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_all_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report_by_block_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)', 'Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)',
    `caption_en`='Premium placement report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report_by_page_id', 'advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["direct_search_partner_wo_nds","market_api_search_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_search_partner_wo_nds","premium_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["direct_search_partner_wo_nds","market_api_search_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_search_partner_wo_nds","premium_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report', 'advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Отчет по рекламе на поисковых площадках за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Отчет по рекламе на поисковых площадках за ${period||30days}',
    `caption_en`='Report on search ad platforms advertisements for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('ssp_report', 'ssp', 'Отчет по SSP за ${period||30days} (без детализации по дням)', 'Отчет по SSP за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"all_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","name"],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='ssp',
    `caption_ru`='Отчет по SSP за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on SSP for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"all_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","name"],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_income', 'video_an_site', 'Доход по видеорекламе за ${period||10days}', 'Доход по видеорекламе за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["instream_partner_wo_nds","inpage_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"video_an_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Доход по видеорекламе за ${period||10days}',
    `caption_en`='Revenue from video advertisement for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["instream_partner_wo_nds","inpage_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"video_an_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report_by_block_id', 'video_an_site_inpage', 'Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_block_hits_own_adv","inpage_block_shows_own_adv","inpage_block_hits_unsold","inpage_block_all_hits","inpage_partner_wo_nds","inpage_block_winrate","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='InPage video block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_block_hits_own_adv","inpage_block_shows_own_adv","inpage_block_hits_unsold","inpage_block_all_hits","inpage_partner_wo_nds","inpage_block_winrate","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)', 'Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on InPage video blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report_by_page_id', 'video_an_site_inpage', 'Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on InPage video blocks for ${page_id} "${name}" resource for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)', 'Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"inpage_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on InPage video blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"inpage_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report_by_block_id', 'video_an_site_instream', 'Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_block_hits_own_adv","instream_block_shows_own_adv","instream_block_hits_unsold","instream_block_all_hits","instream_partner_wo_nds","instream_block_winrate","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Instream video block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_block_hits_own_adv","instream_block_shows_own_adv","instream_block_hits_unsold","instream_block_all_hits","instream_partner_wo_nds","instream_block_winrate","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)', 'Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on Instream video blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report_by_page_id', 'video_an_site_instream', 'Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Instream video blocks for ${page_id} "${name}" resource for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)', 'Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"instream_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on Instream video blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"instream_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_report_by_page_id', 'video_an_site', 'Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" video resource for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_partner_wo_nds","inpage_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report_by_login', 'video_an_site', 'Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)', 'Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_block_hits","inpage_block_hits","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","instream_block_visibility","inpage_block_visibility","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)',
    `caption_en`='Video advertisement report for ${login} login for past 30 days (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_block_hits","inpage_block_hits","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","instream_block_visibility","inpage_block_visibility","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report', 'video_an_site', 'Отчет по видеорекламе за ${period||30days} (без детализациии по дням)', 'Отчет по видеорекламе за ${period||30days} (без детализациии по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_block_hits","inpage_block_hits","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","instream_block_visibility","inpage_block_visibility","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеорекламе за ${period||30days} (без детализациии по дням)',
    `caption_en`='Video advertisement report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["instream_block_hits","inpage_block_hits","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","instream_block_visibility","inpage_block_visibility","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

/* PI-5547 start */

update role_rights set `right` = 'dsp_view_action_log' where `right` = 'dsp_view_log';
update role_rights set `right` = 'site_view_action_log' where `right` = 'site_view_log';

/* PI-5547 end */
/* PI-8873 start */

CREATE TABLE IF NOT EXISTS `statistics_video_an_site_fullscreen_publisher` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `publisher_id` VARCHAR(255) NOT NULL DEFAULT '',
    `content_id` VARCHAR(255) NOT NULL DEFAULT '',
    `publisher_name` VARCHAR(255) NOT NULL DEFAULT '',
    `content_name` VARCHAR(255) NOT NULL DEFAULT '',
    `clid` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `video_bk_all_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `bk_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bk_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`, `publisher_id`, `content_id`, `clid`),
    INDEX `statistics_video_an_site_fullscreen_publisher__page_id_block_id_` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_video_an_site_fullscreen_publisher__dsp_id_dt` (`dsp_id`, `dt`),
    INDEX `statistics_video_an_site_fullscreen_publisher__clid_content_id_c` (`clid`, `content_id`, `content_name`, `currency_id`, `page_id`, `publisher_id`, `publisher_name`)
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `statistics_video_an_site_fullscreen` (
    `dt` DATE NOT NULL,
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` INT UNSIGNED NOT NULL,
    `currency_id` TINYINT UNSIGNED NOT NULL DEFAULT '2',
    `fullscreen_block_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `all_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_partner_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_partner_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_bad_shows` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_bad_shows_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_bad_win_hits` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_bad_win_hits_own_adv` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_block_bad_win_hits_unsold` INT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `fullscreen_bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_w_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `bad_win_partner_price_wo_nds` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    PRIMARY KEY (`dt`, `page_id`, `block_id`, `dsp_id`, `currency_id`),
    INDEX `statistics_video_an_site_fullscreen__page_id_block_id_dt` (`page_id`, `block_id`, `dt`),
    INDEX `statistics_video_an_site_fullscreen__dsp_id_dt` (`dsp_id`, `dt`),
    FOREIGN KEY `fk_statistics_video_an_site_fullscreen__currency_id___currencies` (`currency_id`)
        REFERENCES `currencies` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `video_an_site_fullscreen` (
    `page_id` INT UNSIGNED NOT NULL,
    `id` INT UNSIGNED NOT NULL,
    `create_date` DATETIME NOT NULL,
    `caption` VARCHAR(255) NOT NULL DEFAULT '',
    `multistate` BIGINT UNSIGNED NOT NULL DEFAULT '0',
    `mincpm` SMALLINT UNSIGNED NOT NULL DEFAULT '0',
    `articles` MEDIUMTEXT,
    `brands` MEDIUMTEXT,
    `geo` MEDIUMTEXT,
    `blind` TINYINT UNSIGNED NOT NULL DEFAULT '0',
    `category_id` BIGINT UNSIGNED NOT NULL,
    `category_path` VARCHAR(255) NOT NULL DEFAULT '',
    `type` TINYINT UNSIGNED NOT NULL,
    `comment` VARCHAR(255) NOT NULL DEFAULT '',
    `max_duration` TINYINT UNSIGNED NOT NULL DEFAULT '180',
    `alternative_code` MEDIUMTEXT,
    `is_custom_bk_data` BOOLEAN NOT NULL DEFAULT '0',
    `bk_data` MEDIUMTEXT,
    `adfox_block` BOOLEAN NOT NULL DEFAULT '0',
    PRIMARY KEY (`page_id`, `id`),
    INDEX `video_an_site_fullscreen__multistate` (`multistate`),
    INDEX `video_an_site_fullscreen__id` (`id`),
    FOREIGN KEY `fk_video_an_site_fullscreen__page_id___video_an_site__id` (`page_id`)
        REFERENCES `video_an_site` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `video_an_site_fullscreen_action_log` (
    `id` BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    `dt` DATETIME NOT NULL,
    `user_id` BIGINT UNSIGNED NOT NULL,
    `elem_page_id` INT UNSIGNED NOT NULL,
    `elem_id` INT UNSIGNED NOT NULL,
    `old_multistate` BIGINT UNSIGNED NOT NULL,
    `action` VARCHAR(100) NOT NULL,
    `new_multistate` BIGINT UNSIGNED NOT NULL,
    `opts` TEXT NOT NULL,
    `comment` VARCHAR(100) NOT NULL DEFAULT '',
    PRIMARY KEY (`id`),
    INDEX `video_an_site_fullscreen_action_log__dt_elem_page_id_elem_id_act` (`dt`, `elem_page_id`, `elem_id`, `action`),
    INDEX `video_an_site_fullscreen_action_log__elem_page_id_elem_id_action` (`elem_page_id`, `elem_id`, `action`),
    FOREIGN KEY `fk_video_an_site_fullscreen_action_log__user_id___users__id` (`user_id`)
        REFERENCES `users` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT,
    FOREIGN KEY `fk_video_an_site_fullscreen_action_log__elem_page_id_elem_id___v` (`elem_page_id`, `elem_id`)
        REFERENCES `video_an_site_fullscreen` (`page_id`, `id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

CREATE TABLE IF NOT EXISTS `video_an_site_block_dsps` (
    `page_id` INT UNSIGNED NOT NULL,
    `block_id` INT UNSIGNED NOT NULL,
    `dsp_id` BIGINT UNSIGNED NOT NULL,
    `show_count` TINYINT UNSIGNED,
    `interval` MEDIUMINT UNSIGNED,
    `is_deleted` BOOLEAN NOT NULL DEFAULT '0',
    PRIMARY KEY (`page_id`, `block_id`, `dsp_id`),
    FOREIGN KEY `fk_video_an_site_block_dsps__dsp_id___dsp__id` (`dsp_id`)
        REFERENCES `dsp` (`id`)
            ON UPDATE RESTRICT
            ON DELETE RESTRICT
) ENGINE='InnoDB' DEFAULT CHARACTER SET 'UTF8';

REPLACE `video_an_site_block_dsps` SELECT * FROM `video_an_site_inpage_dsps`;
REPLACE `video_an_site_block_dsps` SELECT * FROM `video_an_site_instream_dsps`;

REPLACE `partner`.`role_rights` VALUES
    (2, 'video_an_site_fullscreen_add'),
    (2, 'video_an_site_fullscreen_edit'),
    (2, 'video_an_site_fullscreen_edit_field__adfox_block'),
    (2, 'video_an_site_fullscreen_edit_field__bk_data'),
    (2, 'video_an_site_fullscreen_edit_field__blind'),
    (2, 'video_an_site_fullscreen_edit_field__comment'),
    (2, 'video_an_site_fullscreen_view'),
    (2, 'video_an_site_fullscreen_view_action_log'),
    (2, 'video_an_site_fullscreen_view_all'),
    (2, 'video_an_site_fullscreen_view_field__bk_data'),
    (2, 'video_an_site_fullscreen_view_field__blind'),
    (2, 'video_an_site_fullscreen_view_field__comment'),
    (2, 'video_an_site_fullscreen_view_field__get_code'),
    (2, 'video_an_site_fullscreen_view_filter__login'),
    (15, 'video_an_site_fullscreen_add'),
    (15, 'video_an_site_fullscreen_edit'),
    (15, 'video_an_site_fullscreen_edit_field__bk_data'),
    (15, 'video_an_site_fullscreen_edit_field__blind'),
    (15, 'video_an_site_fullscreen_edit_field__comment'),
    (15, 'video_an_site_fullscreen_view'),
    (15, 'video_an_site_fullscreen_view_action_log'),
    (15, 'video_an_site_fullscreen_view_all'),
    (15, 'video_an_site_fullscreen_view_field__bk_data'),
    (15, 'video_an_site_fullscreen_view_field__blind'),
    (15, 'video_an_site_fullscreen_view_field__comment'),
    (15, 'video_an_site_fullscreen_view_field__get_code'),
    (15, 'video_an_site_fullscreen_view_filter__login'),
    (17, 'video_an_site_fullscreen_view'),
    (17, 'video_an_site_fullscreen_view_action_log'),
    (17, 'video_an_site_fullscreen_view_all'),
    (17, 'video_an_site_fullscreen_view_field__blind'),
    (17, 'video_an_site_fullscreen_view_field__comment'),
    (17, 'video_an_site_fullscreen_view_field__get_code'),
    (20, 'video_an_site_fullscreen_add'),
    (20, 'video_an_site_fullscreen_edit'),
    (20, 'video_an_site_fullscreen_view'),
    (20, 'video_an_site_fullscreen_view_field__get_code'),
    (2, 'video_an_site_block_dsps_save'),
    (15, 'video_an_site_block_dsps_save'),
    (2, 'do_video_an_site_fullscreen_delete'),
    (2, 'do_video_an_site_fullscreen_edit'),
    (2, 'do_video_an_site_fullscreen_restore'),
    (2, 'do_video_an_site_fullscreen_start'),
    (2, 'do_video_an_site_fullscreen_stop'),
    (15, 'do_video_an_site_fullscreen_delete'),
    (15, 'do_video_an_site_fullscreen_edit'),
    (15, 'do_video_an_site_fullscreen_restore'),
    (15, 'do_video_an_site_fullscreen_start'),
    (15, 'do_video_an_site_fullscreen_stop'),
    (20, 'do_video_an_site_fullscreen_delete'),
    (20, 'do_video_an_site_fullscreen_edit'),
    (20, 'do_video_an_site_fullscreen_restore'),
    (20, 'do_video_an_site_fullscreen_start'),
    (20, 'do_video_an_site_fullscreen_stop'),
    (2, 'statistics_video_an_site_fullscreen_always_view'),
    (2, 'statistics_video_an_site_fullscreen_can_be_reloaded'),
    (2, 'statistics_video_an_site_fullscreen_view_dimension_field__currency_id'),
    (2, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_caption'),
    (2, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_id_name'),
    (2, 'statistics_video_an_site_fullscreen_view_entity_field__login'),
    (2, 'statistics_video_an_site_fullscreen_view_stat_field_all'),
    (2, 'statistics_video_an_site_inpage_always_view'),
    (2, 'statistics_video_an_site_inpage_can_be_reloaded'),
    (2, 'statistics_video_an_site_instream_always_view'),
    (2, 'statistics_video_an_site_instream_can_be_reloaded'),
    (15, 'statistics_video_an_site_fullscreen_always_view'),
    (15, 'statistics_video_an_site_fullscreen_can_be_reloaded'),
    (15, 'statistics_video_an_site_fullscreen_view_dimension_field__currency_id'),
    (15, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_caption'),
    (15, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_id_name'),
    (15, 'statistics_video_an_site_fullscreen_view_entity_field__login'),
    (15, 'statistics_video_an_site_fullscreen_view_stat_field_all'),
    (15, 'statistics_video_an_site_inpage_always_view'),
    (15, 'statistics_video_an_site_inpage_can_be_reloaded'),
    (15, 'statistics_video_an_site_instream_always_view'),
    (15, 'statistics_video_an_site_instream_can_be_reloaded'),
    (17, 'statistics_video_an_site_fullscreen_always_view'),
    (17, 'statistics_video_an_site_fullscreen_view_dimension_field__currency_id'),
    (17, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_caption'),
    (17, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_id_name'),
    (17, 'statistics_video_an_site_fullscreen_view_entity_field__login'),
    (17, 'statistics_video_an_site_fullscreen_view_stat_field_all'),
    (17, 'statistics_video_an_site_inpage_always_view'),
    (17, 'statistics_video_an_site_instream_always_view'),
    (20, 'statistics_video_an_site_fullscreen_view_dimension_field__currency_id'),
    (38, 'statistics_video_an_site_fullscreen_always_view'),
    (38, 'statistics_video_an_site_fullscreen_can_be_reloaded'),
    (38, 'statistics_video_an_site_fullscreen_view_dimension_field__currency_id'),
    (38, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_caption'),
    (38, 'statistics_video_an_site_fullscreen_view_dimension_field__dsp_id_name'),
    (38, 'statistics_video_an_site_fullscreen_view_entity_field__login'),
    (38, 'statistics_video_an_site_fullscreen_view_stat_field_all'),
    (38, 'statistics_video_an_site_inpage_always_view'),
    (38, 'statistics_video_an_site_inpage_can_be_reloaded'),
    (38, 'statistics_video_an_site_instream_always_view'),
    (38, 'statistics_video_an_site_instream_can_be_reloaded'),
    (39, 'statistics_video_an_site_fullscreen_view_entity_field__login');

REPLACE `partner`.`statistics_reports_level_order` (`level_id`, `order`) VALUES ('video_an_site_fullscreen', 147);

/*

DELETE FROM `role_rights` WHERE `right` = 'video_an_site_instream_edit_field__dsps' OR `right` = 'video_an_site_inpage_edit_field__dsps';

*/

/* Standart reports */

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report_by_login', 'advnet_on_site', 'Отчет по рекламе на сайтах для логина ${login} за 30 дней', 'Отчет по рекламе на сайтах для логина ${login} за 30 дней', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["an_campaign_caption","page_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах для логина ${login} за 30 дней',
    `caption_en`='Report on website advertisements for ${login} login for past 30 days',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["an_campaign_caption","page_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["login","MATCH",["user","MATCH",["login","IN",["${login}"]]]]]],"id":"advnet_on_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('advnet_report', 'advnet_on_site', 'Отчет по рекламе на сайтах за ${period||30days}', 'Отчет по рекламе на сайтах за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["page_id","an_campaign_caption"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах за ${period||30days}',
    `caption_en`='Report on website advertisements for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["page_id","an_campaign_caption"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","premium_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","partner_wo_nds","mcb_context_cpmh_mcb_context_partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('all_payments', 'payment', 'Доход по всем видам рекламы за ${period||90days}', 'Доход по всем видам рекламы за ${period||90days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","mobile_rtb_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Доход по всем видам рекламы за ${period||90days}',
    `caption_en`='Revenue from all types of advertisements for ${period||90days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","market_api_search_partner_wo_nds","mobile_rtb_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds","video_an_site_sum_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"payment","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report_by_block_id', 'advnet_context_on_site_adblock', 'Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_shows_own_adv","adblock_block_hits","adblock_block_hits_own_adv","adblock_block_hits_unsold","adblock_partner_wo_nds","adblock_block_winrate","adblock_block_visibility","adblock_block_all_hits","adblock_block_cover_ratio","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блоку Adblock ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Adblock block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_shows_own_adv","adblock_block_hits","adblock_block_hits_own_adv","adblock_block_hits_unsold","adblock_partner_wo_nds","adblock_block_winrate","adblock_block_visibility","adblock_block_all_hits","adblock_block_cover_ratio","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_detailed_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)', 'Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock за ${period||30days} (с детализацией по дням)',
    `caption_en`='Adblock blocks report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report_by_page_id', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adblock_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for Adblock blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adblock_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_visibility","adblock_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adblock"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adblock_report', 'advnet_context_on_site_adblock', 'Отчет по блокам Adblock за ${period||30days} (без детализации по дням)', 'Отчет по блокам Adblock за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adblock',
    `caption_ru`='Отчет по блокам Adblock за ${period||30days} (без детализации по дням)',
    `caption_en`='Adblock report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"adblock_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adblock_block_shows","adblock_block_hits","adblock_partner_wo_nds","adblock_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adblock_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adblock","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report_by_block_id', 'advnet_context_on_site_adfox', 'Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_shows_own_adv","adfox_block_hits","adfox_block_hits_own_adv","adfox_block_hits_unsold","adfox_partner_wo_nds","adfox_block_winrate","adfox_block_visibility","adfox_block_all_hits","adfox_block_cover_ratio","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по блоку ADFOX ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the ADFOX ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_shows_own_adv","adfox_block_hits","adfox_block_hits_own_adv","adfox_block_hits_unsold","adfox_partner_wo_nds","adfox_block_winrate","adfox_block_visibility","adfox_block_all_hits","adfox_block_cover_ratio","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_detailed_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (с детализацией по дням)', 'Отчет по ADFOX за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по ADFOX за ${period||30days} (с детализацией по дням)',
    `caption_en`='ADFOX report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report_by_page_id', 'advnet_context_on_site_adfox', 'Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по блокам ADFOX для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on ADFOX blocks for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_visibility","adfox_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_adfox"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_adfox_report', 'advnet_context_on_site_adfox', 'Отчет по ADFOX за ${period||30days} (без детализации по дням)', 'Отчет по ADFOX за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_adfox',
    `caption_ru`='Отчет по ADFOX за ${period||30days} (без детализации по дням)',
    `caption_en`='ADFOX report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["adfox_block_shows","adfox_block_hits","adfox_partner_wo_nds","adfox_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["adfox_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_adfox","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report_by_block_id', 'advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the Direct ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_detailed_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Direct report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_report', 'advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Отчет по Директу за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["direct_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report_by_page_id', 'advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}', 'Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа для площадки за ${page_id} «${name}» ${period||30days}',
    `caption_en`='Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_direct_tags_report', 'advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_income', 'advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Доход по рекламе на тематических площадках за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Доход по рекламе на тематических площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on theme-based ad platforms for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_detailed_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (с детализацией по дням)', 'Отчет по API Маркета за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета за ${period||30days} (с детализацией по дням)',
    `caption_en`='API Market report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report_by_page_id', 'advnet_context_on_site_market_api', 'Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_context_clicks","market_api_context_shows","market_api_context_ctr","market_api_context_partner_wo_nds","market_api_context_cpm_market_api_context_partner_wo_nds","market_api_context_cpc_market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on API Market for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_context_clicks","market_api_context_shows","market_api_context_ctr","market_api_context_partner_wo_nds","market_api_context_cpm_market_api_context_partner_wo_nds","market_api_context_cpc_market_api_context_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_context_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_market_api_report', 'advnet_context_on_site_market_api', 'Отчет по API Маркета за ${period||30days} (без детализации по дням)', 'Отчет по API Маркета за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"market_api_context_all_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["currency_id","context_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_market_api',
    `caption_ru`='Отчет по API Маркета за ${period||30days} (без детализации по дням)',
    `caption_en`='API Market report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"market_api_context_all_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds","market_api_context_clicks","market_api_context_cpc_market_api_context_all_wo_nds","market_api_context_cpm_market_api_context_all_wo_nds","market_api_context_ctr","market_api_context_shows"],"dimension_fields":["currency_id","context_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_context_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report_by_page_id', 'advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_context_partner_wo_nds","stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["adfox_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","partner_wo_nds","rtb_partner_wo_nds","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_context_partner_wo_nds","stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_report', 'advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Отчет по рекламе на тематических площадках за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site',
    `caption_ru`='Отчет по рекламе на тематических площадках за ${period||30days}',
    `caption_en`='Report on theme-based ad platform advertisement for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds","rtb_partner_wo_nds","direct_context_partner_wo_nds","market_api_context_partner_wo_nds","adfox_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report_by_block_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_partner_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_partner_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_detailed_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (с детализацией по дням)',
    `caption_en`='RTB report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_report', 'advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'Отчет по RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report_by_page_id', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}', 'Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB для площадки за ${page_id} «${name}» ${period||30days}',
    `caption_en`='RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_rtb_tags_report', 'advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_partner_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_partner_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report_by_block_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Stripe ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_detailed_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (с детализацией по дням)',
    `caption_en`='Stripe report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["date|day","context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report_by_page_id', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Stripes report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('context_stripe_report', 'advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (без детализации по дням)',
    `caption_en`='Stripe report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr","stripe_cpm_partner_wo_nds","stripe_cpc_partner_wo_nds"],"dimension_fields":["context_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["stripe_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_by_dsp_id', 'dsp', 'Отчет для DSP ID ${dsp_id} «${name}»', 'Отчет для DSP ID ${dsp_id} «${name}»', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет для DSP ID ${dsp_id} «${name}»',
    `caption_en`='Report for DSP ID ${dsp_id} "${name}"',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["id","IN",["${dsp_id}"]]]]}]}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report', 'dsp', 'Отчет по DSP за ${period||thismonth} (с детализацией по дням)', 'Отчет по DSP за ${period||thismonth} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP за ${period||thismonth} (с детализацией по дням)',
    `caption_en`='DSP report for ${period||thismonth} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||thismonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||thismonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_detailed_report_last_month', 'dsp', 'Отчет по DSP за ${period||lastmonth} (с детализацией по дням)', 'Отчет по DSP за ${period||lastmonth} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||lastmonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||lastmonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP за ${period||lastmonth} (с детализацией по дням)',
    `caption_en`='DSP report for ${period||lastmonth} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||lastmonth}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||lastmonth}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report_by_caption', 'dsp', 'Отчет по DSP ${caption} за ${period||30days}', 'Отчет по DSP ${caption} за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["dsp_bids","dsp_shows","dsp_charging_w_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["short_caption","LIKE","${caption}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Отчет по DSP ${caption} за ${period||30days}',
    `caption_en`='DSP ${caption} report for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["dsp_bids","dsp_shows","dsp_charging_w_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":["AND",[["short_caption","LIKE","${caption}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('dsp_report', 'dsp', 'Начислено DSP за ${period||90days} (без детализации по дням)', 'Начислено DSP за ${period||90days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='dsp',
    `caption_ru`='Начислено DSP за ${period||90days} (без детализации по дням)',
    `caption_en`='DSP charged for ${period||90days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||90days}","fields":["dsp_bids","dsp_shows","all_hits","dsp_charging_wo_nds","dsp_cpm_charging_wo_nds","average_rate_all_real_price_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["id","short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"chartLevel":[{"period":"${period||90days}","fields":["dsp_charging_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["short_caption"],"total":0,"vat":-1,"levels":[{"id":"dsp","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report_by_domain', 'internal_advnet_on_site', 'Отчет по домену ${domain} за ${period||30days}', 'Отчет по домену ${domain} за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_w_nds","rtb_all_w_nds","premium_all_w_nds","direct_context_all_w_nds","direct_search_all_w_nds","all_w_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":["AND",[["domain","LIKE","${domain}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_on_site',
    `caption_ru`='Отчет по домену ${domain} за ${period||30days}',
    `caption_en`='${domain} domain report for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_w_nds","rtb_all_w_nds","premium_all_w_nds","direct_context_all_w_nds","direct_search_all_w_nds","all_w_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":["AND",[["domain","LIKE","${domain}"]]]}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_advnet_report', 'internal_advnet_on_site', 'Отчет по рекламе на сайтах', 'Отчет по рекламе на сайтах', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day","page_id"],"dimension_filter":null,"entity_fields":["domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_on_site',
    `caption_ru`='Отчет по рекламе на сайтах',
    `caption_en`='Report on website advertisements',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","premium_all_wo_nds","direct_context_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day","page_id"],"dimension_filter":null,"entity_fields":["domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report_by_block_id', 'internal_advnet_context_on_site_direct', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', 'Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по блоку Директа ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Report on the Direct ${block_id} "${name}" block for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_detailed_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', 'Отчет по Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","public_id"],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по блокам Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","public_id"],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_report', 'internal_advnet_context_on_site_direct', 'Отчет по Директу за ${period||30days} (без детализации по дням)', 'Отчет по Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["direct_context_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_direct","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report_by_page_id', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_direct_tags_report', 'internal_advnet_context_on_site_direct', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам Директа за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_direct',
    `caption_ru`='Отчет по срезам Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"direct_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","tag_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_context_shows","direct_context_clicks","direct_context_all_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_all_wo_nds","direct_context_cpc_direct_context_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_income', 'internal_advnet_context_on_site', 'Доход по рекламе на тематических площадках за ${period||10days}', 'Доход по рекламе на тематических площадках за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Доход по рекламе на тематических площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on theme-based ad platforms for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report_by_page_id', 'internal_advnet_context_on_site', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Отчет по тематической площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" theme-based ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_report', 'internal_advnet_context_on_site', 'Отчет по рекламе на тематических площадках за ${period||30days}', 'Отчет по рекламе на тематических площадках за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site',
    `caption_ru`='Отчет по рекламе на тематических площадках за ${period||30days}',
    `caption_en`='Report on theme-based ad platform advertisement for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds","rtb_all_wo_nds","direct_context_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report_by_block_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_all_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_shows_own_adv","rtb_block_hits","rtb_block_hits_own_adv","rtb_block_hits_unsold","rtb_all_wo_nds","rtb_block_winrate","rtb_block_visibility","rtb_block_all_hits","rtb_block_cover_ratio"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_detailed_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', 'Отчет по RTB за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (с детализацией по дням)',
    `caption_en`='RTB report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB-блокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report for RTB blocks at ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_visibility","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_report', 'internal_advnet_context_on_site_rtb', 'Отчет по RTB за ${period||30days} (без детализации по дням)', 'Отчет по RTB за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["rtb_block_shows","rtb_block_hits","rtb_all_wo_nds","rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report_by_page_id', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}', '{"tableViewModelData":{"sortBy":"rtb_search_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='RTB cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"rtb_search_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_rtb_tags_report', 'internal_advnet_context_on_site_rtb', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', 'Отчет по срезам RTB за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"rtb_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_rtb',
    `caption_ru`='Отчет по срезам RTB за ${period||30days} (без детализации по дням)',
    `caption_en`='RTB cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"rtb_context_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"order_by":[{"dir":"asc","field":"rtb_all_wo_nds"}],"period":"${period||30days}","top_keys":15,"total":0,"vat":-1}],"events":{"use_upper_levels":0},"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["rtb_block_hits","rtb_block_shows","rtb_block_direct_shows","rtb_block_direct_clicks","rtb_all_wo_nds","rtb_block_direct_ctr","rtb_block_cpm_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_context_on_site_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report_by_block_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Stripe ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_detailed_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', 'Отчет по Промоблоку за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (с детализацией по дням)',
    `caption_en`='Stripe report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report_by_page_id', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблокам для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Stripes report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["stripe_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","title"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_context_on_site_stripe"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_context_stripe_report', 'internal_advnet_context_on_site_stripe', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', 'Отчет по Промоблоку за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_context_on_site_stripe',
    `caption_ru`='Отчет по Промоблоку за ${period||30days} (без детализации по дням)',
    `caption_en`='Stripe report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["stripe_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_all_wo_nds","stripe_ctr","stripe_cpm_all_wo_nds","stripe_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_context_on_site_stripe","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_income', 'internal_mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Доход по рекламе в мобильных приложениях за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Доход по рекламе в мобильных приложениях за ${period||10days}',
    `caption_en`='Revenue from mobile application advertisements for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report_by_page_id', 'internal_mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='${page_id} "${name}" mobile application report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_report', 'internal_mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","caption"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","caption"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report_by_block_id', 'internal_mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_all_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Mobile RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_all_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_detailed_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report_by_page_id', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}', 'Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","=",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","IN",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам на площадке ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","=",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_all_wo_nds"],"levels":[{"filter":["AND",[["application_id","IN",["${page_id}"]]]],"id":"internal_mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_mobile_rtb_report', 'internal_mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_all_wo_nds"],"dimension_fields":["date|day","internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_all_wo_nds","mobile_rtb_block_cpm_all_wo_nds"],"dimension_fields":["internal_mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["application_id"],"total":0,"vat":-1,"levels":[{"id":"internal_mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_detailed_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_all_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_all_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_report', 'internal_advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report_by_page_id', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_direct_tags_report', 'internal_advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_shows","direct_search_clicks","direct_search_all_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_all_wo_nds","direct_search_cpc_direct_search_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_income', 'internal_advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Доход по рекламе на поисковых площадках за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Доход по рекламе на поисковых площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on search ad platform for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report_by_block_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["id","${block_id}","="]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_detailed_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению ${period||30days} (с детализацией по дням)', 'Отчет по Спецразмещению ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${period||30days} (с детализацией по дням)',
    `caption_en`='Premium placement report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_report', 'internal_advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report_by_page_id', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_premium_tags_report', 'internal_advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","currency_id"],"dimension_filter":null,"entity_fields":["domain","campaign_id"],"fields":["premium_shows","premium_clicks","premium_all_wo_nds","premium_ctr","premium_cpm_all_wo_nds","premium_cpc_all_wo_nds"],"levels":[{"filter":null,"id":"internal_advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report_by_page_id', 'internal_advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"internal_advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('internal_search_report', 'internal_advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Отчет по рекламе на поисковых площадках за ${period||30days}', '{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='internal_advnet_search_on_site',
    `caption_ru`='Отчет по рекламе на поисковых площадках за ${period||30days}',
    `caption_en`='Report on search ad platform advertisements for ${period||30days}',
    `query`='{"chartLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"tableLevel":[{"period":"${period||30days}","fields":["premium_all_wo_nds","direct_search_all_wo_nds","all_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","domain"],"total":0,"vat":-1,"levels":[{"id":"internal_advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_income', 'mobile_app', 'Доход по рекламе в мобильных приложениях за ${period||10days}', 'Доход по рекламе в мобильных приложениях за ${period||10days}', '{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Доход по рекламе в мобильных приложениях за ${period||10days}',
    `caption_en`='Revenue from mobile application advertisements for ${period||10days}',
    `query`='{"chartLevel":[{"period":"${period||10days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_login', 'mobile_app', 'Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","context_page_id"],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях для логина ${login} за 30 дней (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${login} login for past 30 days (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","context_page_id"],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"mobile_app"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report_by_page_id', 'mobile_app', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по мобильному приложению ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='${page_id} "${name}" mobile application report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_report', 'mobile_app', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', 'Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app',
    `caption_ru`='Отчет по рекламе в мобильных приложениях за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile application advertisements for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["context_page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report_by_block_id', 'mobile_app_rtb', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', 'Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_partner_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильному RTB-блоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Mobile RTB block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_shows_own_adv","mobile_rtb_block_hits","mobile_rtb_block_hits_own_adv","mobile_rtb_block_hits_unsold","mobile_rtb_partner_wo_nds","mobile_rtb_block_winrate","mobile_rtb_block_visibility","mobile_rtb_block_all_hits","mobile_rtb_block_cover_ratio","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_detailed_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report_by_page_id', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}', 'Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам для приложения ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on mobile RTB blocks for ${page_id} "${name}" application for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["mobile_rtb_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["context_page_id","IN",["${page_id}"]]]],"id":"mobile_app_rtb"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('mobile_rtb_report', 'mobile_app_rtb', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', 'Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='mobile_app_rtb',
    `caption_ru`='Отчет по мобильным RTB-блокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on mobile RTB blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"mobile_rtb_partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["mobile_rtb_block_shows","mobile_rtb_block_hits","mobile_rtb_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"dimension_fields":["mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":["context_page_id"],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["mobile_rtb_partner_wo_nds"],"dimension_fields":["date|day","mobile_caption","currency_id"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"mobile_app_rtb","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_all_payments', 'payment', 'Доход по всем видам рекламы за период ${period_current} со сравнением', 'Доход по всем видам рекламы за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Доход по всем видам рекламы за период ${period_current} со сравнением',
    `caption_en`='Revenue from all types of advertisements for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","rtb_partner_wo_nds","mobile_rtb_partner_wo_nds","adfox_partner_wo_nds","adblock_partner_wo_nds","premium_partner_wo_nds","direct_context_partner_wo_nds","direct_search_partner_wo_nds","stripe_partner_wo_nds","partner_wo_nds"],"levels":[{"filter":null,"id":"payment"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_adfox', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'Отчет по ADFOX за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по ADFOX за период ${period_current} со сравнением',
    `caption_en`='ADFOX report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["adfox_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_adfox"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_direct', 'payment', 'Отчет по Директу за период ${period_current} со сравнением', 'Отчет по Директу за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Директу за период ${period_current} со сравнением',
    `caption_en`='Direct report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_context_shows","direct_context_clicks","direct_context_partner_wo_nds","direct_context_ctr","direct_context_cpm_direct_context_partner_wo_nds","direct_context_cpc_direct_context_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_rtb', 'payment', 'Отчет по RTB за период ${period_current} со сравнением', 'Отчет по RTB за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по RTB за период ${period_current} со сравнением',
    `caption_en`='RTB report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["rtb_block_hits","rtb_block_shows","rtb_partner_wo_nds","rtb_block_visibility","rtb_block_cpmh_partner_wo_nds","rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_context_on_site_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_context_stripe', 'payment', 'Отчет по ADFOX за период ${period_current} со сравнением', 'Отчет по ADFOX за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по ADFOX за период ${period_current} со сравнением',
    `caption_en`='ADFOX report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["stripe_hits","stripe_shows","stripe_clicks","stripe_partner_wo_nds","stripe_ctr"],"levels":[{"filter":null,"id":"advnet_context_on_site_stripe"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_mobile_rtb', 'payment', 'Отчет по мобильным RTB-блокам за период ${period_current} со сравнением', 'Отчет по мобильным RTB-блокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по мобильным RTB-блокам за период ${period_current} со сравнением',
    `caption_en`='Report on mobile RTB blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["mobile_rtb_block_hits","mobile_rtb_block_shows","mobile_rtb_partner_wo_nds","mobile_rtb_block_visibility","mobile_rtb_block_cpmh_partner_wo_nds","mobile_rtb_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"mobile_app_rtb"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_direct', 'payment', 'Отчет по поисковому Директу за период ${period_current} со сравнением', 'Отчет по поисковому Директу за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по поисковому Директу за период ${period_current} со сравнением',
    `caption_en`='Search Direct report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_search_premium', 'payment', 'Отчет по Спецразмещению за период ${period_current} со сравнением', 'Отчет по Спецразмещению за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Спецразмещению за период ${period_current} со сравнением',
    `caption_en`='Premium placement report for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_fullscreen_block', 'payment', 'Отчет по Fullscreen видеоблокам за период ${period_current} со сравнением', 'Отчет по Fullscreen видеоблокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Fullscreen видеоблокам за период ${period_current} со сравнением',
    `caption_en`='Report on Fullscreen video blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_inpage_block', 'payment', 'Отчет по InPage видеоблокам за период ${period_current} со сравнением', 'Отчет по InPage видеоблокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по InPage видеоблокам за период ${period_current} со сравнением',
    `caption_en`='Report on InPage video blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('monitorings_video_instream_block', 'payment', 'Отчет по Instream видеоблокам за период ${period_current} со сравнением', 'Отчет по Instream видеоблокам за период ${period_current} со сравнением', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='payment',
    `caption_ru`='Отчет по Instream видеоблокам за период ${period_current} со сравнением',
    `caption_en`='Report on Instream video blocks for period ${period_current} with comparison',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_current}","${period_current}"],"total":0,"vat":-1},{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":["${period_cmp}","${period_cmp}"],"total":0,"vat":-1}],"tableLevel":null,"isLevelsDifferent":false}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report_by_block_id', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу ${block_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct ${block_id} "${name}" report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_detailed_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search Direct report for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по Директу для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Direct for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_report', 'advnet_search_on_site_direct', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', 'Отчет по поисковому Директу за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по поисковому Директу за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report_by_page_id', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Search Direct cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"direct_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_direct_tags_report', 'advnet_search_on_site_direct', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', 'Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)', '{"chartLevel":[{"dimension_fields":["date|day","currency_id","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","tag_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_direct',
    `caption_ru`='Отчет по срезам поискового Директа за ${period||30days} (без детализации по дням)',
    `caption_en`='Search Direct cross-section report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id","tag_id"],"dimension_filter":null,"entity_fields":[],"fields":["direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id","tag_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["direct_search_shows","direct_search_clicks","direct_search_partner_wo_nds","direct_search_ctr","direct_search_cpm_direct_search_partner_wo_nds","direct_search_cpc_direct_search_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_direct"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_income', 'advnet_search_on_site', 'Доход по рекламе на поисковых площадках за ${period||10days}', 'Доход по рекламе на поисковых площадках за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Доход по рекламе на поисковых площадках за ${period||10days}',
    `caption_en`='Revenue from advertisement on search ad platforms for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_detailed_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)', 'Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API Маркета за ${period||30days} (с детализацией по дням)',
    `caption_en`='Search API Market report for ${period||30days} (with daily details)',
    `query`='{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id","date|day"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report_by_page_id', 'advnet_search_on_site_market_api', 'Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_search_clicks","market_api_search_shows","market_api_search_ctr","market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_cpc_market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API маркета для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on search API Market for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["market_api_search_clicks","market_api_search_shows","market_api_search_ctr","market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_cpc_market_api_search_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_market_api"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"market_api_search_partner_wo_nds","sortOrder":"desc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_market_api_report', 'advnet_search_on_site_market_api', 'Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)', 'Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)', '{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_all_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_market_api',
    `caption_ru`='Отчет по поисковому API Маркета за ${period||30days} (без детализации по дням)',
    `caption_en`='Search API Market report for ${period||30days} (without daily details)',
    `query`='{"tableLevel":[{"period":"${period||30days}","fields":["market_api_search_partner_wo_nds","market_api_search_clicks","market_api_search_cpc_market_api_search_partner_wo_nds","market_api_search_cpm_market_api_search_partner_wo_nds","market_api_search_ctr","market_api_search_shows"],"dimension_fields":["currency_id","search_campaign_caption"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["market_api_search_all_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_market_api","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report_by_block_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_detailed_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)', 'Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (с детализацией по дням)',
    `caption_en`='Premium placement report for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["date|day","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Premium placement for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_report', 'advnet_search_on_site_premium', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', 'Отчет по Спецразмещению за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по Спецразмещению за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"dimension_fields":["search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds"],"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site_premium","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report_by_page_id', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', 'Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения для площадки ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Premium placement cross-section report for ${page_id} "${name}" ad platform for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":["AND",[["campaign_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_premium_tags_report', 'advnet_search_on_site_premium', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', 'Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site_premium',
    `caption_ru`='Отчет по срезам Спецразмещения за ${period||30days} (без детализации по дням)',
    `caption_en`='Premium placement cross-section report for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","tag_id","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["premium_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["tag_id","search_campaign_caption","currency_id"],"dimension_filter":null,"entity_fields":["campaign_id"],"fields":["premium_shows","premium_clicks","premium_partner_wo_nds","premium_ctr","premium_cpm_partner_wo_nds","premium_cpc_partner_wo_nds"],"levels":[{"filter":null,"id":"advnet_search_on_site_premium"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report_by_page_id', 'advnet_search_on_site', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["direct_search_partner_wo_nds","market_api_search_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_search_partner_wo_nds","premium_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Отчет по поисковой площадке ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" search ad platform for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["direct_search_partner_wo_nds","market_api_search_partner_wo_nds","partner_wo_nds","premium_partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["market_api_search_partner_wo_nds","premium_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","market_search_shows","market_search_clicks","market_search_cpmh_market_search_partner_wo_nds","mcb_search_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"advnet_search_on_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('search_report', 'advnet_search_on_site', 'Отчет по рекламе на поисковых площадках за ${period||30days}', 'Отчет по рекламе на поисковых площадках за ${period||30days}', '{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='advnet_search_on_site',
    `caption_ru`='Отчет по рекламе на поисковых площадках за ${period||30days}',
    `caption_en`='Report on search ad platforms advertisements for ${period||30days}',
    `query`='{"tableViewModelData":{"sortBy":"partner_wo_nds","sortOrder":"desc"},"tableLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":[],"dimension_filter":null,"entity_fields":["page_id","caption"],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"chartLevel":[{"period":"${period||30days}","fields":["premium_partner_wo_nds","market_api_search_partner_wo_nds","direct_search_partner_wo_nds","partner_wo_nds","mcb_search_cpmh_mcb_search_partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"advnet_search_on_site","filter":null}]}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('ssp_report', 'ssp', 'Отчет по SSP за ${period||30days} (без детализации по дням)', 'Отчет по SSP за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"all_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","name"],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='ssp',
    `caption_ru`='Отчет по SSP за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on SSP for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"all_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["id","name"],"fields":["ssp_mobile_rtb_partner_wo_nds","partner_wo_nds","ssp_mobile_rtb_all_wo_nds","all_wo_nds"],"levels":[{"filter":null,"id":"ssp"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_detailed_report_by_block_id', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Fullscreen видеоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_block_hits_own_adv","fullscreen_block_shows_own_adv","fullscreen_block_hits_unsold","fullscreen_block_all_hits","fullscreen_partner_wo_nds","fullscreen_block_winrate","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_fullscreen',
    `caption_ru`='Отчет по Fullscreen видеоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Fullscreen video block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_block_hits_own_adv","fullscreen_block_shows_own_adv","fullscreen_block_hits_unsold","fullscreen_block_all_hits","fullscreen_partner_wo_nds","fullscreen_block_winrate","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_detailed_report', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам за ${period||30days} (с детализацией по дням)', 'Отчет по Fullscreen видеоблокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_fullscreen',
    `caption_ru`='Отчет по Fullscreen видеоблокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on Fullscreen video blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_report_by_page_id', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Отчет по Fullscreen видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_fullscreen',
    `caption_ru`='Отчет по Fullscreen видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Fullscreen video blocks for ${page_id} "${name}" resource for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_visibility","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_fullscreen_block_report', 'video_an_site_fullscreen', 'Отчет по Fullscreen видеоблокам за ${period||30days} (без детализации по дням)', 'Отчет по Fullscreen видеоблокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"fullscreen_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_fullscreen',
    `caption_ru`='Отчет по Fullscreen видеоблокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on Fullscreen video blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"fullscreen_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["fullscreen_block_hits","fullscreen_block_shows","fullscreen_partner_wo_nds","fullscreen_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_fullscreen"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_income', 'video_an_site', 'Доход по видеорекламе за ${period||10days}', 'Доход по видеорекламе за ${period||10days}', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"video_an_site","filter":null}]}],"isLevelsDifferent":false}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Доход по видеорекламе за ${period||10days}',
    `caption_en`='Revenue from video advertisement for ${period||10days}',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"tableLevel":null,"chartLevel":[{"period":"${period||10days}","fields":["fullscreen_partner_wo_nds","instream_partner_wo_nds","inpage_partner_wo_nds","partner_wo_nds"],"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"total":0,"vat":-1,"levels":[{"id":"video_an_site","filter":null}]}],"isLevelsDifferent":false}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report_by_block_id', 'video_an_site_inpage', 'Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_block_hits_own_adv","inpage_block_shows_own_adv","inpage_block_hits_unsold","inpage_block_all_hits","inpage_partner_wo_nds","inpage_block_winrate","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='InPage video block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_block_hits_own_adv","inpage_block_shows_own_adv","inpage_block_hits_unsold","inpage_block_all_hits","inpage_partner_wo_nds","inpage_block_winrate","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_detailed_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)', 'Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on InPage video blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report_by_page_id', 'video_an_site_inpage', 'Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on InPage video blocks for ${page_id} "${name}" resource for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_visibility","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_inpage_block_report', 'video_an_site_inpage', 'Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)', 'Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"inpage_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_inpage',
    `caption_ru`='Отчет по InPage видеоблокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on InPage video blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"inpage_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["inpage_block_hits","inpage_block_shows","inpage_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_inpage"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report_by_block_id', 'video_an_site_instream', 'Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}', 'Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_block_hits_own_adv","instream_block_shows_own_adv","instream_block_hits_unsold","instream_block_all_hits","instream_partner_wo_nds","instream_block_winrate","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблоку ${block_id} «${name}» за ${period||30days}',
    `caption_en`='Instream video block ${block_id} "${name}" report for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":[],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_block_hits_own_adv","instream_block_shows_own_adv","instream_block_hits_unsold","instream_block_all_hits","instream_partner_wo_nds","instream_block_winrate","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["id","=","${block_id}"]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_detailed_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)', 'Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)', '{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on Instream video blocks for ${period||30days} (with daily details)',
    `query`='{"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day","video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report_by_page_id', 'video_an_site_instream', 'Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', 'Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}', '{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам для ресурса ${page_id} «${name}» за ${period||30days}',
    `caption_en`='Report on Instream video blocks for ${page_id} "${name}" resource for ${period||30days}',
    `query`='{"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["public_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["currency_id"],"dimension_filter":null,"entity_fields":["public_id","caption"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_visibility","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["page_id","IN",["${page_id}"]]]],"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_instream_block_report', 'video_an_site_instream', 'Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)', 'Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)', '{"tableViewModelData":{"sortBy":"instream_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site_instream',
    `caption_ru`='Отчет по Instream видеоблокам за ${period||30days} (без детализации по дням)',
    `caption_en`='Report on Instream video blocks for ${period||30days} (without daily details)',
    `query`='{"tableViewModelData":{"sortBy":"instream_partner_wo_nds","sortOrder":"desc"},"chartLevel":[{"dimension_fields":["date|day","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["video_caption","currency_id"],"dimension_filter":null,"entity_fields":["page_id"],"fields":["instream_block_hits","instream_block_shows","instream_partner_wo_nds","instream_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site_instream"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_report_by_page_id', 'video_an_site', 'Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', 'Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеоресурсу ${page_id} «${name}» за ${period||30days} (с детализацией по дням)',
    `caption_en`='Report on ${page_id} "${name}" video resource for ${period||30days} (with daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_partner_wo_nds","inpage_partner_wo_nds","instream_partner_wo_nds","video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["id","IN",["${page_id}"]]]],"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableViewModelData":{"sortBy":"date","sortOrder":"asc"},"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report_by_login', 'video_an_site', 'Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)', 'Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 1)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеорекламе для логина ${login} за 30 дней (без детализациии по дням)',
    `caption_en`='Video advertisement report for ${login} login for past 30 days (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":["AND",[["owner","MATCH",["login","IN",["${login}"]]]]],"id":"video_an_site"}],"period":"30days","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=1;

INSERT INTO statistics_reports
    (`id`, `level`, `caption_ru`, `caption_en`, `query`, `multistate`, `not_show`)
VALUES
    ('video_site_report', 'video_an_site', 'Отчет по видеорекламе за ${period||30days} (без детализациии по дням)', 'Отчет по видеорекламе за ${period||30days} (без детализациии по дням)', '{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}', 1, 0)
ON DUPLICATE KEY UPDATE
    `level`='video_an_site',
    `caption_ru`='Отчет по видеорекламе за ${period||30days} (без детализациии по дням)',
    `caption_en`='Video advertisement report for ${period||30days} (without daily details)',
    `query`='{"chartLevel":[{"dimension_fields":["date|day"],"dimension_filter":null,"entity_fields":[],"fields":["video_an_site_sum_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"tableLevel":[{"dimension_fields":[],"dimension_filter":null,"entity_fields":["caption","id"],"fields":["fullscreen_block_hits","instream_block_hits","inpage_block_hits","fullscreen_block_shows","instream_block_shows","inpage_block_shows","video_an_site_sum_partner_wo_nds","fullscreen_block_visibility","instream_block_visibility","inpage_block_visibility","fullscreen_block_cpm_partner_wo_nds","instream_block_cpm_partner_wo_nds","inpage_block_cpm_partner_wo_nds"],"levels":[{"filter":null,"id":"video_an_site"}],"period":"${period||30days}","total":0,"vat":-1}],"isLevelsDifferent":true}',
    `not_show`=0;


/* PI-8873 end */
/* PI-8591 block start */

REPLACE `partner`.`role_rights` VALUES
    (2, 'do_site_block'),
    (16, 'do_site_block');

/* PI-8591 block end */
/* PI-9023 start */

REPLACE INTO `role_rights` (`role_id`, `right`) VALUES
(38, 'statistics_video_an_site_inpage_view_entity_field__login');

REPLACE INTO `role_rights` (`role_id`, `right`) VALUES
( 2, 'statistics_video_an_site_instream_view_entity_field__login'),
(15, 'statistics_video_an_site_instream_view_entity_field__login'),
(17, 'statistics_video_an_site_instream_view_entity_field__login'),
(38, 'statistics_video_an_site_instream_view_entity_field__login'),
(39, 'statistics_video_an_site_instream_view_entity_field__login');

/* PI-9023 end */
