LOCK TABLES pages WRITE;
LOCK TABLES context_on_site_campaign WRITE;
LOCK TABLES internal_context_on_site_campaign WRITE;
LOCK TABLES mobile_app_settings WRITE;
LOCK TABLES internal_mobile_app WRITE;

DROP TRIGGER IF EXISTS `internal_campaign_insert`;
DELIMITER $$
CREATE TRIGGER internal_campaign_insert
    BEFORE INSERT
    ON internal_context_on_site_campaign
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (allowed_turbo,
                           blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.allowed_turbo,
                NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.site_id,
                1,
                NEW.id,
                'internal_context_on_site_campaign',
                NEW.multistate,
                NEW.opts,
                NEW.id, -- is page_id for internal
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `mobile_app_settings_insert`;
DELIMITER $$
CREATE TRIGGER mobile_app_settings_insert
    BEFORE INSERT
    ON mobile_app_settings
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           owner_id,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.application_id,
                1,
                NEW.id,
                'mobile_app_settings',
                NEW.multistate,
                NEW.opts,
                NEW.owner_id,
                NEW.context_page_id,
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

DROP TRIGGER IF EXISTS `internal_mobile_app_insert`;
DELIMITER $$
CREATE TRIGGER internal_mobile_app_insert
    BEFORE INSERT
    ON internal_mobile_app
    FOR EACH ROW
BEGIN
    IF (NEW.from_trigger = 0)
    THEN
        INSERT INTO pages (blocks_count,
                           blocks_limit,
                           caption,
                           create_date,
                           domain_id,
                           from_trigger,
                           id,
                           model,
                           multistate,
                           opts,
                           page_id,
                           unmoderated_rtb_auction,
                           update_time,
                           creator_id)
        VALUES (NEW.blocks_count,
                NEW.blocks_limit,
                NEW.caption,
                NEW.create_date,
                NEW.id, -- internal_mobile_app is a domain for itself
                1,
                NEW.id,
                'internal_mobile_app',
                NEW.multistate,
                NEW.opts,
                NEW.id, -- is page_id for internal
                NEW.unmoderated_rtb_auction,
                coalesce(NEW.update_time, '1970-01-01 03:00:00'),
                NEW.creator_id);
    ELSE
        SET NEW.from_trigger = 0;
END IF;
END;
$$
DELIMITER ;

UNLOCK TABLES;

INSERT INTO pages (id,
                   creator_id)
    (SELECT c.id,
            c.creator_id
    FROM context_on_site_campaign c, pages p where c.id = p.id and c.creator_id <> p.creator_id)
    ON DUPLICATE KEY UPDATE
                         creator_id = VALUES(creator_id),
                         from_trigger = 1;

INSERT INTO pages (id,
                   creator_id)
    (SELECT c.id, c.creator_id
    FROM internal_context_on_site_campaign c, pages p where c.id = p.id and c.creator_id <> p.creator_id)
    ON DUPLICATE KEY UPDATE
                         creator_id = VALUES(creator_id),
                         from_trigger = 1;

INSERT INTO pages (id,
                   creator_id)
    (SELECT c.id,
            c.creator_id
    FROM mobile_app_settings c, pages p where c.id = p.id and c.creator_id <> p.creator_id)
    ON DUPLICATE KEY UPDATE
                         creator_id = VALUES(creator_id),
                         from_trigger = 1;

INSERT INTO pages (id,
                   creator_id)
    (SELECT c.id,
            c.creator_id
    FROM internal_mobile_app c, pages p where c.id = p.id and c.creator_id <> p.creator_id)
    ON DUPLICATE KEY UPDATE
                         creator_id = VALUES(creator_id),
                         from_trigger = 1;
