require('./style.scss')
import * as React from 'react'
import * as ReactDOM from 'react-dom'

import ReactDiff from 'react-diff-viewer'

interface IEnableFields {
  [field: string]: boolean;
}

interface IMySqlDiffState {
  splitView?: boolean;
  highlightLine?: string[];
  table: string;
  fields: string[],
  primary_key: string[],
  enableSyntaxHighlighting?: boolean;
  enableFields: any;
}

interface ITable {
  name: string;
  fields: string[];
  primary_key: string[];
}

const tables = require('./json/tables.json')

const hashTables: {[table: string]: ITable} = {};

let data: any = {};

tables.map((t: ITable) => {
  hashTables[t.name] = t;
  data[t.name] = require('./json/' + t.name + '.json');
  data['dump__' + t.name] = require('./json/dump__' + t.name + '.json');
});

const P = (window as any).Prism

class MySqlDiff extends React.Component<{}, IMySqlDiffState> {

  constructor(props: any) {
    super(props)

    let enableFields: IEnableFields = {};

    tables[0].fields.map((f: string) => {enableFields[f] = true});

    this.state = {
      splitView: true,
      highlightLine: [],
      table: tables[0].name,
      fields: tables[0].fields,
      primary_key: tables[0].primary_key,
      enableSyntaxHighlighting: true,
      enableFields: enableFields,
    }
  }

  toggleSyntaxHighlighting = () => this.setState({
    enableSyntaxHighlighting: !this.state.enableSyntaxHighlighting,
  })

  onChange = () => this.setState({ splitView: !this.state.splitView })

  onTableChange = (e: any) => {
    let enableFields: IEnableFields = {};

    let table: string = e.target.value;

    let fields: string[] = hashTables[table].fields;

    fields.map((f: string) => enableFields[f] = true);

    this.setState({
      table: table,
      fields: fields,
      enableFields: enableFields,
      primary_key: hashTables[table].primary_key,
      highlightLine: []
    });
  }

  onLineNumberClick = (id: string, e: React.MouseEvent<HTMLTableCellElement>) => {
    let highlightLine = [id]
    if (e.shiftKey && this.state.highlightLine.length === 1) {
      const [dir, oldId] = this.state.highlightLine[0].split('-')
      const [newDir, newId] = id.split('-')
      if (dir === newDir) {
        highlightLine = []
        const lowEnd = Math.min(Number(oldId), Number(newId))
        const highEnd = Math.max(Number(oldId), Number(newId))
        for (var i = lowEnd; i <= highEnd; i++) {
          highlightLine.push(`${dir}-${i}`)
        }
      }
    }
    this.setState({
      highlightLine,
    })
  }

  toggleFields = (e: any) => {
    let field: string = e.target.id;

    let oldEnableFields: IEnableFields = this.state.enableFields;
    oldEnableFields[field] = !oldEnableFields[field];

    const enableFields: IEnableFields = oldEnableFields;

    this.setState({ enableFields: enableFields });
  }

  resetAllFields = () => {
    let oldEnableFields: IEnableFields = this.state.enableFields;
    Object.keys(oldEnableFields).map((f: string) => oldEnableFields[f] = false);

    this.state.primary_key.map((f: string) => oldEnableFields[f] = true);

    const enableFields: IEnableFields = oldEnableFields;

    this.setState({ enableFields: enableFields });
  }

  checkAllFields = () => {
    let oldEnableFields: IEnableFields = this.state.enableFields;
    Object.keys(oldEnableFields).map((f: string) => oldEnableFields[f] = true);

    const enableFields: IEnableFields = oldEnableFields;

    this.setState({ enableFields: enableFields });
  }

  syntaxHighlight = (str: string) => {
    let language = P.highlight(str, P.languages.json)

    return <pre
      style={{ display: 'inline' }}
      dangerouslySetInnerHTML={{ __html: language }}
    />
  }

  render() {

    let oldValue = data['dump__' + this.state.table];
    let newValue = data[this.state.table];

    const enableFields: IEnableFields = this.state.enableFields;
    const pk: string[] = this.state.primary_key;

    let enableFieldsWithPk: IEnableFields = enableFields;

    pk.map((f: string) => enableFieldsWithPk[f] = true);

    console.log(enableFieldsWithPk);

    var dataMap = (d: any) => {
      var res: {[key: string]: any} = {};

      Object.keys(enableFieldsWithPk).map((f: string) => {
        if (enableFieldsWithPk[f]) {
          res[f] = d[f];
        }
      });

      return res;
    };

    let oldValueJson = JSON.stringify(oldValue.map(dataMap), null, 4)
    let newValueJson = JSON.stringify(newValue.map(dataMap), null, 4)

    let table: string = this.state.table;

    return (
      <div className="react-diff-viewer">
        <div className="controls" key={'controls_' + table}>
          <select
            name="table"
            id="table"
            onChange={this.onTableChange}
            value={table}
          >
            {tables.map((t: ITable, i: string) => {return (<option key={t.name + '_' + i} value={t.name}>{t.name}</option>)})}
          </select>
          <span>
            <label>
              <input
                type="checkbox"
                name="toggle-2"
                id="toggle-2"
                onChange={this.toggleSyntaxHighlighting}
                checked={this.state.enableSyntaxHighlighting} /> Syntax Highlighting
            </label>
            <label>
              <input
                type="checkbox"
                name="toggle-1"
                id="toggle-1"
                onChange={this.onChange}
                checked={this.state.splitView} /> Split View
            </label>
          </span>
        </div>
        <div className="fields" key={'fields_' + table}>
          <h1>Fields:</h1>
          {this.state.fields.map((f: string) => {return (<span key={table + '_span_' + f}>
            <label key={table + '_label_' + f}>
              <input
                  key={table + f}
                  type="checkbox"
                  name={f}
                  id={f}
                  onChange={this.toggleFields}
                  checked={this.state.enableFields[f]} /> {f}
            </label>
          </span>);})}
        </div>
        <div className="buttons">
          <button className="btn btn-primary btn-lg" type="button" onClick={this.resetAllFields}>Reset all fields</button>
          <button className="btn btn-primary btn-lg" type="button" onClick={this.checkAllFields}>Check all fields</button>
          <button className="btn btn-primary btn-lg" type="button">Diff fields</button>
        </div>
        <div className="diff-viewer">
          <ReactDiff
            highlightLines={this.state.highlightLine}
            onLineNumberClick={this.onLineNumberClick}
            oldValue={oldValueJson}
            splitView={this.state.splitView}
            newValue={newValueJson}
            renderContent={this.state.enableSyntaxHighlighting && this.syntaxHighlight}
          />
        </div>
      </div>
    )
  }
}

ReactDOM.render(
  <MySqlDiff/>,
  document.getElementById('app'),
)
