const path = require('path')
const HtmlWebpackPlugin = require('html-webpack-plugin')
const webpack = require('webpack')
const css = require('mini-css-extract-plugin')

module.exports = {
  entry: {
    main: './src/index.tsx',
  },
  mode: process.env.NODE_ENV === 'production'
    ? 'production'
    : 'development',
  resolve: {
    extensions: ['.jsx', '.tsx', '.ts', '.scss', '.css', '.js'],
  },
  output: {
    path: path.resolve(__dirname, '../nginx/pi_errors/dist'),
    filename: '[name].js',
  },
  devServer: {
    contentBase: path.resolve(__dirname, '../nginx/pi_errors/dist'),
    port: 8000,
    hot: true,
  },
  module: {
    rules: [
      {
        test: /\.tsx?$/,
        use: [
          {
            loader: 'ts-loader',
            options: {
              configFile: 'tsconfig.json',
            },
          },
        ],
        exclude: /node_modules/,
      },
      {
        test: /\.s?css$/,
        use: [
          css.loader,
          'css-loader',
          'sass-loader',
        ],
      },
      {
        test: /\.xml|.rjs|.java/,
        use: 'raw-loader',
      },
      {
        test: /\.svg|.png/,
        use: 'file-loader',
      },
    ],
  },
  plugins: [
    new HtmlWebpackPlugin({
      template: './src/index.ejs',
    }),
    new css({
      filename: 'main.css',
    }),
  ]
}
