use qbit;

use Test::Partner2::Simple;
use Test::Partner2::Mock;

use Test::More tests => 4;

run_tests(
    sub {
        my ($app) = @_;

        mock_mailer($app);
        mock_zora($app);
        mock_balance($app);
        mock_bk($app);
        mock_utils_partner2($app);

        # Создаем площадку с новым сайтом под пользователем

        change_cur_user($app, 'mocked-yan-partner');

        my $domain = 'some_new_domain.ru';

        my $site_id = $app->site->add(domain => $domain,);

        my $campaign_id = $app->context_on_site_campaign->add(
            caption   => $domain,
            domain_id => $site_id,
        );

        my $data = $app->context_on_site_campaign->get_all(
            fields => [qw(domain page_id multistate_name)],
            filter => [all_domain => 'LIKE' => $domain],
        );

        # Под системным пользователем, сначала отклоняем сайт в модерации,
        # а потом принимаем его и возвращаем площадку из отклоненных

        change_cur_user($app, 'yndx-developer');

        $app->site->do_action($site_id, 'reject');
        $app->site->do_action($site_id, 'return_to_moderation');
        $app->site->do_action($site_id, 'approve');

        my $campaign = $app->context_on_site_campaign->get_all(
            fields => [qw(domain page_id multistate_name actions)],
            filter => [all_domain => 'LIKE' => $domain],
        )->[0];

        # И после выполнения этих действий у площадки должен быть Page ID

        isnt($campaign->{page_id}, undef, 'Campaign has Page ID');

        $Test::Partner2::Mock::RUN_IN_CREATE_OR_UPDATE_PLACE = sub {
            my ($operator_uid, $opts) = @_;
            return if $opts->{URL} ne $domain;

            isnt($opts->{ID}, undef, 'Sending campaign with Page ID to balance');
        };

        $app->context_on_site_campaign->cron_init_campaigns();
    },
);
