use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;
use Test::Partner2::Mock;
use Test::More;

our $EDIT_PAGE_DATA;

sub update_in_bk {
    my ($app, $page_id) = @_;

    my $found_pages = $app->partner_db->_get_all('select * from all_pages_view where page_id = ?', $page_id);

    if (@$found_pages) {

        my ($id, $model) = @{$found_pages->[0]}{qw(id model)};

        my $page_id_field = $app->$model->get_page_id_field_name();

        $app->$model->do_action($id, 'set_need_update');
        $app->$model->update_in_bk({$page_id_field => $page_id});

    } else {
        throw Exception gettext('Page with Page ID %s not found', $page_id);
    }

    return 1;
}

run_tests(
    sub {
        my ($app) = @_;

        mock_bk($app);

        my %skip_models = map {$_ => 1} (

            # Эти типы блоков действительно не должны тестироваться в этом тесте
            # так как для них нет отдельной структуры в EditPage
            'context_on_site_market',
            'context_on_site_market_api',
            'context_on_site_mcb',
            'context_on_site_stripe',
            'internal_context_on_site_stripe',
            'search_on_site_market',
            'search_on_site_market_api',
            'search_on_site_mcb',

            # Для этих типов блоков нет ни одного блока в mocked_databases
            # TODO создать данные в mocked_databases для этих типов блоков
            'video_an_site_fullscreen',

            # По этим типам блоков есть данные в mocked_databases, но отправить их в БК не получается, скорее всего в базе лежат битые данные
            # TODO - поправить mocked_databases чтобы эти блоки нормально отправлялись в БК
            'internal_context_on_site_direct',
            'internal_search_on_site_premium',
            'video_an_site_inpage',
        );

        $Test::Partner2::Mock::RUN_IN_EDIT_PAGE = sub {
            my ($data) = @_;
            $EDIT_PAGE_DATA = $data;
            return 1;
        };

        my @block_models = grep {blessed($app->{$_}) && $app->$_->isa('Application::Model::Block')} sort keys(%$app);

        foreach my $block_model (@block_models) {

            next if $skip_models{$block_model};

            my $page_id_field_name = $app->$block_model->get_page_id_field_name();

            my $blocks = $app->$block_model->get_all(
                fields => [$app->$block_model->get_page_id_field_name(), 'id'],
                limit  => 1,
            );

            if (@$blocks == 1) {
                my $block    = $blocks->[0];
                my $page_id  = $block->{$page_id_field_name};
                my $block_id = $block->{id};

                update_in_bk($app, $page_id);

                my $section =
                  $block_model =~ /rtb/
                  || (grep {$_ eq $block_model} qw(video_an_site_instream context_on_site_adblock))
                  ? 'RtbBlocks'
                  : 'DirectBlocks';

                is($EDIT_PAGE_DATA->{0}->{$section}->{$block_id}->{BlockModel},
                    $block_model, "String '$block_model' is sending to BK");

            } else {
                fail("model $block_model has no blocks in mocked_databases");
            }

        }

    },
    do_not_die_on_fail => 1,
);
