use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

run_tests(
    sub {
        my ($app) = @_;

        # Долько для этих типов блока директа имеет смысл настройка url_backgound_color
        my %types = map {$_ => 1} qw(vertical modernAdaptive);

        my @models = qw(
          context_on_site_direct
          internal_context_on_site_direct
          internal_mobile_app_rtb
          internal_search_on_site_direct
          mobile_app_rtb
          search_on_site_direct
          );

        foreach my $model (@models) {
            my $fields = $app->$model->direct_block_types();

            foreach my $field (@$fields) {

                my $id = $field->{id};

                if ($field->{settings}) {

                    foreach my $type (keys %{$field->{settings}}) {
                        my @skip_fields = @{$field->{settings}->{$type}->{skip_fields} // []};

                        if (@skip_fields) {
                            if ($types{$id}) {
                                ok(
                                    (!grep {$_ eq 'url_background_color'} @skip_fields),
"model $model direct type $id with type $type don't have url_backgound_color in skip_fields"
                                  );
                            } else {
                                ok(
                                    (grep {$_ eq 'url_background_color'} @skip_fields),
"model $model direct type $id with type $type has url_backgound_color in skip_fields"
                                  );
                            }
                        }
                    }

                } else {

                    my @skip_fields = @{$field->{skip_fields} // []};

                    if (@skip_fields) {
                        if ($types{$id}) {
                            ok((!grep {$_ eq 'url_background_color'} @skip_fields),
                                "model $model direct type $id don't have url_backgound_color in skip_fields");
                        } else {
                            ok((grep {$_ eq 'url_background_color'} @skip_fields),
                                "model $model direct type $id has url_backgound_color in skip_fields");
                        }
                    }
                }
            }

        }

    },
    do_not_die_on_fail => 1,
);
