use strict;
use warnings FATAL => 'all';

use qbit;
use Test::Partner2::Simple;
use Test::More;

my %IGNORE_MODELS = (
    notification       => 1,    # Remove after PI-13411
    user_notifications => 1,    # Remove after PI-13411
    event_log          => 1,
);

run_tests(
    sub {
        my ($app) = @_;

        # Exceptions from Application::Model::ActionLog _action_model_accessor
        # Should be patched in case this test fails
        my %exceptions = (moderation_queue_action_log => 'moderation',);

        my $table = $app->partner_db->get_all_meta()->{'tables'};
        my @action_log_tables = grep {m/_action_log$/} keys %$table;

        foreach my $action_log_table (@action_log_tables) {
            my $accessor = $action_log_table;

            if (exists($exceptions{$accessor})) {
                $accessor = $exceptions{$accessor};
            } else {
                $accessor =~ s/_action_log$//;
            }

            next if $IGNORE_MODELS{$accessor};
            ok($app->can($accessor), "Model $accessor for table $action_log_table");
        }

    },
    dont_create_database => 1
);
