#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;

use Test::More;

use PiConstants qw($TECHNICAL_RTB_BLOCK_ID);

use qbit;

use Utils::UniqueID qw(make_unique_id);

run_tests(
    sub {
        my ($app) = @_;

        foreach my $block_model (qw(context_on_site_rtb internal_context_on_site_rtb)) {
            my $page_model = $app->$block_model->get_campaign_model_name();

            my $page_id =
              $app->$page_model->get_all(fields => [qw(page_id)], filter => {multistate => 'working'})->[0]{'page_id'};

            my $rtb_settings =
              $app->partner_db->context_on_site_rtb->get_all(limit => 1, filter => {model => $block_model})->[0];

            $rtb_settings->{'model'}         = $block_model;
            $rtb_settings->{'caption'}       = 'Технический RTB Блок';
            $rtb_settings->{'campaign_id'}   = $page_id;
            $rtb_settings->{'id'}            = $TECHNICAL_RTB_BLOCK_ID;
            $rtb_settings->{'strategy'}      = 3;
            $rtb_settings->{'media_active'}  = 1;
            $rtb_settings->{'media_blocked'} = 1;
            $rtb_settings->{'text_active'}   = 0;
            $rtb_settings->{'unique_id'}     = make_unique_id($block_model, $page_id, $TECHNICAL_RTB_BLOCK_ID);
            delete($rtb_settings->{'is_mobile_mediation'});

            $app->partner_db->context_on_site_rtb->add($rtb_settings);

            $app->partner_db->media_sizes->add(
                {page_id => $page_id, block_id => $TECHNICAL_RTB_BLOCK_ID, type => '240x400'});

            my $got = {$app->$block_model->get_bk_data($page_id)};

            ok($got->{'rtb_blocks'}{$TECHNICAL_RTB_BLOCK_ID}{'AdTypeSet'}{'media-performance'} == 1,
                "media-performance = 1 for $block_model");

            ok($got->{'rtb_blocks'}{$TECHNICAL_RTB_BLOCK_ID}{'AdTypeSet'}{'media'} == 1, "media = 1 for $block_model");
        }
    },
);
