#!/usr/bin/perl -w

use Test::Partner2::Simple;
use Test::Most;
use Test::Deep;

use qbit;

my $PAGE_MODELS = [
    qw(
      context_on_site_campaign
      search_on_site_campaign
      video_an_site
      mobile_app_settings
      internal_context_on_site_campaign
      internal_search_on_site_campaign
      internal_mobile_app
      ssp_context_on_site_campaign
      ssp_mobile_app_settings
      ssp_video_an_site
      indoor
      outdoor
      )
];

my $ROLE = 'Application::Model::Role::Block::Has::BlocksLimit';

my $ACTION_IN_ROLE =
  {map {$_ => TRUE}
      qw(delete delete_from_adfox delete_with_page delete_with_vmap restore restore_with_page restore_with_vmap add duplicate)
  };

run_tests(
    sub {
        my ($app) = @_;

        foreach my $page_model (@{$PAGE_MODELS}) {

            foreach my $block_model (@{$app->$page_model->get_block_model_names()}) {

                if ($app->$block_model->DOES($ROLE)) {

                    my $multistates_graph = $app->$block_model->get_structure_multistates_graph();

                    foreach my $action (@{$multistates_graph->{'multistate_actions'}}) {

                        if (exists $action->{'set_flags'}) {

                            foreach my $flag (@{$action->{'set_flags'}}) {

                                if ($flag eq 'deleted') {
                                    my $action_check = $action->{'action'};
                                    fail(
"model $block_model has action $action_check which changes blocks_count but role CountPageBlocks doesnt"
                                    ) unless exists $ACTION_IN_ROLE->{$action_check};
                                }
                            }
                        } elsif (exists $action->{'reset_flags'}) {
                            foreach my $flag (@{$action->{'reset_flags'}}) {
                                if ($flag eq 'deleted') {
                                    my $action_check = $action->{'action'};
                                    fail(
"model $block_model has action $action_check which changes blocks_count but role CountPageBlocks doesnt"
                                    ) unless exists $ACTION_IN_ROLE->{$action_check};
                                }
                            }
                        }
                    }
                }
            }
        }
    }
);
