use strict;
use warnings FATAL => 'all';

use qbit;

use SOAP::Lite;

use Test::More;
use Test::Partner2::Simple;
use Test::Partner2::Mock;

# set this to TRUE if you want to check records MANUALLY at https://error.yandex-team.ru/projects/partner/
my $USE_REAL_ERROR_BOOSTER = FALSE;

$ENV{'LAZY_LOAD'} = FALSE;

# Util::Logger skips sentry->send_exception if $ENV{TAP_VERSION} set
$ENV{TAP_VERSION} = FALSE;

my $client_id = 11009;

run_tests(
    sub {
        my ($app) = @_;

        my $idx            = 0;
        my @soapFaultReply = (
            [
                1 =>
"Got error from banner system. (page_id=645583) Block 4 has DSPType = 17, DSP 2563070 has DSPType = 2\n(page_id=645583) \nData: {\"0\":{\"OnlyPictureA\":\"0\",\"PicturesEnabled\":\"1\",\"CreateDate\":\"2020-10-02 20:33:36\",\"Options\":\"ReloadTimeout=30\",\"PIEditTime\":\"2021-12-27 07:58:39\",\"BannerLang\":[\"by\",\"en\",\"kz\",\"ru\",\"uk\"],\"TargetTags\":[],\"PageCaption\":\"la-faza\",\"excludeddomains\":\"la-faza.com\",\"Mirrors\":\"yastatic.net,yandex-team.ru,yandex.az,yandex.by,yandex.com,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yandex.co.il,yandex.com.am,yandex.com.ge,yandex.com.tr\",\"Description\":\"la-faza.com\",\"OrderTags\":[],\"isPi2\":\"1\",\"FastContext\":\"1\",\"PageID\":\"645583\",\"Name\":\"la-faza.com\",\"State\":\"1\",\"Login\":\"vitaliyplotnikov1989\",\"PPCTotal\":\"9\",\"IsGraySite\":\"0\",\"PartnerID\":\"82529513\",\"MobileAppMode\":\"0\",\"RtbBlocks\":{\"1\":{\"DirectLimit\":\"2\",\"AdType\":{},\"Geo\":{},\"AlternativeCode\":\"\",\"PageImpOptions\":{\"Enable\":[],\"Disable\":[\"amp\",\"filter-sizes\",\"ignore-0x0-adaptive-sizes\",\"rtbshadow\",\"turbo\",\"turbo-desktop\"]},\"AltHeight\":\"0\",\"OptimizeType\":\"1\",\"Sizes\":[{\"Width\":\"300\",\"H\n\nRequest: POST http://bssoap-pi.yandex.ru/ HTTP/1.1\n Accept: text/xml\n Accept: multipart/*\n Accept: application/soap\n User-Agent: SOAP::Lite/Perl/0.714\n Content-Length: 39982\n Content-Type: text/xml\n SOAPAction: \"YaBSSOAPContext#EditPage\"\n \n <?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:namesp1=\"http://namespaces.soaplite.com/perl\"><soap:Body><EditPage xmlns=\"YaBSSOAPContext\"><c-gensym48 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"namesp1:SOAPStruct\"><OnlyPicture xsi:type=\"xsd:int\">0</OnlyPicture><PicturesEnabled xsi:type=\"xsd:int\">1</PicturesEnabled><CreateDate xsi:type=\"xsd:string\">2020-10-02 20:33:36</CreateDate><Options xsi:type=\"xsd:str\nResponse: <?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><namesp2:EditPageResponse xmlns:namesp2=\"YaBSSOAPContext\"><s-gensym6 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"apachens:SOAPStruct\"><Error xsi:type=\"xsd:int\">1</Error><PageID xsi:type=\"xsd:int\">645583</PageID><ErrorStr xsi:type=\"xsd:string\">Block 2 has DSPType = 1, DSP 2563070 has DSPType = 2</ErrorStr></value></item><item><key xsi:type=\"xsd:string\">BACKEND_HOST</key><value xsi:type=\"xsd:string\">bssoap06i</value></item></s-gensym6></namesp2:EditPageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>\nResponse headers: Connection: close\n Date: Mon, 27 Dec 2021 09:42:28 GMT\n Server: nginx/1.14.2\n Vary: Accept-Encoding\n Content-Length: 938\n Content-Type: text/xml\n Client-Date: Mon, 27 Dec 2021 09:42:28 GMT\n Client-Peer: 2a02:6b8:0:3400:0:aec:0:1:80\n Client-Response-Num: 1\n SOAPServer: SOAP::Lite/Perl/0.55\n"
            ],
            [
                1 =>
"Got error from banner system. (page_id=645583) Block 7 has DSPType = 1, DSP 563070 has DSPType = 3\n(page_id=645583) \nData: {\"0\":{\"OnlyPictureB\":\"0\",\"PicturesEnabled\":\"1\",\"CreateDate\":\"2020-10-02 20:33:36\",\"Options\":\"ReloadTimeout=30\",\"PIEditTime\":\"2021-12-27 07:58:39\",\"BannerLang\":[\"by\",\"en\",\"kz\",\"ru\",\"uk\"],\"TargetTags\":[],\"PageCaption\":\"la-faza\",\"excludeddomains\":\"la-faza.com\",\"Mirrors\":\"yastatic.net,yandex-team.ru,yandex.az,yandex.by,yandex.com,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yandex.co.il,yandex.com.am,yandex.com.ge,yandex.com.tr\",\"Description\":\"la-faza.com\",\"OrderTags\":[],\"isPi2\":\"1\",\"FastContext\":\"1\",\"PageID\":\"645583\",\"Name\":\"la-faza.com\",\"State\":\"1\",\"Login\":\"vitaliyplotnikov1989\",\"PPCTotal\":\"9\",\"IsGraySite\":\"0\",\"PartnerID\":\"82529513\",\"MobileAppMode\":\"0\",\"RtbBlocks\":{\"1\":{\"DirectLimit\":\"2\",\"AdType\":{},\"Geo\":{},\"AlternativeCode\":\"\",\"PageImpOptions\":{\"Enable\":[],\"Disable\":[\"amp\",\"filter-sizes\",\"ignore-0x0-adaptive-sizes\",\"rtbshadow\",\"turbo\",\"turbo-desktop\"]},\"AltHeight\":\"0\",\"OptimizeType\":\"1\",\"Sizes\":[{\"Width\":\"300\",\"H\n\nRequest: POST http://bssoap-pi.yandex.ru/ HTTP/1.1\n Accept: text/xml\n Accept: multipart/*\n Accept: application/soap\n User-Agent: SOAP::Lite/Perl/0.714\n Content-Length: 39982\n Content-Type: text/xml\n SOAPAction: \"YaBSSOAPContext#EditPage\"\n \n <?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:namesp1=\"http://namespaces.soaplite.com/perl\"><soap:Body><EditPage xmlns=\"YaBSSOAPContext\"><c-gensym48 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"namesp1:SOAPStruct\"><OnlyPicture xsi:type=\"xsd:int\">0</OnlyPicture><PicturesEnabled xsi:type=\"xsd:int\">1</PicturesEnabled><CreateDate xsi:type=\"xsd:string\">2020-10-02 20:33:36</CreateDate><Options xsi:type=\"xsd:str\nResponse: <?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><namesp2:EditPageResponse xmlns:namesp2=\"YaBSSOAPContext\"><s-gensym6 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"apachens:SOAPStruct\"><Error xsi:type=\"xsd:int\">1</Error><PageID xsi:type=\"xsd:int\">645583</PageID><ErrorStr xsi:type=\"xsd:string\">Block 2 has DSPType = 1, DSP 2563070 has DSPType = 2</ErrorStr></value></item><item><key xsi:type=\"xsd:string\">BACKEND_HOST</key><value xsi:type=\"xsd:string\">bssoap06i</value></item></s-gensym6></namesp2:EditPageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>\nResponse headers: Connection: close\n Date: Mon, 27 Dec 2021 09:42:28 GMT\n Server: nginx/1.14.2\n Vary: Accept-Encoding\n Content-Length: 938\n Content-Type: text/xml\n Client-Date: Mon, 27 Dec 2021 09:42:28 GMT\n Client-Peer: 2a02:6b8:0:3400:0:aec:0:1:80\n Client-Response-Num: 1\n SOAPServer: SOAP::Lite/Perl/0.55\n"
            ],
            [
                1 =>
"Got error from banner system. (page_id=645583) Block 7 has DSPType = 1, DSP 563070 has DSPType = 3\n(page_id=645583) \nData: {\"0\":{\"OnlyPictureC\":\"0\",\"PicturesEnabled\":\"1\",\"CreateDate\":\"2020-10-02 20:33:36\",\"Options\":\"ReloadTimeout=30\",\"PIEditTime\":\"2021-12-27 07:58:39\",\"BannerLang\":[\"by\",\"en\",\"kz\",\"ru\",\"uk\"],\"TargetTags\":[],\"PageCaption\":\"la-faza\",\"excludeddomains\":\"la-faza.com\",\"Mirrors\":\"yastatic.net,yandex-team.ru,yandex.az,yandex.by,yandex.com,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yandex.co.il,yandex.com.am,yandex.com.ge,yandex.com.tr\",\"Description\":\"la-faza.com\",\"OrderTags\":[],\"isPi2\":\"1\",\"FastContext\":\"1\",\"PageID\":\"645583\",\"Name\":\"la-faza.com\",\"State\":\"1\",\"Login\":\"vitaliyplotnikov1989\",\"PPCTotal\":\"9\",\"IsGraySite\":\"0\",\"PartnerID\":\"82529513\",\"MobileAppMode\":\"0\",\"RtbBlocks\":{\"1\":{\"DirectLimit\":\"2\",\"AdType\":{},\"Geo\":{},\"AlternativeCode\":\"\",\"PageImpOptions\":{\"Enable\":[],\"Disable\":[\"amp\",\"filter-sizes\",\"ignore-0x0-adaptive-sizes\",\"rtbshadow\",\"turbo\",\"turbo-desktop\"]},\"AltHeight\":\"0\",\"OptimizeType\":\"1\",\"Sizes\":[{\"Width\":\"300\",\"H\n\nRequest: POST http://bssoap-pi.yandex.ru/ HTTP/1.1\n Accept: text/xml\n Accept: multipart/*\n Accept: application/soap\n User-Agent: SOAP::Lite/Perl/0.714\n Content-Length: 39982\n Content-Type: text/xml\n SOAPAction: \"YaBSSOAPContext#EditPage\"\n \n <?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:namesp1=\"http://namespaces.soaplite.com/perl\"><soap:Body><EditPage xmlns=\"YaBSSOAPContext\"><c-gensym48 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"namesp1:SOAPStruct\"><OnlyPicture xsi:type=\"xsd:int\">0</OnlyPicture><PicturesEnabled xsi:type=\"xsd:int\">1</PicturesEnabled><CreateDate xsi:type=\"xsd:string\">2020-10-02 20:33:36</CreateDate><Options xsi:type=\"xsd:str\nResponse: <?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><namesp2:EditPageResponse xmlns:namesp2=\"YaBSSOAPContext\"><s-gensym6 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"apachens:SOAPStruct\"><Error xsi:type=\"xsd:int\">1</Error><PageID xsi:type=\"xsd:int\">645583</PageID><ErrorStr xsi:type=\"xsd:string\">Block 2 has DSPType = 1, DSP 2563070 has DSPType = 2</ErrorStr></value></item><item><key xsi:type=\"xsd:string\">BACKEND_HOST</key><value xsi:type=\"xsd:string\">bssoap06i</value></item></s-gensym6></namesp2:EditPageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>\nResponse headers: Connection: close\n Date: Mon, 27 Dec 2021 09:42:28 GMT\n Server: nginx/1.14.2\n Vary: Accept-Encoding\n Content-Length: 938\n Content-Type: text/xml\n Client-Date: Mon, 27 Dec 2021 09:42:28 GMT\n Client-Peer: 2a02:6b8:0:3400:0:aec:0:1:80\n Client-Response-Num: 1\n SOAPServer: SOAP::Lite/Perl/0.55\n"
            ],
            [
                1 =>
"Got error from banner system. (page_id=645583) Block 30 has DSPType = 8, DSP 63070 has DSPType = 12\n(page_id=645583) \nData: {\"0\":{\"OnlyPictureD\":\"0\",\"PicturesEnabled\":\"1\",\"CreateDate\":\"2020-10-02 20:33:36\",\"Options\":\"ReloadTimeout=30\",\"PIEditTime\":\"2021-12-27 07:58:39\",\"BannerLang\":[\"by\",\"en\",\"kz\",\"ru\",\"uk\"],\"TargetTags\":[],\"PageCaption\":\"la-faza\",\"excludeddomains\":\"la-faza.com\",\"Mirrors\":\"yastatic.net,yandex-team.ru,yandex.az,yandex.by,yandex.com,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yandex.co.il,yandex.com.am,yandex.com.ge,yandex.com.tr\",\"Description\":\"la-faza.com\",\"OrderTags\":[],\"isPi2\":\"1\",\"FastContext\":\"1\",\"PageID\":\"645583\",\"Name\":\"la-faza.com\",\"State\":\"1\",\"Login\":\"vitaliyplotnikov1989\",\"PPCTotal\":\"9\",\"IsGraySite\":\"0\",\"PartnerID\":\"82529513\",\"MobileAppMode\":\"0\",\"RtbBlocks\":{\"1\":{\"DirectLimit\":\"2\",\"AdType\":{},\"Geo\":{},\"AlternativeCode\":\"\",\"PageImpOptions\":{\"Enable\":[],\"Disable\":[\"amp\",\"filter-sizes\",\"ignore-0x0-adaptive-sizes\",\"rtbshadow\",\"turbo\",\"turbo-desktop\"]},\"AltHeight\":\"0\",\"OptimizeType\":\"1\",\"Sizes\":[{\"Width\":\"300\",\"H\n\nRequest: POST http://bssoap-pi.yandex.ru/ HTTP/1.1\n Accept: text/xml\n Accept: multipart/*\n Accept: application/soap\n User-Agent: SOAP::Lite/Perl/0.714\n Content-Length: 39982\n Content-Type: text/xml\n SOAPAction: \"YaBSSOAPContext#EditPage\"\n \n <?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:namesp1=\"http://namespaces.soaplite.com/perl\"><soap:Body><EditPage xmlns=\"YaBSSOAPContext\"><c-gensym48 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"namesp1:SOAPStruct\"><OnlyPicture xsi:type=\"xsd:int\">0</OnlyPicture><PicturesEnabled xsi:type=\"xsd:int\">1</PicturesEnabled><CreateDate xsi:type=\"xsd:string\">2020-10-02 20:33:36</CreateDate><Options xsi:type=\"xsd:str\nResponse: <?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><namesp2:EditPageResponse xmlns:namesp2=\"YaBSSOAPContext\"><s-gensym6 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"apachens:SOAPStruct\"><Error xsi:type=\"xsd:int\">1</Error><PageID xsi:type=\"xsd:int\">645583</PageID><ErrorStr xsi:type=\"xsd:string\">Block 2 has DSPType = 1, DSP 2563070 has DSPType = 2</ErrorStr></value></item><item><key xsi:type=\"xsd:string\">BACKEND_HOST</key><value xsi:type=\"xsd:string\">bssoap06i</value></item></s-gensym6></namesp2:EditPageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>\nResponse headers: Connection: close\n Date: Mon, 27 Dec 2021 09:42:28 GMT\n Server: nginx/1.14.2\n Vary: Accept-Encoding\n Content-Length: 938\n Content-Type: text/xml\n Client-Date: Mon, 27 Dec 2021 09:42:28 GMT\n Client-Peer: 2a02:6b8:0:3400:0:aec:0:1:80\n Client-Response-Num: 1\n SOAPServer: SOAP::Lite/Perl/0.55\n"
            ],
            [
                1 =>
"Got error from banner system. (page_id=645583) DSP with DSPID = 2563457  doesn't exist in DB\n(page_id=645583) \nData: {\"0\":{\"OnlyPictureE\":\"0\",\"PicturesEnabled\":\"1\",\"CreateDate\":\"2020-10-02 20:33:36\",\"Options\":\"ReloadTimeout=30\",\"PIEditTime\":\"2021-12-27 07:58:39\",\"BannerLang\":[\"by\",\"en\",\"kz\",\"ru\",\"uk\"],\"TargetTags\":[],\"PageCaption\":\"la-faza\",\"excludeddomains\":\"la-faza.com\",\"Mirrors\":\"yastatic.net,yandex-team.ru,yandex.az,yandex.by,yandex.com,yandex.ee,yandex.fr,yandex.kg,yandex.kz,yandex.lt,yandex.lv,yandex.md,yandex.ru,yandex.tj,yandex.tm,yandex.ua,yandex.uz,yandex.co.il,yandex.com.am,yandex.com.ge,yandex.com.tr\",\"Description\":\"la-faza.com\",\"OrderTags\":[],\"isPi2\":\"1\",\"FastContext\":\"1\",\"PageID\":\"645583\",\"Name\":\"la-faza.com\",\"State\":\"1\",\"Login\":\"vitaliyplotnikov1989\",\"PPCTotal\":\"9\",\"IsGraySite\":\"0\",\"PartnerID\":\"82529513\",\"MobileAppMode\":\"0\",\"RtbBlocks\":{\"1\":{\"DirectLimit\":\"2\",\"AdType\":{},\"Geo\":{},\"AlternativeCode\":\"\",\"PageImpOptions\":{\"Enable\":[],\"Disable\":[\"amp\",\"filter-sizes\",\"ignore-0x0-adaptive-sizes\",\"rtbshadow\",\"turbo\",\"turbo-desktop\"]},\"AltHeight\":\"0\",\"OptimizeType\":\"1\",\"Sizes\":[{\"Width\":\"300\",\"H\n\nRequest: POST http://bssoap-pi.yandex.ru/ HTTP/1.1\n Accept: text/xml\n Accept: multipart/*\n Accept: application/soap\n User-Agent: SOAP::Lite/Perl/0.714\n Content-Length: 39982\n Content-Type: text/xml\n SOAPAction: \"YaBSSOAPContext#EditPage\"\n \n <?xml version=\"1.0\" encoding=\"UTF-8\"?><soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" soap:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:namesp1=\"http://namespaces.soaplite.com/perl\"><soap:Body><EditPage xmlns=\"YaBSSOAPContext\"><c-gensym48 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"namesp1:SOAPStruct\"><OnlyPicture xsi:type=\"xsd:int\">0</OnlyPicture><PicturesEnabled xsi:type=\"xsd:int\">1</PicturesEnabled><CreateDate xsi:type=\"xsd:string\">2020-10-02 20:33:36</CreateDate><Options xsi:type=\"xsd:str\nResponse: <?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:apachens=\"http://xml.apache.org/xml-soap\" xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><namesp2:EditPageResponse xmlns:namesp2=\"YaBSSOAPContext\"><s-gensym6 xsi:type=\"apachens:Map\"><item><key xsi:type=\"xsd:int\">0</key><value xsi:type=\"apachens:SOAPStruct\"><Error xsi:type=\"xsd:int\">1</Error><PageID xsi:type=\"xsd:int\">645583</PageID><ErrorStr xsi:type=\"xsd:string\">Block 2 has DSPType = 1, DSP 2563070 has DSPType = 2</ErrorStr></value></item><item><key xsi:type=\"xsd:string\">BACKEND_HOST</key><value xsi:type=\"xsd:string\">bssoap06i</value></item></s-gensym6></namesp2:EditPageResponse></SOAP-ENV:Body></SOAP-ENV:Envelope>\nResponse headers: Connection: close\n Date: Mon, 27 Dec 2021 09:42:28 GMT\n Server: nginx/1.14.2\n Vary: Accept-Encoding\n Content-Length: 938\n Content-Type: text/xml\n Client-Date: Mon, 27 Dec 2021 09:42:28 GMT\n Client-Peer: 2a02:6b8:0:3400:0:aec:0:1:80\n Client-Response-Num: 1\n SOAPServer: SOAP::Lite/Perl/0.55\n"
            ],
        );
        mock_subs(
            {
                'SOAP::Lite::call' => sub {
                    my ($self, $method, $params) = @_;
                    my ($err, $errStr) = @{$soapFaultReply[$idx]};
                    $idx = ($idx + 1) % @soapFaultReply;
                    my $som = SOAP::SOM->new();
                    Test::MockObject::Extends->new($som);
                    $som->mock(
                        paramsall => sub {
                            +{
                                0 => {
                                    Error    => $err,
                                    PageID   => $params->{0}->{PageID},
                                    ErrorStr => $errStr
                                }
                             };
                        }
                    );
                    return $som;
                },
            }
        );

        my %fingerprints;
        mock_subs(
            {
                'Application::Model::API::Yandex::SelfService::logbroker' => sub {
                    my ($self, %params) = @_;
                    if ($params{topic} eq 'partner.error-booster') {
                        my $fp = $params{data}[0]{fingerprint};
                        diag "fingerprint <$fp>";
                        $fingerprints{$fp}++;
                    }
                    return TRUE;
                },
            }
        ) unless $USE_REAL_ERROR_BOOSTER;

        foreach my $page (40, 400, 801, 802, 43569) {
            try {
                $app->api_bk->create_or_update_campaign(
                    {
                        page_id       => $page,
                        client_id     => $client_id,
                        product_id    => 'video_an_site',
                        product_type  => 'video',
                        target_type   => 3,
                        banners_count => 9,
                        places        => {},
                    }
                );
            }
            catch {
                my $exception = shift;
                $app->exception_dumper->dump_as_html_file($exception);
            };
        }

        is(scalar(keys(%fingerprints)) => 2, '2 unique fingerprints') unless $USE_REAL_ERROR_BOOSTER;
    },
    mock_http => 0,
    mocks     => {mock_selfservice => !$USE_REAL_ERROR_BOOSTER},
);
