use strict;
use warnings FATAL => 'all';

use Test::Deep;

use Test::Partner2::Simple;
use qbit;

use RoleRights;

my $fixture = {
    'no roles - undef' => {
        role_ids => undef,
        expect   => {}
    },
    'no roles - empty array' => {
        role_ids => [],
        expect   => {

        }
    },
    'with roles' => {
        role_ids => [2, 17],
        expect   => {
            'mobile_app_rtb_view' => {'17' => 1},
            'dsp_add_other'       => {'2'  => 1}
        }
    },
};

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        *{'RoleRights::_read_role_right'} = sub {
            return {
                'dsp_add_other'       => {map {$_ => 1} 2,  8},
                'mobile_app_rtb_view' => {map {$_ => 1} 15, 17}
            };
        };

        my $db = RoleRights->new('production');

        foreach my $test_name (sort keys %$fixture) {
            my ($role_ids, $expect) = @{$fixture->{$test_name}}{qw( role_ids  expect )};

            my $got = $db->get_rights_by_role_ids($role_ids);

            cmp_deeply($got, $expect, $test_name);
        }
    },
    dont_create_database => 1,
);
