use strict;
use warnings FATAL => 'all';

use Test::Deep;

use Test::Partner2::Simple;
use qbit;

use RoleRights;

my $fixture = {
    'no roles with fields' => {
        role_ids => undef,
        fields   => [qw(right role_id)],
        expect   => [
            {
                'right'   => 'dsp_add_other',
                'role_id' => 2
            },
            {
                'right'   => 'dsp_add_other',
                'role_id' => 8
            },
            {
                'right'   => 'mobile_app_rtb_view',
                'role_id' => 15
            },
            {
                'right'   => 'mobile_app_rtb_view',
                'role_id' => 17
            }
        ]
    },
    'roles with fields' => {
        role_ids => [2, 17],
        fields   => [qw(right role_id)],
        expect   => [
            {
                'right'   => 'dsp_add_other',
                'role_id' => 2
            },
            {
                'right'   => 'mobile_app_rtb_view',
                'role_id' => 17
            }
        ]
    },
    'roles with "role_id" field only' => {
        role_ids => [2, 17],
        fields   => [qw(role_id)],
        expect => [{'role_id' => 2}, {'role_id' => 17}]
    },
    'roles with "right" field only' => {
        role_ids => [2, 17],
        fields   => [qw(right)],
        expect => [{'right' => 'dsp_add_other',}, {'right' => 'mobile_app_rtb_view',}]
    },
};

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        *{'RoleRights::_read_role_right'} = sub {
            return {
                'dsp_add_other'       => {map {$_ => 1} 2,  8},
                'mobile_app_rtb_view' => {map {$_ => 1} 15, 17}
            };
        };

        my $db = RoleRights->new('production');

        foreach my $test_name (sort keys %$fixture) {
            my ($role_ids, $fields, $expect) = @{$fixture->{$test_name}}{qw( role_ids  fields  expect )};

            my $got = $db->get_roles_rights($role_ids, $fields);

            cmp_deeply($got, $expect, $test_name);
        }
    },
    dont_create_database => 1,
);
