
use strict;
use warnings FATAL => 'all';

use PiConstants qw( $GROUP_YNDX_SERVICES :ROLES );

use Test::Partner2::Simple;
use Test::More;

use qbit;
use RoleRights;

run_tests(
    sub {
        my ($app) = @_;

        my $role_rights = RoleRights->new('production')->get_rights();

        my $external_page_accessors = {map {$_ => 1} @{$app->product_manager->get_external_product_accessors()}};

        my $product_accessors = {
            map {$_ => 1} @{$app->product_manager->get_page_model_accessors()},
            @{$app->product_manager->get_block_model_names()}
        };

        my $all_roles = {map {$_->{id} => $_} grep {$_->{id} != $DEVELOPER_ROLE_ID} @{$app->rbac->get_roles()}};

        my $internal_roles =
          {map {$_ => $all_roles->{$_}} grep {$all_roles->{$_}->{group} == $GROUP_YNDX_SERVICES} keys %$all_roles};
        my $external_roles = {
            map {$_ => $all_roles->{$_}}
            grep {$_ != $DEVELOPER_ROLE_ID && !$internal_roles->{$_}} keys %$all_roles
        };

        # Чтобы не закладываться на кол-во тестов
        cmp_ok(scalar(keys %$role_rights), '>', 500, 'Rights > 500');

        foreach my $right (sort keys %$role_rights) {

            my $cur_right_roles = $role_rights->{$right};

            my ($accessor) = ($right =~ /^(.*)_(?:edit|view)_field__/);
            $accessor //= '';

            my $is_internal = ($right =~ /^internal/) ? 1 : 0;

            my $manger_role_id = $is_internal ? $INTERNAL_YAN_MANAGER_ROLE_ID : $YAN_MANAGER_ROLE_ID;
            my $viewer_role_id = $is_internal ? $INTERNAL_YAN_VIEWER_ROLE_ID  : $YAN_VIEWER_ROLE_ID;

            # Каждый тип продукта должен давать права только своим ролям
            # TODO: bk_statistics, dsp
            if ($product_accessors->{$accessor}) {

                my $type = $is_internal ? 'Internal' : 'External';

                my @foreign_roles_by_type = $is_internal ? keys(%$external_roles) : keys(%$internal_roles);

                my @foreign_roles = grep {$cur_right_roles->{$_}} @foreign_roles_by_type;

                if (@foreign_roles) {
                    fail(
                        sprintf(
                            '%s product has right (%s) with foreign roles(%s)',
                            $type, $right, join(',', sort {$a <=> $b} @foreign_roles)
                        )
                    ) if @foreign_roles;
                }
            }

            # Разработчик должен видеть все поля
            if ($right =~ /_(view|edit)_field__/) {
                fail(sprintf('Right (%s) has no Developer role', $right))
                  unless $cur_right_roles->{$DEVELOPER_ROLE_ID};
            }

            # Для внутренних, если есть права для Менеджера, то должны быть и для Администратора
            fail(sprintf('Right (%s) has INTERNAL_MANAGER role but has no INTERNAL_ADMINISTRATOR role', $right))
              if $cur_right_roles->{$INTERNAL_YAN_MANAGER_ROLE_ID}
                  && !$cur_right_roles->{$INTERNAL_YAN_ADMINISTRATOR_ROLE_ID};

            # Если Партнер видит поле, то и Менеджер и Ассистент партнера тоже должены видеть это поле
            if (   ($right =~ /_view_field__/ || $right =~ /_view_stat_/)
                && ($cur_right_roles->{$SITE_PARTNER_ROLE_ID} || $cur_right_roles->{$VIDEO_PARTNER_ROLE_ID}))
            {
                fail(sprintf('Right (%s) has PARTNER(SITE OR VIDEO) role but has no MANAGER role', $right))
                  unless $cur_right_roles->{$manger_role_id};

                fail(sprintf('Right (%s) has PARTNER(SITE OR VIDEO) role but has no PARTNER_ASSISTANT role', $right))
                  if $right !~ /_view_field__assistants/
                      && !$is_internal
                      && !$cur_right_roles->{$YAN_PARTNER_ASSISTANT_ROLE_ID};
            }

            # Если Менеджер может видеть поле, то это же должен видеть Наблюдатель
            if ($right =~ /_view_field__/ && !(grep {$accessor eq $_} qw(inviter  simple_notification))) {
                fail(sprintf('Right (%s) has MANAGER role but has no VIEWER role', $right))
                  if $cur_right_roles->{$manger_role_id}
                      && !$cur_right_roles->{$viewer_role_id};
            }

            # Во всех внешних пейджах, если Партнер может видеть или редактировать поле, то это же должен уметь и TUTBY
            if ($right =~ /(edit|view)_field__/ && $external_page_accessors->{$accessor}) {
                fail(sprintf('Right (%s) has role PARTNER(SITE OR VIDEO) but has no TUTBY role', $right))
                  if ($cur_right_roles->{$SITE_PARTNER_ROLE_ID} || $cur_right_roles->{$VIDEO_PARTNER_ROLE_ID})
                  && !$cur_right_roles->{$TUTBY_ROLE_ID};
            }

            # Для Менеджеров не должно быть прав (view|edit)_fields если нет права view_all
            if (   $right =~ /(edit|view)_field__/
                && $cur_right_roles->{$manger_role_id}
                && !$is_internal
                && $product_accessors->{$accessor})
            {
                (my $viewall_right = $right) =~ s/(edit|view)_.*/view_all/;
                my $viewall_roles = $role_rights->{$viewall_right} // {};
                fail(
                    sprintf(
                        'Manager (%s) has right "%s" but has not right "%s"',
                        $manger_role_id, $right, $viewall_right
                    )
                  )
                  if $cur_right_roles->{$manger_role_id}
                      && !$viewall_roles->{$manger_role_id};
            }

            # Все роли кроме ассистентов имеющие право Видеть или Редактировать поле, также должны иметь право Видеть саму Модель
            # (Если нет _view, то не должно быть view|edit_field)
            if ($right =~ /_(view|edit)_field__/) {

                my $view_model_right = sprintf '%s_view', $accessor;
                my $view_roles = $role_rights->{$view_model_right};

                my @diff = ($right =~ /^(owner_site|statistics)_/) ? () : (keys %$cur_right_roles);
                if (defined $view_roles) {
                    @diff = grep {$_ != $BUSINESS_UNIT_ROLE_ID}
                      grep {
                        !(
                            $accessor eq 'users' && ($_ == $INTERNAL_YAN_MANAGER_ROLE_ID
                                || $_ == $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID)
                         )
                      }
                      grep {
                        !($accessor eq 'context_on_site_adblock' && ($_ == $YAN_PARTNER_ASSISTANT_ROLE_ID))
                      }
                      grep {
                        !(
                            $accessor eq 'site' && ($_ == $SITE_PARTNER_ROLE_ID
                                || $_ == $YAN_PARTNER_ASSISTANT_ROLE_ID
                                || $_ == $TUTBY_ROLE_ID)
                         )
                      }
                      grep {
                        !(
                            $accessor eq 'dsp' && ($_ == $INTERNAL_YAN_ADMINISTRATOR_ROLE_ID
                                || $_ == $INTERNAL_YAN_MANAGER_ROLE_ID
                                || $_ == $INTERNAL_YAN_VIEWER_ROLE_ID)
                         )
                      }
                      grep {
                        !exists($view_roles->{$_})
                      } keys %$cur_right_roles;
                }

                fail(
                    sprintf(
                        'Roles (%s) has right "%s" but has not right "%s"',
                        join(', ', sort {$a <=> $b} @diff),
                        $right, $view_model_right
                    )
                ) if @diff;
            }

            # Все роли имеющие право Редактировать поле, также должны иметь право его Видеть
            if ($right =~ /_edit_field__\w+/) {
                (my $view_right = $right) =~ s/_edit_field__/_view_field__/;

                my $view_roles = $role_rights->{$view_right};
                if (defined $view_roles) {
                    my $edit_roles = $cur_right_roles;
                    my @diff = grep {!exists($view_roles->{$_})} keys %$edit_roles;

                    fail(
                        sprintf(
                            'Roles (%s) has right "%s" but has not right "%s"',
                            join(', ', @diff),
                            $right, $view_right
                        )
                    ) if @diff;
                }

            }
        }
    },
    dont_create_database => 1,
    do_not_die_on_fail   => 1,
);
