use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        my $all_roles = $app->rbac->get_roles();

        foreach my $role (@$all_roles) {
            ok(not($role->{is_internal} xor $role->{idm}), "check $role->{name}");
        }
    },
    dont_create_database => 1,
);
