use strict;
use warnings FATAL => 'all';

use Test::More;
use Test::Differences;
use qbit;
use lib::abs;

use RoleRights;

sub main_in_test {

    my $file_name = 'lib/role_rights.ssv';
    open(my $fh, '<', lib::abs::path("../../$file_name"));
    my $input = join '', grep {substr($_, 0, 1) ne '#'} <$fh>;
    close $fh;

    my $data  = RoleRights->new('production')->get_rights();
    my $width = 0;
    foreach my $right (keys %$data) {
        $data->{$right} = [sort {$a <=> $b} map {$_ + 0} keys %{$data->{$right}}];
        $width = length $right if length $right > $width;
    }

    my @strs = sort {$a cmp $b} map {sprintf "%*s%s", -($width + 5), $_, join(',', @{$data->{$_}})} keys %$data;
    my $output = join("\n", @strs) . "\n";

    eq_or_diff($input, $output, "File $file_name is pretty printed");

    done_testing();
}
main_in_test();
