use strict;
use warnings FATAL => 'all';

use Test::Partner2::Simple;
use Test::More;

use qbit;
use RoleRights;

run_tests(
    sub {
        my ($app) = @_;

        my %available_roles = map {$_->{id} => $_->{name}} @{$app->rbac->get_roles()};

        my $data = RoleRights->new('production')->get_rights();
        foreach my $right (sort keys %$data) {
            my @roles = keys %{$data->{$right}};
            my @existing_roles = grep {exists($available_roles{$_})} @roles;

            ok(scalar(@roles) == scalar(@existing_roles), $right);
        }
    },
    dont_create_database => 1,
);
