#!/usr/bin/perl

use qbit;
use Test::More;
use Test::Partner2::Simple;

require Application::Model::Statistics::Update;

pass('Loaded ok');

# Ключ — дата сегодня
# Значение — хеш
#   ключ - номер для по который включительно нужно перезабирать статистику
#          за прошлый месяц.
#   значение - дата с которой мы должны забирать статистику из баланса
my %data = (

    '2013-01-01' => {

        # В случае 0, в новом месяце не забираем статитстику за старый
        0 => '2013-01-01',
        3 => '2012-12-01',
        5 => '2012-12-01',
    },
    '2013-01-02' => {
        0 => '2013-01-01',
        3 => '2012-12-01',
        5 => '2012-12-01',
    },
    '2013-01-03' => {
        0 => '2013-01-01',
        3 => '2012-12-01',
        5 => '2012-12-01',
    },
    '2013-01-04' => {
        0 => '2013-01-01',

        # В случае 3, день 3 — это последний день, когда забираем статистику
        # за прошлый месяц
        3 => '2013-01-01',
        5 => '2012-12-01',
    },
    '2013-01-05' => {
        0 => '2013-01-01',
        3 => '2013-01-01',
        5 => '2012-12-01',
    },
    '2013-01-06' => {
        0 => '2013-01-01',
        3 => '2013-01-01',

        # В случае 5, день 5 — это последний день, когда забираем статистику
        # за прошлый месяц
        5 => '2013-01-01',
    },
    '2013-01-07' => {
        0 => '2013-01-01',
        3 => '2013-01-01',
        5 => '2013-01-01',
    },

);

foreach my $date (sort keys %data) {
    foreach my $day (sort keys %{$data{$date}}) {

        my $expected_date = $data{$date}->{$day};

        is(
            Application::Model::Statistics::Update::__get_month_update_date(undef, $date, $day),
            $expected_date, "Got correct start date for date '$date' and day '$day'",
          );

    }
}

done_testing();
