use Test::More;
use Test::Most;

no warnings 'redefine';
no strict 'refs';

use lib::abs qw(
  ../lib
  ./lib
  );
use Application::Model::AgreementChecker::_Agreement;
use Test::Partner::Utils;

use qbit;

sub contract_type_5 {
    my $today = '2014-01-16';
    my $msg   = "univerasl contract 5 Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt            => '2000-01-01',
            is_signed     => '2000-01-01',
            end_dt        => '2014-01-16',
            contract_type => 5,
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->can_run(product => 'context_on_site_rtb', day => 'today'), "can_run today == true. $msg");
    ok(!$ref->can_run(product => 'context_on_site_rtb', day => 'tomorrow'), "can_run tomorrow == false. $msg");
}

sub contract_type_84 {
    my $today = '2014-01-16';
    my $msg   = "unknown contract 84 Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt            => '2000-01-01',
            is_signed     => '2000-01-01',
            contract_type => 84,
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    eval {$ref->can_run(product => 'context_on_site_direct', day => 'today')};
    is(ref($@), 'Exception', 'Exception is throwed.');
    is(
        ref($@) ? $@->message() : $@,
        sprintf('Unknown contract_type "%s" (id: "%s", external_id: "%s")', 84, '', ''),
        'Exception message is correct.'
      );
}

sub main_in_test {

    die_on_fail();

    pass('Loaded ok');

    contract_type_5();
    contract_type_84();

    done_testing();

}
main_in_test;
