use Test::More;
use Test::Most;

no warnings 'redefine';
no strict 'refs';

use lib::abs qw(
  ../lib
  ./lib
  );
use Application::Model::AgreementChecker::_Agreement;
use Test::Partner::Utils;

sub contract_is_cancelled {
    my $today = '2014-01-16';
    my $msg   = "is_cancelled Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt           => '2000-01-01',
            is_signed    => '2000-01-01',
            is_cancelled => "2014-01-17"
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),     "is_live_today() == true. $msg");
    ok(!$ref->is_live_tomorrow(), "is_live_tomorrow() == false. $msg");
}

sub contract_end_dt {
    my $today = '2014-01-16';
    my $msg   = "end_dt Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt        => '2000-01-01',
            is_signed => '2000-01-01',
            end_dt    => "2014-01-16"
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),     "is_live_today() == true. $msg");
    ok(!$ref->is_live_tomorrow(), "is_live_tomorrow() == false. $msg");
}

sub contract_is_in_future {
    my $today = '2014-01-16';
    my $msg   = "starts '2014-01-17' Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt        => '2014-01-17',
            is_signed => '2000-01-01',
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok(!$ref->is_live_today(),   "is_live_today() == false. $msg");
    ok($ref->is_live_tomorrow(), "is_live_tomorrow() == true. $msg");
}

sub collateral_closed_2090 {
    my $today = '2014-01-16';
    my $msg   = "collateral_closed_2090 Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt        => '2000-01-01',
            is_signed => '2000-01-01',
        },
        collaterals => [
            {
                collateral_type_id => 2090,
                end_dt             => '2014-01-16',
            }
        ],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),     "is_live_today() == true. $msg");
    ok(!$ref->is_live_tomorrow(), "is_live_tomorrow() == false. $msg");
}

sub contract_is_not_signed_and_is_not_faxed {
    my $today = '2014-01-16';
    my $msg   = "not signed and not faxed Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract    => {dt => '2000-01-01', contract_type => 9, test_mode => 0,},
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok(!$ref->is_live_today(),    "is_live_today() == false. $msg");
    ok(!$ref->is_live_tomorrow(), "is_live_tomorrow() == false. $msg");
}

sub contract_is_oferta2_test_mode {
    my $today = '2014-01-16';
    my $msg   = "is oferta2 and test mode Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract    => {dt => '2000-01-01', contract_type => 9, test_mode => 1,},
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),    "is_live_today() == true. $msg");
    ok($ref->is_live_tomorrow(), "is_live_tomorrow() == true. $msg");
}

sub contract_allows_to_fill_part2 {
    my $today = '2014-01-16';
    my $msg   = "allows to fill part2 Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract    => {dt => '2000-01-01', contract_type => 9, test_mode => 1, person_id => ''},
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->allows_to_fill_part2(), "allows_to_fill_part2() == true. $msg");
}

sub contract_not_allows_to_fill_part2 {
    my $today = '2014-01-16';

    mock_curdate("$today 00:00:00");

    my $msg = "not allows to fill part2 with person_id Today: $today";
    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract    => {dt => '2000-01-01', contract_type => 9, test_mode => 1, person_id => 12345},
        collaterals => [],
    );
    ok(!$ref->allows_to_fill_part2(), "allows_to_fill_part2() == false. $msg");

    $msg = "not allows to fill part2 without test_mode Today: $today";
    $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract    => {dt => '2000-01-01', contract_type => 9, test_mode => 0, person_id => 12345},
        collaterals => [],
    );
    ok(!$ref->allows_to_fill_part2(), "allows_to_fill_part2() == false. $msg");
}

sub contract_is_signed {
    my $today = '2014-01-16';
    my $msg   = "is_singed Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt        => '2000-01-01',
            is_signed => '2014-01-10',
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),    "is_live_today() == true. $msg");
    ok($ref->is_live_tomorrow(), "is_live_tomorrow() == true. $msg");
}

sub contract_is_faxed {
    my $today = '2014-01-16';
    my $msg   = "is_faxed Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt       => '2000-01-01',
            is_faxed => '2014-01-17',
        },
        collaterals => [],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),    "is_live_today() == true. $msg");
    ok($ref->is_live_tomorrow(), "is_live_tomorrow() == true. $msg");
}

sub collateral_cancellation_2050 {
    my $today = '2014-01-16';
    my $msg   = "collateral_cancellation_2050 Today: $today";

    my $ref = Application::Model::AgreementChecker::_Agreement->new(
        contract => {
            dt        => '2000-01-01',
            is_signed => '2000-01-01',
        },
        collaterals => [
            {
                collateral_type_id => 2050,
                end_dt             => '2014-01-16',
                is_faxed           => '2014-01-16',
            },
        ],
    );

    mock_curdate("$today 00:00:00");

    ok($ref->is_live_today(),     "is_live_today() == true. $msg");
    ok(!$ref->is_live_tomorrow(), "is_live_tomorrow() == false. $msg");
}

sub main_in_test {

    die_on_fail();

    pass('Loaded ok');

    contract_is_cancelled();
    contract_end_dt();
    contract_is_in_future();
    contract_is_not_signed_and_is_not_faxed();
    contract_is_oferta2_test_mode();
    contract_allows_to_fill_part2();
    contract_not_allows_to_fill_part2();
    contract_is_signed();
    contract_is_faxed();
    collateral_closed_2090();
    collateral_cancellation_2050();

    done_testing();

}
main_in_test;
