#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ../lib
  ../t_lib
  );
use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        no warnings 'redefine';
        no strict 'refs';

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(200);
            $r->request(HTTP::Request->new());
            $r->content('{"id":1,"login":"good","name":"Ya","password":null,"passportId":1234}');

            return $r;
        };

        cmp_deeply(
            $app->api_http_banner_storage->partner_customers(
                login    => 'good',
                password => 'good_pass',
                name     => 'Ya',
                user_id  => 1234
            ),
            {id => 1, login => 'good', name => 'Ya', password => undef, passportId => 1234},
            'create customers'
        );

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(400);
            $r->request(HTTP::Request->new());
            $r->content(
'{"message":"The request is invalid.","validationErrors":["Customer with specified login already exists"]}'
            );

            return $r;
        };

        eval {
            $app->api_http_banner_storage->partner_customers(
                login    => 'good',
                password => 'good_pass',
                name     => 'Ya',
                user_id  => 1234
            );
        };

        is(ref($@), 'Exception::BannerStorage::HTTP', 'Exception throw');
        is(
            $@->message,
            'The request is invalid. Customer with specified login already exists',
            'Exception text correct'
          );

        *{'LWP::UserAgent::request'} = sub {
            my $r = HTTP::Response->new(400);
            $r->request(HTTP::Request->new());
            $r->content('{"message":"The request is invalid.","validationErrors":["customer.Name"]}');

            return $r;
        };

        eval {
            $app->api_http_banner_storage->partner_customers(
                login    => 'good',
                password => 'good_pass',
                name     => 'Ya&',
                user_id  => 1234
            );
        };

        is(ref($@),     'Exception::BannerStorage::HTTP',        'Exception throw');
        is($@->message, 'The request is invalid. customer.Name', 'Exception text correct');
    },
);
