#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ./lib
  ../lib
  ../t_lib
  );
use Test::Partner2::Simple;

use Test::Most;
use Test::More;
use Test::Deep;
use Test::Differences;
use Test::MockObject::Extends;
use Test::Partner::Utils qw(
  get_new_dsp
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        $app->{'api_http_bk'} = Test::MockObject::Extends->new($app->{'api_http_bk'});

        my $id = $app->dsp->add(get_new_dsp());

        #DSP manager
        $app->set_cur_user({id => 1014});

        my $dsp = $app->dsp->get($id, fields => [qw(short_caption url test_url unmoderated_rtb_auction)]);
        $dsp->{'tag'} = 'test_tag';

        $app->dsp->do_action($id, 'approve', %{$dsp});

        $app->api_http_bk->mock(
            call => sub {
                my ($api_http_bk, $url, %opts) = @_;

                cmp_deeply(
                    \%opts,
                    {
                        'dsp_type'                => 5,
                        'disabled'                => 1,
                        'dsp_id'                  => '2563270',
                        'dsp_tag'                 => 'test_tag',
                        'use-pnocsy'              => 1,
                        'url'                     => 'http://dsp.com/',
                        'postmoderated'           => 0,
                        'unmoderated-rtb-auction' => 0,
                        'func'                    => 'add_dsp',
                        'caption'                 => 'Test DSP',
                        'keep_response'           => 1,
                        'testurl'                 => '',
                    },
                );

                return '{"code":0,"data_key":"DataKey"}';
            },
        );

        $app->api_http_bk->mock(
            dsp_lb => sub {
                my ($self, $opts) = @_;

                cmp_deeply(
                    $opts,
                    {
                        'display_name'            => 'Test DSP',
                        'patch'                   => undef,
                        'dsp_types'               => [0, 2],
                        'formats'                 => [],
                        'disabled'                => 1,
                        'id'                      => '2563270',
                        'tag'                     => 'test_tag',
                        'use_pnocsy'              => 1,
                        'url'                     => 'http://dsp.com/',
                        'postmoderated'           => 0,
                        'unmoderated_rtb_auction' => 0,
                        'short_caption'           => 'Test DSP',
                        'show_probability'        => 100,
                        'skipnoud'                => 0,
                        'is_ssp_allowed'          => 0,
                        'works_on_all_platforms'  => 0,
                    },
                );

                return 1;
            },
        );

        my $tmp_rights = $app->add_tmp_rights('do_dsp_action_create_in_bk');
        $app->dsp->do_action($id, 'create_in_bk');
        undef($tmp_rights);

        $app->api_http_bk->mock(
            'call',
            sub {
                my ($api_http_bk, $url, %opts) = @_;

                cmp_deeply(
                    \%opts,
                    {
                        caption       => "Real web",
                        dsp_id        => 2563270,
                        func          => "edit_dsp",
                        keep_response => 1,
                    }
                );

                return '{"code":0,"data_key":"DataKey"}';
            }
        );

        $app->api_http_bk->mock(
            dsp_lb => sub {
                my ($self, $opts) = @_;

                cmp_deeply(
                    $opts,
                    {
                        'display_name'            => undef,
                        'patch'                   => undef,
                        'dsp_types'               => [0, 2],
                        'formats'                 => [],
                        'disabled'                => 1,
                        'id'                      => '2563270',
                        'tag'                     => 'test_tag',
                        'use_pnocsy'              => 1,
                        'url'                     => 'http://dsp.com/',
                        'postmoderated'           => 0,
                        'unmoderated_rtb_auction' => 0,
                        'short_caption'           => 'Real web',
                        'show_probability'        => 100,
                        'skipnoud'                => 0,
                        'display_name'            => 'RealWeb DSP',
                        'is_ssp_allowed'          => 0,
                        'works_on_all_platforms'  => 0,
                    },
                );

                return 1;
            },
        );

        $app->dsp->do_action($id, 'edit', short_caption => 'Real web', 'display_name' => 'RealWeb DSP');

        cmp_deeply(
            $app->dsp->get($id, fields => [keys(%{$app->dsp->get_model_fields})]),
            {
                'types'   => ['0', '2'],
                'actions' => {
                    'test'   => re(qr(\w)),
                    'delete' => re(qr(\w)),
                    'edit'   => re(qr(\w)),
                },
                'public_id'        => '2563270',
                'type_captions'    => ignore(),
                'format_captions'  => ignore(),
                'is_deleted'       => '',
                'available_fields' => {
                    'test_url'                              => 1,
                    'types'                                 => 1,
                    'actions'                               => 1,
                    'public_id'                             => 1,
                    'url'                                   => 1,
                    'type_captions'                         => 1,
                    'skipnoud'                              => 1,
                    'available_fields'                      => 1,
                    'is_deleted'                            => 1,
                    'postmoderated'                         => 1,
                    'unmoderated_rtb_auction'               => 1,
                    'id'                                    => 1,
                    'tag'                                   => 1,
                    'login'                                 => 1,
                    'editable_fields'                       => 1,
                    'is_created_in_bk'                      => 1,
                    'is_dsp_statistics_responses_available' => 1,
                    'is_ssp_allowed'                        => 1,
                    'multistate_name'                       => 1,
                    'multistate'                            => 1,
                    'show_probability'                      => 1,
                    'data_key'                              => 1,
                    'owner_id'                              => 1,
                    'short_caption'                         => 1,
                    'display_name'                          => 1,
                    'patch'                                 => 1,
                    'format_captions'                       => 1,
                    'formats'                               => 1,
                    'fields_depends'                        => 1,
                    'works_on_all_platforms'                => 1,
                },
                'url'                     => 'http://dsp.com/',
                'postmoderated'           => '0',
                'unmoderated_rtb_auction' => '0',
                'skipnoud'                => '0',
                'tag'                     => 'test_tag',
                'id'                      => '2563270',
                'login'                   => 'mocked-dsp-partner',
                'editable_fields'         => {
                    'test_url'                => 1,
                    'data_key'                => 1,
                    'is_ssp_allowed'          => 1,
                    'show_probability'        => 1,
                    'url'                     => 1,
                    'skipnoud'                => 1,
                    'postmoderated'           => 1,
                    'unmoderated_rtb_auction' => 1,
                    'short_caption'           => 1,
                    'display_name'            => 1,
                    'patch'                   => 1,
                    'tag'                     => 1,
                },
                'fields_depends' => {
                    'depends' => {
                        'formats' => ['format_captions'],
                        'types'   => ['type_captions'],
                    }
                },
                'is_created_in_bk'                      => 1,
                'is_dsp_statistics_responses_available' => 1,
                'is_ssp_allowed'                        => 0,
                'multistate_name'                       => ignore(),
                'multistate'                            => '35',
                'show_probability'                      => '100',
                'data_key'                              => 'DataKey',
                'owner_id'                              => '1012',
                'short_caption'                         => 'Real web',
                'display_name'                          => 'RealWeb DSP',
                'patch'                                 => undef,
                'formats'                               => [],
                'test_url'                              => '',
                'works_on_all_platforms'                => '',
            },
            'Edit dsp'
        );

        cmp_deeply(
            $app->context_on_site_adblock->get_available_dsps({show_video => 0}),
            [
                {
                    'id'            => '2563180',
                    'short_caption' => 'AWAPSVideoAuctionInBanner',
                    'types'         => [0, 1],
                    'formats'       => [],
                },
                {
                    'id'            => '2563201',
                    'short_caption' => 'AWAPSVideoInBanner',
                    'types'         => [0, 1],
                    'formats'       => [],
                },
                {
                    'id'            => '1',
                    'short_caption' => 'Директ',
                    'types'         => [0, 1, 2],
                    'formats' => [1, 2],
                },
            ],
            'get_available_dsps'
        );
    },
    user => 'mocked-dsp-partner',
    init => [qw(api_http_bk)],
);

sub mock_app {
    my ($app) = @_;

    $app->mailer;
    $app->{'mailer'} = Test::MockObject::Extends->new($app->{'mailer'});
    $app->mailer->mock('send', sub {1});

}
