#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use Test::MockObject::Extends;
use Test::Partner2::Simple;
use Test::Partner::Utils qw(
  get_new_mobile_rtb
  );

use Test::Most;
use Test::More;
use Test::Deep;

use qbit;

my $APP_SET_ID = 1;
my $PAGE_ID    = 43569;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        my $public_id = $app->mobile_app_rtb->add(get_new_mobile_rtb({'context_page_id' => $PAGE_ID,}));

        change_cur_user($app, 'mocked-yan-manager');

        cmp_deeply(
            $app->mobile_app_rtb->get($public_id, fields => ['public_id', 'dsps']),
            {
                'dsps'      => ['1'],
                'public_id' => $public_id,
            },
            'Add Mobile RTB by partner'
        );

        $public_id =
          $app->mobile_app_rtb->add(get_new_mobile_rtb({'context_page_id' => $PAGE_ID, show_video => 0, dsps => [1]}));

        cmp_deeply(
            $app->mobile_app_rtb->get($public_id, fields => ['public_id', 'dsps']),
            {
                'dsps'      => [1],
                'public_id' => $public_id,
            },
            'Add Mobile RTB by manager'
        );
    },
    user => 'mocked-mobile-app-partner',
);

sub mock_app {
    my ($app) = @_;

    $app->api_bk;
    $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});

    my $PAGE_ID = 0;
    $app->api_bk->mock('create_or_update_campaign', sub {++$PAGE_ID});

    $app->agreement_checker;
    $app->{'agreement_checker'} = Test::MockObject::Extends->new($app->{'agreement_checker'});

    $app->agreement_checker->mock('has_agreement_for_any_product_for_today', sub {TRUE});
}
