#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ./lib
  ../lib
  ../t_lib
  );

use Test::Partner::Utils;
use Test::MockObject::Extends;

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

use PiConstants qw($FIRM_ID_YANDEX_LTD $FIRM_ID_YANDEX_ADVERTISING);

my $user_login = 'mocked-yan-partner';

my $mock_get_partner_act_headers = [
    {
        'contract_id'          => '76070',
        'paid_status'          => '',
        'receive_status'       => 'N',
        'period_start_date'    => '20141101T00:00:00',
        'receive_sf_status'    => 'N',
        'period_end_date'      => '20150531T00:00:00',
        'send_status'          => 'Y',
        'receive_doc_status'   => 'N',
        'receive_schet_status' => 'Y',
        'seen_status'          => 'Y',
        'receive_akt_status'   => 'N',
        'id'                   => '260487',
        'send_original_status' => 'N',
        'doc_size'             => '41426'
    },
    {
        'contract_id'          => '76070',
        'paid_status'          => '20131028T00:00:00',
        'receive_status'       => 'Y',
        'period_start_date'    => '20130801T00:00:00',
        'receive_sf_status'    => 'Y',
        'period_end_date'      => '20130831T00:00:00',
        'send_status'          => 'Y',
        'receive_doc_status'   => 'Y',
        'receive_schet_status' => 'Y',
        'seen_status'          => 'Y',
        'receive_akt_status'   => 'Y',
        'id'                   => '136699',
        'send_original_status' => 'Y',
        'doc_size'             => '41081'
    },
    {
        'contract_id'          => '76070',
        'paid_status'          => '',
        'receive_status'       => 'Y',
        'period_start_date'    => '20140101T00:00:00',
        'receive_sf_status'    => 'N',
        'period_end_date'      => '20141031T00:00:00',
        'send_status'          => 'Y',
        'receive_doc_status'   => 'Y',
        'receive_schet_status' => 'Y',
        'seen_status'          => 'Y',
        'receive_akt_status'   => 'N',
        'id'                   => '206517',
        'send_original_status' => 'N',
        'doc_size'             => '41286'
    },
    {
        'contract_id'          => '76070',
        'paid_status'          => '20131112T00:00:00',
        'receive_status'       => 'Y',
        'period_start_date'    => '20131001T00:00:00',
        'receive_sf_status'    => 'Y',
        'period_end_date'      => '20131031T00:00:00',
        'send_status'          => 'Y',
        'receive_doc_status'   => 'Y',
        'receive_schet_status' => 'Y',
        'seen_status'          => 'Y',
        'receive_akt_status'   => 'Y',
        'id'                   => '144707',
        'send_original_status' => 'Y',
        'doc_size'             => '40972'
    },
    {
        'contract_id'          => '76070',
        'paid_status'          => '20181212T00:00:00',
        'receive_status'       => 'N',
        'period_start_date'    => '20181212T00:00:00',
        'receive_sf_status'    => 'N',
        'period_end_date'      => '20181212T00:00:00',
        'send_status'          => 'N',
        'receive_doc_status'   => 'N',
        'receive_schet_status' => 'N',
        'seen_status'          => 'N',
        'receive_akt_status'   => 'N',
        'id'                   => '2065230',
        'send_original_status' => 'N',
        'doc_size'             => '40723'
    }
];

my $mock_get_partner_act_contents = {
    'doc_body' => '<?xml version="1.0" encoding="UTF-8"?>
<?mso-application progid="Excel.Sheet"?>
<Workbook xmlns="urn:schemas-microsoft-com:office:spreadsheet" xmlns:html="http://www.w3.org/TR/REC-html40">
...
</Workbook>',
    'doc_format' => 'XML Excel'
};

my $mock_get_contracts = [
    {
        'Person' => {
            'tax_type'               => '',
            'fname'                  => "Test fname",
            'address_postcode'       => '',
            'person_account'         => '',
            'email'                  => 'buh@kinopoisk.ru;tt@kinopoisk.ru;svetlanakp@yandex-team.ru',
            'ben_account'            => '',
            'legaladdress'           => "Test legaladdress",
            'passport_code'          => '',
            'birthplace_region'      => '',
            'is_partner'             => '1',
            'region'                 => '213',
            'name'                   => "Test name",
            'kpp'                    => '770401001',
            'signer_person_gender'   => '',
            'ogrn'                   => '',
            'lname'                  => "Test lname",
            'live_signature'         => '0',
            'mname'                  => "Test manme",
            'postaddress_envelope'   => "Test postaddress_envelope",
            'passport_s'             => '',
            'kz_in'                  => '',
            'kladr_code'             => '770000000007095',
            'pfr'                    => '',
            'address_updated'        => '',
            'fax'                    => '',
            'birthday'               => '',
            'birthplace_country'     => '',
            'account'                => '40702810400001470267',
            'postaddress'            => '',
            'client_id'              => '467949',
            'revise_act_period_type' => '',
            'iban'                   => '',
            'birthplace_district'    => '',
            'legal_address_postcode' => '',
            'invalid_bankprops'      => '',
            'delivery_type'          => '2',
            'iik'                    => '',
            'street'                 => "Test street",
            'inn_doc_details'        => '',
            'rnn'                    => '',
            'passport_e'             => '',
            'longname'               => "Test longname",
            'delivery_city'          => '',
            'authority_doc_type'     => "Test authority_doc_type",
            'id'                     => '286426',
            'address'                => "Test address",
            'ben_bank'               => '',
            'passport_n'             => '',
            'authority_doc_details'  => '',
            'bik'                    => '044525700',
            'other'                  => '',
            'signer_position_name'   => "Test signer_position_name",
            'passport_d'             => '',
            'type'                   => 'ur',
            'signer_person_name'     => "Test signer_person_name",
            'dt'                     => '2014-06-02',
            'postsuffix'             => "Test postsuffix",
            'city'                   => "Test city",
            'us_state'               => '',
            'bank_type'              => '2',
            'representative'         => "Test representative",
            'postcode'               => '119021',
            'swift'                  => '',
            'invalid_address'        => '0',
            'memo'                   => '',
            'phone'                  => "+7 (495) 739-70-39",
            'yamoney_wallet'         => '',
            'inn'                    => '7710688352',
            'vat_payer'              => '',
            'hidden'                 => '0'
        },
        'Client' => {
            'overdraft_limit'        => '0',
            'reliable_cc_payer'      => '',
            'client_type_id'         => '2',
            'email'                  => 'tvs@kinopoisk.ru',
            'deny_cc'                => '',
            'region_id'              => '225',
            'url'                    => 'info@kinopoisk.ru',
            'full_repayment'         => '1',
            'id'                     => '467949',
            'aux_is_docs_separated'  => '0',
            'manual_discount'        => '0',
            'name'                   => "Test name",
            'direct25'               => '0',
            'manual_suspect'         => '0',
            'manual_suspect_comment' => '',
            'partner_type'           => '1',
            'dt'                     => '2010-04-20',
            'agency_id'              => '',
            'is_non_resident'        => '0',
            'domain_check_status'    => '0',
            'budget'                 => '0',
            'city'                   => '',
            'is_agency'              => '0',
            'fax'                    => '',
            'overdraft_ban'          => '0',
            'internal'               => '0',
            'suspect'                => '0',
            'creation_dt'            => '2007-06-07',
            'phone'                  => '+7 495 926 8321',
            'aux_is_docs_detailed'   => '0',
            'currency_payment'       => '',
            'domain_check_comment'   => '',
            'fullname'               => '',
            'class_id'               => '467949',
            'is_wholesaler'          => ''
        },
        'Collaterals' => [
            {
                'partner_pct'        => '60',
                'is_faxed'           => '',
                'num'                => '01',
                'dt'                 => '2014-01-01',
                'is_cancelled'       => '',
                'contract2_id'       => '76070',
                'create_dt'          => '2014-01-01',
                'collateral_type_id' => '2020',
                'id'                 => '105469',
                'pi_info'            => {
                    'type_name' => "Test type_name",
                    'is_live'   => 1
                },
                'memo'      => "Test memo",
                'sent_dt'   => '',
                'update_dt' => '2015-04-02',
                'is_signed' => '2014-01-30',
                'class'     => 'COLLATERAL',
                'is_booked' => '0'
            },
            {
                'pi_info' => {
                    'type_name' => "Test type_name",
                    'is_live'   => 1
                },
                'is_faxed'     => '',
                'num'          => '02',
                'dt'           => '2014-10-23',
                'is_cancelled' => '',
                'memo'         => "Test memo",
                'sent_dt'      => '',
                'update_dt'    => '2015-04-02',
                'is_signed'    => '2014-01-30',
                'class'        => 'COLLATERAL',
                'is_booked'    => '0'
            },
            {
                'pi_info' => {
                    'type_name' => "Test type_name",
                    'is_live'   => 1
                },
                'is_faxed'           => '',
                'num'                => '02',
                'dt'                 => '2014-10-23',
                'is_cancelled'       => '',
                'memo'               => "Test memo",
                'sent_dt'            => '2014-12-24',
                'contract2_id'       => '76070',
                'create_dt'          => '2014-10-23',
                'update_dt'          => '2015-04-02',
                'collateral_type_id' => '2040',
                'is_signed'          => '2014-12-24',
                'id'                 => '133069',
                'class'              => 'COLLATERAL',
                'is_booked'          => '0'
            },
            {
                'partner_pct'        => '43',
                'is_faxed'           => '',
                'num'                => "Test num",
                'dt'                 => '2015-01-01',
                'is_cancelled'       => '',
                'contract2_id'       => '76070',
                'create_dt'          => '2015-01-01',
                'collateral_type_id' => '2020',
                'id'                 => '140736',
                'pi_info'            => {
                    'type_name' => "Test type_name",
                    'is_live'   => 1
                },
                'memo'      => "Test memo",
                'sent_dt'   => '',
                'update_dt' => '2015-04-02',
                'is_signed' => '2015-01-15',
                'class'     => 'COLLATERAL',
                'is_booked' => '0'
            }
        ],
        'Contract' => {
            'is_faxed'            => '2013-04-30',
            'atypical_conditions' => '1',
            'manager_code'        => '20468',
            'pay_to'              => '1',
            'payment_type'        => '1',
            'open_date'           => '0',
            'collateral_type_id'  => '',
            'unilateral_acts'     => '0',
            'id'                  => '89970',
            'pi_info'             => {
                'contract_type_name' => "Test contract_type_name",
                'type_name'          => "Test type_name",
                'is_live'            => 1
            },
            'doc_set'        => '',
            'person_id'      => '286426',
            'agregator_pct'  => undef,
            'sent_dt'        => '2013-05-23',
            'external_id'    => "ext-16099-02/13",
            'market_api_pct' => '50',
            'type'           => 'PARTNERS',
            'partner_pct'    => '43',
            'num'            => '',
            'search_forms'   => '1',
            'is_cancelled'   => '',
            'dt'             => '2013-06-01',
            'currency'       => '643',
            'contract2_id'   => '76070',
            'create_dt'      => '2013-06-01',
            'contract_type'  => '5',
            'firm'           => '1',
            'client_id'      => '467949',
            'memo'           => "Test memo",
            'update_dt'      => '2015-04-02',
            'is_signed'      => '2013-05-16',
            'end_dt'         => '',
        }
    }
];

run_tests(
    sub {
        my ($app) = @_;

        mock_api($app);

        mock_curdate('2015-11-18 00:00:00');

        my $get_all_with_meta = {
            data => [
                {
                    'multistate_name'      => "Invoice for payment — got the original\nAct — send the original",
                    'contract_id'          => '76070',
                    'receive_status'       => 'N',
                    'receive_sf_status'    => 'N',
                    'receive_doc_status'   => 'N',
                    'seen_status'          => 'Y',
                    'send_original_status' => 'N',
                    'id'                   => '260487',
                    'paid_status'          => '',
                    'period_start_date'    => '20141101T00:00:00',
                    'period_end_date'      => '20150531T00:00:00',
                    'send_status'          => 'Y',
                    'external_id'          => 'ext-16099-02/13',
                    'receive_schet_status' => 'Y',
                    'receive_akt_status'   => 'N',
                    'doc_size'             => '41426'
                },
                {
                    'multistate_name' =>
                      "Invoice for payment — got the original\nAct — got a copy, send the original",
                    'contract_id'          => '76070',
                    'receive_status'       => 'Y',
                    'receive_sf_status'    => 'N',
                    'receive_doc_status'   => 'Y',
                    'seen_status'          => 'Y',
                    'send_original_status' => 'N',
                    'id'                   => '206517',
                    'paid_status'          => '',
                    'period_start_date'    => '20140101T00:00:00',
                    'period_end_date'      => '20141031T00:00:00',
                    'send_status'          => 'Y',
                    'external_id'          => 'ext-16099-02/13',
                    'receive_schet_status' => 'Y',
                    'receive_akt_status'   => 'N',
                    'doc_size'             => '41286'
                },
                {
                    'multistate_name'      => 'Got the original, originals sent',
                    'contract_id'          => '76070',
                    'receive_status'       => 'Y',
                    'receive_sf_status'    => 'Y',
                    'receive_doc_status'   => 'Y',
                    'seen_status'          => 'Y',
                    'send_original_status' => 'Y',
                    'id'                   => '144707',
                    'paid_status'          => '20131112T00:00:00',
                    'period_start_date'    => '20131001T00:00:00',
                    'period_end_date'      => '20131031T00:00:00',
                    'send_status'          => 'Y',
                    'external_id'          => 'ext-16099-02/13',
                    'receive_schet_status' => 'Y',
                    'receive_akt_status'   => 'Y',
                    'doc_size'             => '40972'
                },
                {
                    'multistate_name'      => 'Got the original, originals sent',
                    'contract_id'          => '76070',
                    'receive_status'       => 'Y',
                    'receive_sf_status'    => 'Y',
                    'receive_doc_status'   => 'Y',
                    'seen_status'          => 'Y',
                    'send_original_status' => 'Y',
                    'id'                   => '136699',
                    'paid_status'          => '20131028T00:00:00',
                    'period_start_date'    => '20130801T00:00:00',
                    'period_end_date'      => '20130831T00:00:00',
                    'send_status'          => 'Y',
                    'external_id'          => 'ext-16099-02/13',
                    'receive_schet_status' => 'Y',
                    'receive_akt_status'   => 'Y',
                    'doc_size'             => '41081'
                },
            ],
            meta => {found_rows => 4},
        };

        cmp_deeply(
            $app->partner_acts->get_db_filter_fields(),
            {login => {label => re(qr(\w)), type => 'client_id_by_login'},},
            'get_db_filter_fields'
        );

        cmp_deeply($app->partner_acts->get_db_filter_simple_fields(), [], 'get_db_filter_simple_fields');

        cmp_deeply($app->partner_acts->get_all_with_meta(), $get_all_with_meta, 'get_all_with_meta not self-employed');

        $mock_get_contracts->[0]{Contract}{nds}  = 0;
        $mock_get_contracts->[0]{Contract}{firm} = $FIRM_ID_YANDEX_ADVERTISING;
        cmp_deeply($app->partner_acts->get_all_with_meta(),
            $get_all_with_meta, 'get_all_with_meta not self-employed nds_0 with ya.adv contract');

        $mock_get_contracts->[0]{Contract}{firm} = $FIRM_ID_YANDEX_LTD;
        foreach my $document (@{$get_all_with_meta->{data}}) {
            $document->{multistate_name} = 'Documents provided';
        }
        cmp_deeply($app->partner_acts->get_all_with_meta(),
            $get_all_with_meta, 'get_all_with_meta not self-employed usn');

        cmp_deeply(
            $app->partner_acts->get_content(act_id => 144707),
            $mock_get_partner_act_contents,
            'get_partner_act_content'
        );

        $app->set_cur_user({id => 1010});
        cmp_deeply(
            $app->partner_acts->get_all_with_meta(),
            {
                data => [
                    {
                        period_start_date => '2020-09-20T11:00:00',
                        period_end_date   => '2020-09-20T11:00:00',
                        external_id       => '',
                        multistate_name   => 'Got receipt # id123: Наименование услуги',
                        link              => 'fns.ru/check/123',
                    },
                    {
                        period_start_date => '2020-09-20T11:00:00',
                        period_end_date   => '2020-09-20T11:00:00',
                        external_id       => '',
                        multistate_name   => 'Cancelled receipt # id125: Наименование услуги',
                        link              => 'fns.ru/check/125',
                    },
                    @{$get_all_with_meta->{data}}
                ],
                meta => {found_rows => $get_all_with_meta->{meta}{found_rows} + 2},
            },
            'get_all_with_meta self-employed'
        );

        $app->set_cur_user({id => 1015});

        cmp_deeply(
            $app->partner_acts->get_db_filter_simple_fields(),
            [{name => 'login', label => re(qr(\w)), login_filter => 'partner=1'}],
            'get_db_filter_simple_fields for manager'
        );

        cmp_deeply($app->partner_acts->get_all_with_meta(filter => ['AND', [['login' => '=' => $user_login]]]),
            $get_all_with_meta, 'get_all_with_meta for manager');

        cmp_deeply(
            $app->partner_acts->get_content(act_id => 144707, login => $user_login),
            $mock_get_partner_act_contents,
            'get_partner_act_content for manager'
        );
    },
    user => $user_login
);

sub mock_api {
    my ($app) = @_;

    $app->documents;
    $app->{'documents'} = Test::MockObject::Extends->new($app->{'documents'});

    $app->documents->mock('get_contracts', sub {$mock_get_contracts});

    $app->api_oebs;
    $app->{'api_oebs'} = Test::MockObject::Extends->new($app->{'api_oebs'});

    $app->api_oebs->mock('get_partner_act_headers',  sub {$mock_get_partner_act_headers});
    $app->api_oebs->mock('get_partner_act_contents', sub {$mock_get_partner_act_contents});

    $app->api_selfemployed_oebs;
    $app->{'api_selfemployed_oebs'} = Test::MockObject::Extends->new($app->{'api_selfemployed_oebs'});

    $app->api_selfemployed_oebs->mock(
        'get_receipts',
        sub {
            {
                "receipts" => [
                    {
                        "link"            => "fns.ru/check/123",
                        "totalAmount"     => 10,
                        "receiptId"       => "id123",
                        "requestTime"     => "2020-09-20T11:00:00",
                        "operationTime"   => "2020-09-20T09:00:00",
                        "partnerCode"     => "1b74e779-6c8a-49a5-a1e2-d946af3b9e02",
                        "cancelationTime" => "",
                        "services"        => [
                            {
                                "amount"   => 10,
                                "name"     => "Наименование услуги",
                                "quantity" => 1
                            }
                        ]
                    },
                    {
                        "link"            => "fns.ru/check/125",
                        "totalAmount"     => 20,
                        "receiptId"       => "id125",
                        "requestTime"     => "2020-09-20T11:00:00",
                        "operationTime"   => "2020-09-20T09:00:00",
                        "partnerCode"     => "1b74e779-6c8a-49a5-a1e2-d946af3b9e02",
                        "cancelationTime" => "2020-09-20T12:00:00",
                        "services"        => [
                            {
                                "amount"   => 10,
                                "name"     => "Наименование услуги",
                                "quantity" => 2
                            }
                        ]
                    },
                    {
                        "link"            => "fns.ru/check/124",
                        "totalAmount"     => 10,
                        "receiptId"       => "id124",
                        "requestTime"     => "2020-09-20T11:00:00",
                        "operationTime"   => "2020-09-20T09:00:00",
                        "partnerCode"     => "NOTBD",
                        "cancelationTime" => "",
                        "services"        => [
                            {
                                "amount"   => 10,
                                "name"     => "Наименование услуги",
                                "quantity" => 1
                            }
                        ]
                    }
                ]
            };
        }
    );
}
