#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ./lib
  ../lib
  ../t_lib
  );

use Test::Partner::Utils;
use Test::MockObject::Extends;

use Test::Partner2::Simple;

use Test::More;
use Test::Deep;

use qbit;

my $user_login = 'mocked-yan-partner';

my $mock_get_partner_documents = [
    {
        'contract_eid'      => "РС-42450-06/15",
        'is_orig_signed'    => 'N',
        'doc_dt'            => '20150601T00:00:00',
        'collateral_number' => '',
        'content_type'      => 'application/pdf',
        'is_orig_sent'      => '0',
        'file_name'         => "Договор № РС-42450-06-15..PDF",
        'type_id'           => '0',
        'id'                => '169114',
        'is_fax_signed'     => 'N',
        'doc_size'          => '86873'
    },
    {
        'contract_eid'      => "РСЯ-12252-12/12",
        'is_orig_signed'    => 'Y',
        'doc_dt'            => '20121221T00:00:00',
        'collateral_number' => '',
        'content_type'      => 'application/pdf',
        'is_orig_sent'      => '1',
        'file_name'         => "Договор № РСЯ-12252-12-12.pdf",
        'type_id'           => '0',
        'id'                => '85114',
        'is_fax_signed'     => 'N',
        'doc_size'          => '128055'
    },
    {
        'contract_eid'      => "РС-8811-12/11",
        'is_orig_signed'    => 'Y',
        'doc_dt'            => '20120122T00:00:00',
        'collateral_number' => '',
        'content_type'      => 'application/pdf',
        'is_orig_sent'      => '1',
        'file_name'         => "Договор № РС-8811-12-11.pdf",
        'type_id'           => '0',
        'id'                => '57810',
        'is_fax_signed'     => 'N',
        'doc_size'          => '120555'
    }
];

my $mock_get_partner_document_contents = {
    'doc_body' => '%PDF-1.4
5 0 obj
<<
/Type /Page
/Parent 3 0 R
/Resources 4 0 R
/Contents 6 0 R
/Annots [
22 0 R
23 0 R
24 0 R
25 0 R
]
/MediaBox[ 0 0 595.3 841.9 ]
/CropBox[ 0 0 595.3 841.9 ]
/Rotate 0
>>
...
%%EOF',
    'doc_format' => 'application/pdf',
    'file_name'  => "Договор № РС-42450-06-15..PDF",
};

run_tests(
    sub {
        my ($app) = @_;

        mock_api($app);

        mock_curdate('2015-11-18 00:00:00');

        my $get_all_with_meta = {
            data => my $data_get_partner_documents = [
                {
                    'is_orig_signed'    => 'N',
                    'contract_eid'      => "РС-42450-06/15",
                    'doc_dt'            => '20150601T00:00:00',
                    'collateral_number' => '',
                    'content_type'      => 'application/pdf',
                    'is_orig_sent'      => '0',
                    'file_name'         => "Договор № РС-42450-06-15..PDF",
                    'type_id'           => '0',
                    'is_fax_signed'     => 'N',
                    'id'                => '169114',
                    'doc_size'          => '86873'
                },
                {
                    'is_orig_signed'    => 'Y',
                    'contract_eid'      => "РСЯ-12252-12/12",
                    'doc_dt'            => '20121221T00:00:00',
                    'collateral_number' => '',
                    'content_type'      => 'application/pdf',
                    'is_orig_sent'      => '1',
                    'file_name'         => "Договор № РСЯ-12252-12-12.pdf",
                    'type_id'           => '0',
                    'is_fax_signed'     => 'N',
                    'id'                => '85114',
                    'doc_size'          => '128055'
                },
                {
                    'is_orig_signed'    => 'Y',
                    'contract_eid'      => "РС-8811-12/11",
                    'doc_dt'            => '20120122T00:00:00',
                    'collateral_number' => '',
                    'content_type'      => 'application/pdf',
                    'is_orig_sent'      => '1',
                    'file_name'         => "Договор № РС-8811-12-11.pdf",
                    'type_id'           => '0',
                    'is_fax_signed'     => 'N',
                    'id'                => '57810',
                    'doc_size'          => '120555'
                }
            ],
            meta => {found_rows => 3},
        };

        cmp_deeply(
            $app->partner_documents->get_db_filter_fields(),
            {login => {label => re(qr(\w)), type => 'client_id_by_login'},},
            'get_db_filter_fields'
        );

        cmp_deeply($app->partner_documents->get_db_filter_simple_fields(), [], 'get_db_filter_simple_fields');

        cmp_deeply($app->partner_documents->get_all_with_meta(), $get_all_with_meta, 'get_all_with_meta');

        cmp_deeply(
            $app->partner_documents->get_content(doc_id => 169114),
            $mock_get_partner_document_contents,
            'get_partner_document_content'
        );

        $app->set_cur_user({id => 1015});

        cmp_deeply(
            $app->partner_documents->get_db_filter_simple_fields(),
            [{name => 'login', label => re(qr(\w)), login_filter => 'partner=1'}],
            'get_db_filter_simple_fields for manager'
        );

        cmp_deeply($app->partner_documents->get_all_with_meta(filter => ['AND', [['login' => '=' => $user_login]]]),
            $get_all_with_meta, 'get_all_with_meta for manager');

        cmp_deeply(
            $app->partner_documents->get_content(doc_id => 169114, login => $user_login),
            $mock_get_partner_document_contents,
            'get_partner_document_content for manager'
        );
    },
    user => $user_login
);

sub mock_api {
    my ($app) = @_;

    $app->api_oebs;
    $app->{'api_oebs'} = Test::MockObject::Extends->new($app->{'api_oebs'});

    $app->api_oebs->mock('get_partner_documents',         sub {$mock_get_partner_documents});
    $app->api_oebs->mock('get_partner_document_contents', sub {$mock_get_partner_document_contents});
}
