#!/usr/bin/perl -w

use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ./lib
  ../lib
  ../t_lib
  );
use Test::Partner2::Simple;

use Test::Most;
use Test::More skip_all => 'Not applicable to new implementation';
use Test::Deep;
use Test::MockObject::Extends;
use Test::Partner::Utils qw(
  mock_curdate
  );

use qbit;

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        $app->partner_db->statistics_video_an_site_inpage_publisher->truncate();
        $app->partner_db->statistics_video_an_site_instream_publisher->truncate();

        cmp_deeply(
            $app->video_an_site_instream->get_all(fields => ['page_id', 'id']),
            [
                {
                    page_id => 128972,
                    id      => 1
                },
                {
                    page_id => 154689,
                    id      => 2
                }
            ],
            'Video block - ok'
        );

        cmp_deeply(
            $app->video_an_site_inpage->get_all(fields => ['page_id', 'id']),
            [
                {
                    page_id => 154689,
                    id      => 1
                },
                {
                    page_id => 128972,
                    id      => 2
                }
            ],
            'InPage block - ok'
        );

        $app->statistics_video_an_site_publisher->regular_update_statistics();

        cmp_deeply(
            $app->partner_db->statistics_video_an_site_instream_publisher->get_all(),
            [
                {
                    'bk_price_w_nds'          => '3540000000',
                    'video_bk_shows_own_adv'  => '0',
                    'content_id'              => '42607',
                    'video_bk_hits'           => '1',
                    'dt'                      => '2016-02-17',
                    'page_id'                 => '128972',
                    'block_id'                => '1',
                    'video_bk_hits_unsold'    => '0',
                    'bk_partner_price_wo_nds' => '1800000000',
                    'publisher_id'            => '',
                    'bk_partner_price_w_nds'  => '2124000000',
                    'video_bk_shows'          => '1',
                    'bk_price_wo_nds'         => '3000000000',
                    'currency_id'             => '2',
                    'dsp_id'                  => '2563070',
                    'video_bk_hits_own_adv'   => '0',
                    'publisher_name'          => '',
                    'video_bk_all_hits'       => '1',
                    'content_name'            => 'Test Content 1',
                    'clid'                    => '0',
                },
                {
                    'bk_price_w_nds'          => '3540000000',
                    'video_bk_shows_own_adv'  => '0',
                    'content_id'              => '431147',
                    'video_bk_hits'           => '1',
                    'dt'                      => '2016-02-17',
                    'page_id'                 => '128972',
                    'block_id'                => '1',
                    'video_bk_hits_unsold'    => '0',
                    'bk_partner_price_wo_nds' => '1800000000',
                    'publisher_id'            => '',
                    'bk_partner_price_w_nds'  => '2124000000',
                    'video_bk_shows'          => '1',
                    'bk_price_wo_nds'         => '3000000000',
                    'currency_id'             => '2',
                    'dsp_id'                  => '2563070',
                    'video_bk_hits_own_adv'   => '0',
                    'publisher_name'          => '',
                    'video_bk_all_hits'       => '1',
                    'content_name'            => 'Test Content 3',
                    'clid'                    => '2',
                }
            ],
            'statistics_video_an_site_instream_publisher - ok'
        );

        cmp_deeply(
            $app->partner_db->statistics_video_an_site_inpage_publisher->get_all(),
            [
                {
                    'bk_price_w_nds'          => '3540000000',
                    'video_bk_shows_own_adv'  => '0',
                    'content_id'              => '42607',
                    'video_bk_hits'           => '1',
                    'dt'                      => '2016-02-17',
                    'block_id'                => '2',
                    'video_bk_hits_unsold'    => '0',
                    'bk_partner_price_wo_nds' => '1800000000',
                    'publisher_id'            => '',
                    'bk_partner_price_w_nds'  => '2124000000',
                    'video_bk_shows'          => '1',
                    'bk_price_wo_nds'         => '3000000000',
                    'currency_id'             => '2',
                    'dsp_id'                  => '2563070',
                    'page_id'                 => '128972',
                    'video_bk_hits_own_adv'   => '0',
                    'publisher_name'          => '',
                    'video_bk_all_hits'       => '1',
                    'content_name'            => 'Test Content 1',
                    'clid'                    => '0',
                },
                {
                    'bk_price_w_nds'          => '0',
                    'video_bk_shows_own_adv'  => '0',
                    'content_id'              => '42610',
                    'video_bk_hits'           => '1',
                    'dt'                      => '2016-02-17',
                    'block_id'                => '1',
                    'video_bk_hits_unsold'    => '0',
                    'bk_partner_price_wo_nds' => '0',
                    'publisher_id'            => '',
                    'bk_partner_price_w_nds'  => '0',
                    'video_bk_shows'          => '0',
                    'bk_price_wo_nds'         => '0',
                    'currency_id'             => '2',
                    'dsp_id'                  => '2563070',
                    'page_id'                 => '154689',
                    'video_bk_hits_own_adv'   => '0',
                    'publisher_name'          => '',
                    'video_bk_all_hits'       => '1',
                    'content_name'            => 'Test Content 2',
                    'clid'                    => '1',
                },
                {
                    'bk_price_w_nds'          => '3540000000',
                    'video_bk_shows_own_adv'  => '0',
                    'content_id'              => '43139',
                    'video_bk_hits'           => '1',
                    'dt'                      => '2016-02-17',
                    'block_id'                => '1',
                    'video_bk_hits_unsold'    => '0',
                    'bk_partner_price_wo_nds' => '1800000000',
                    'publisher_id'            => '',
                    'bk_partner_price_w_nds'  => '2124000000',
                    'video_bk_shows'          => '1',
                    'bk_price_wo_nds'         => '3000000000',
                    'currency_id'             => '2',
                    'dsp_id'                  => '2563070',
                    'page_id'                 => '154689',
                    'video_bk_hits_own_adv'   => '0',
                    'publisher_name'          => '',
                    'video_bk_all_hits'       => '1',
                    'content_name'            => 'Test Content 4',
                    'clid'                    => '1',
                }
            ],
            'statistics_video_an_site_inpage_publisher - ok'
        );

        cmp_deeply(
            [$app->video_stat_files->get_data('yesterday')],
            [
                {
                    'video_content_name'      => 'Test Content 2',
                    'bk_partner_price_w_nds'  => 0,
                    'currency_id'             => '2',
                    'video_publisher_name'    => '',
                    'video_bk_shows'          => 0,
                    'page_id'                 => '154689',
                    'video_content_id'        => '42610',
                    'video_publisher_id'      => '',
                    'video_bk_all_hits'       => 1,
                    'bk_partner_price_wo_nds' => 0,
                    'video_clid'              => 1,
                },
                {
                    'video_content_name'      => 'Test Content 4',
                    'bk_partner_price_w_nds'  => 2124000000,
                    'currency_id'             => '2',
                    'video_publisher_name'    => '',
                    'video_bk_shows'          => 1,
                    'page_id'                 => '154689',
                    'video_content_id'        => '43139',
                    'video_publisher_id'      => '',
                    'video_bk_all_hits'       => 1,
                    'bk_partner_price_wo_nds' => 1800000000,
                    'video_clid'              => 1,
                },
                {
                    'video_content_name'      => 'Test Content 3',
                    'bk_partner_price_w_nds'  => 2124000000,
                    'currency_id'             => '2',
                    'video_publisher_name'    => '',
                    'video_bk_shows'          => 1,
                    'page_id'                 => '128972',
                    'video_content_id'        => '431147',
                    'video_publisher_id'      => '',
                    'video_bk_all_hits'       => 1,
                    'bk_partner_price_wo_nds' => 1800000000,
                    'video_clid'              => 2,
                },
                {
                    'video_content_name'      => 'Test Content 1',
                    'bk_partner_price_w_nds'  => 4248000000,
                    'currency_id'             => '2',
                    'video_publisher_name'    => '',
                    'video_bk_shows'          => 2,
                    'page_id'                 => '128972',
                    'video_content_id'        => '42607',
                    'video_publisher_id'      => '',
                    'video_bk_all_hits'       => 2,
                    'bk_partner_price_wo_nds' => 3600000000,
                    'video_clid'              => 0,
                },
            ],
            'get_data for yesterday'
        );

        $app->video_stat_files->generate_yesterday_xls();

        cmp_deeply(
            $app->video_stat_files->get_all(
                fields => [qw(id page_id type modification_date name)],
                filter => {type => 'yesterday'}
            ),
            [
                {
                    'modification_date' => '2016-02-18 18:28:12',
                    'name'              => 'Page ID 128972 (Statistics for 17.02.2016)',
                    'page_id'           => '128972',
                    'type'              => 'yesterday',
                    'id'                => '1'
                },
                {
                    'modification_date' => '2016-02-18 18:28:12',
                    'name'              => 'Page ID 154689 (Statistics for 17.02.2016)',
                    'page_id'           => '154689',
                    'type'              => 'yesterday',
                    'id'                => '2'
                }
            ],
            'xls for yesterday'
        );

        $app->video_stat_files->generate_month_xls();

        cmp_deeply(
            $app->video_stat_files->get_all(
                fields => [qw(id page_id type modification_date name)],
                filter => {type => 'this_month'}
            ),
            [
                {
                    'modification_date' => '2016-02-18 18:28:12',
                    'name'              => 'Page ID 128972 (Statistics for 01.02.2016 - 17.02.2016)',
                    'page_id'           => '128972',
                    'type'              => 'this_month',
                    'id'                => '3'
                },
                {
                    'modification_date' => '2016-02-18 18:28:12',
                    'name'              => 'Page ID 154689 (Statistics for 01.02.2016 - 17.02.2016)',
                    'page_id'           => '154689',
                    'type'              => 'this_month',
                    'id'                => '4'
                }
            ],
            'xls for this month'
        );

    },
);

sub mock_app {
    my ($app) = @_;

    mock_curdate('2016-02-18 18:28:12');

    $app->api_http_bk;
    $app->{'api_http_bk'} = Test::MockObject::Extends->new($app->{'api_http_bk'});
    $app->api_http_bk->mock(
        'get_publisher_stat',
        sub {
            [
                {
                    'PageID'        => '128972',
                    'DSPID'         => '2563070',
                    'ImpID'         => '1',
                    'Price'         => '300000',
                    'CategoryID'    => '-1',
                    'Shows'         => '1',
                    'Wins'          => '1',
                    'PublisherID'   => '',
                    'ContentID'     => '42607',
                    'PartnerPrice'  => '180000',
                    'ContentName'   => "Test Content 1",
                    'UpdateTime'    => '2016-02-17 00:00:00',
                    'Hits'          => '1',
                    'PublisherName' => '',
                    'CLID'          => '0',
                },
                {
                    'PageID'        => '128972',
                    'DSPID'         => '2563070',
                    'ImpID'         => '2',
                    'Price'         => '300000',
                    'CategoryID'    => '-1',
                    'Shows'         => '1',
                    'Wins'          => '1',
                    'PublisherID'   => '',
                    'ContentID'     => '42607',
                    'PartnerPrice'  => '180000',
                    'ContentName'   => "Test Content 1",
                    'UpdateTime'    => '2016-02-17 00:00:00',
                    'Hits'          => '1',
                    'PublisherName' => '',
                    'CLID'          => '0',
                },
                {
                    'PageID'        => '154689',
                    'DSPID'         => '2563070',
                    'ImpID'         => '1',
                    'Price'         => '0',
                    'CategoryID'    => '-1',
                    'Shows'         => '0',
                    'Wins'          => '1',
                    'PublisherID'   => '',
                    'ContentID'     => '42610',
                    'PartnerPrice'  => '0',
                    'ContentName'   => "Test Content 2",
                    'UpdateTime'    => '2016-02-17 00:00:00',
                    'Hits'          => '1',
                    'PublisherName' => '',
                    'CLID'          => '1',
                },
                {
                    'PageID'        => '128972',
                    'DSPID'         => '2563070',
                    'ImpID'         => '1',
                    'Price'         => '300000',
                    'CategoryID'    => '-1',
                    'Shows'         => '1',
                    'Wins'          => '1',
                    'PublisherID'   => '',
                    'ContentID'     => '431147',
                    'PartnerPrice'  => '180000',
                    'ContentName'   => "Test Content 3",
                    'UpdateTime'    => '2016-02-17 00:00:00',
                    'Hits'          => '1',
                    'PublisherName' => '',
                    'CLID'          => '2',
                },
                {
                    'PageID'        => '154689',
                    'DSPID'         => '2563070',
                    'ImpID'         => '1',
                    'Price'         => '300000',
                    'CategoryID'    => '-1',
                    'Shows'         => '1',
                    'Wins'          => '1',
                    'PublisherID'   => '',
                    'ContentID'     => '43139',
                    'PartnerPrice'  => '180000',
                    'ContentName'   => "Test Content 4",
                    'UpdateTime'    => '2016-02-17 00:00:00',
                    'Hits'          => '1',
                    'PublisherName' => '',
                    'CLID'          => '1',
                },
            ];
        }
    );
}
