use Test::More tests => 2;

use qbit;

use Application;

my $app = Application->new();

$app->set_option(
    mailer => {
        via      => 'testfile',
        testfile => './test_mail.txt',
    }
);

$app->pre_run();

{
    no warnings qw(redefine once);
    *Application::Model::Users::get = sub {{email => 'test@example.com', full_name => 'Vasily Pupkin'}};
}

is_deeply(
    $app->mailer->_message_struct_in(
        {from => 'name@example.com', to => {user_id => 123456}, subject => 'test', body => 'test'}, 'hash')->{'to'},
    [{name => 'Vasily Pupkin', email => 'test@example.com'}],
    'Check send by user_id'
);

is_deeply(
    $app->mailer->_message_struct_in({from => 'default', to => 'name@example.com', subject => 'test', body => 'test'},
        'hash')->{'from'},
    [{email => 'support@partner.yandex.ru', name => gettext('Yandex partner interface')}],
    'Check default sender'
);

END {
    unlink('./test_mail.txt') if -e './test_mail.txt';
    $app->post_run();
}
