use strict;
use warnings FATAL => 'all';

use lib::abs qw(
  ../lib
  ../t_lib
  ./lib
  );
use Test::Partner2::Simple;

use Test::More;
use Test::Deep;
use Test::MockObject::Extends;
use Test::Partner::Utils
  qw(get_new_ssp_link_mobile_app get_new_ssp_mobile_app_settings get_new_ssp_application mock_curdate);
use qbit;
use Test::Partner2::Mock;

my $PAGE_ID   = 1000;
my $mock_date = '2016-07-15 18:10:15';

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);
        mock_balance($app);

        $app->add_all_tmp_rights();

        my $ssp_app = $app->partner_db->ssp_application->add(get_new_ssp_application());

        my $m_link = $app->ssp_link_mobile_app->_create_from_impression(get_new_ssp_link_mobile_app());
        my $m_app  = $app->ssp_mobile_app_settings->add(get_new_ssp_mobile_app_settings(),);
        $app->filters->replace($PAGE_ID, [21], 'add');
        # $m_link->{mobile_app_id} = $m_app;
        $app->partner_db->ssp_link_mobile_app->edit($m_link, {mobile_app_id => $m_app});

        $app->ssp_mobile_app_settings->update_in_bk({id => $m_app});
    }
);

sub mock_app {
    my ($app) = @_;

    mock_curdate($mock_date);

    my @check_data = (
        {
            '0' => {
                'BannerLang'    => ['by', 'en', 'kz', 'ru', 'uk'],
                'BusinessUnit'  => '0',
                'CPA'           => '40',
                'CreateDate'    => '1970-01-01 03:00:00',
                'Description'   => 'com.cleanmaster.mguard.test',
                'DisabledFlags' => 'bookmaker',
                'Domain'        => 'com.cleanmaster.mguard.test',
                'FastContext'   => '0',
                'IsYandexPage'  => 0,
                'Login'         => 'mopub',
                'Mirrors'       => 'dsp.yandex.ru',
                'MobileApp'     => 1,
                'MobileAppMode' => '0',
                'Name'          => 'com.cleanmaster.mguard.test',
                'OnlyPicture'   => '1',
                'Options'       => "dontshowsex=1;BlockTitle=Реклама test",
                'PPCTotal'      => 9,
                'PageCaption'   => '0',
                'PageID'        => '0',
                'PageOptions'   => {
                    'Disable' => [],
                    'Enable'  => []
                },
                'PartnerID'       => '8739185',
                'PicturesEnabled' => '1',
                'PIEditTime'      => $mock_date,
                'Places'          => isa('SOAP::Data'),
                'ProductID'       => 'ssp_mobile_app_settings',
                'ProductType'     => 'mobile',
                'SSPID'           => '8739185',
                'SSPPageToken'    => ['com.cleanmaster.mguard.test'],
                'State'           => 1,
                'Store'           => 'AppStore',
                'TargetType'      => 3,
                'UpdateTimePI'    => $mock_date,
                'excludeddomains' => 'com.cleanmaster.mguard.test,dsp.yandex.ru',
                'isPi2'           => 1
            }
        },
        {
            '0' => {
                'PageID'          => $PAGE_ID,
                'Options'         => "dontshowsex=1;BlockTitle=Реклама test",
                'PicturesEnabled' => '1',
                'Places'          => isa('SOAP::Data'),
                'ProductID'       => 'ssp_mobile_app_settings',
                'ProductType'     => 'mobile',
                'RtbBlocks'       => {
                    '1' => {
                        'AdFoxBlock' => 0,
                        'AdType'     => isa('SOAP::Data'),
                        'AdTypeSet'  => {
                            'media'             => 1,
                            'media-performance' => 1,
                            'text'              => 1,
                            'video'             => 0,
                            'video-performance' => 0
                        },
                        'AllowedImageType' => ['small', 'regular', 'wide'],
                        'Article'          => isa('SOAP::Data'),
                        'BlockCaption'     => '',
                        'BlockType'        => 'banner',
                        'Brand'            => isa('SOAP::Data'),
                        'DSPInfo'          => [
                            {
                                'CPM'   => 800,
                                'DSPID' => '1',
                            }
                        ],
                        'DSPType'      => 4,
                        'DirectLimit'  => 1,
                        'Geo'          => isa('SOAP::Data'),
                        'Height'       => '400',
                        'MultiState'   => '22',
                        'OptimizeType' => 0,
                        'RtbDesign' =>
'"bgColor":"FFFFFF","blockId":"R-SM-0-1","borderColor":"DDDCDA","borderRadius":false,"borderType":"block","favicon":true,"headerBgColor":"FFFFFF","horizontalAlign":"0","hoverColor":"DD0000","limit":1,"linksUnderline":false,"name":"240x400","noSitelinks":false,"siteBgColor":"FFFFFF","sitelinksColor":"0000CC","textColor":"000000","titleColor":"0000CC","urlColor":"006600"',
                        'Sizes' => [
                            {
                                'Height' => '240',
                                'Width'  => '400'
                            },
                            {
                                'Height' => '50',
                                'Width'  => '320'
                            },
                            {
                                'Height' => '320',
                                'Width'  => '480'
                            },
                            {
                                'Height' => '400',
                                'Width'  => '240'
                            },
                            {
                                'Height' => '300',
                                'Width'  => '300'
                            },
                            {
                                'Height' => '480',
                                'Width'  => '320'
                            },
                            {
                                'Height' => '90',
                                'Width'  => '728'
                            },
                            {
                                'Height' => '250',
                                'Width'  => '300'
                            },
                            {
                                'Height' => '100',
                                'Width'  => '320'
                            },
                            {
                                'Height' => 0,
                                'Width'  => 0
                            }
                        ],
                        'Width' => '240'
                    }
                },
                'IsYandexPage'    => 0,
                'excludeddomains' => '',
                'ProductType'     => 'mobile',
                'OnlyPicture'     => '1',
                'Domain'          => 'com.cleanmaster.mguard.test',
                'DisabledFlags'   => 'bookmaker',
                'Mirrors'         => 'dsp.yandex.ru',
                'TargetType'      => 3,
                'PPCTotal'        => 9,
                'SSPID'           => '8739185',
                'SSPPageToken'    => ['com.cleanmaster.mguard.test'],
                'State'           => 1,
                'Store'           => 'AppStore',
                'TargetType'      => 3,
                'UpdateTimePI'    => $mock_date,
                'excludeddomains' => 'com.cleanmaster.mguard.test,dsp.yandex.ru',
                'isPi2'           => 1
            }
        },
    );

    $app->api_bk;
    $app->{'api_bk'} = Test::MockObject::Extends->new($app->{'api_bk'});
    $app->api_bk->mock(
        'call',
        sub {
            my ($api_bk, $method, $data) = @_;

            delete $data->{'0'}->{Slots};

            cmp_deeply($data, shift(@check_data), 'Corrected data');

            return [
                {
                    0 => {
                        PageID   => $PAGE_ID,
                        Error    => '0',
                        ErrorStr => '',
                    }
                }
            ];
        }
    );
}
