#!/usr/bin/perl -w

use FindBin qw($Bin);
use lib "$Bin/../lib";
use lib "$Bin/../utils/lib";
use lib "$Bin/lib";

use utf8;
use open qw(:std :utf8);

use Test::Most;
use Test::More;
use Test::Deep;
use Test::MockObject::Extends;

use File::Temp qw(tempdir);

use qbit;

use Test::Partner::DB::Mock;
use Test::Partner::Utils qw(get_new_user get_last_email);

use Template;
use Application;

die_on_fail();

my $app = Application->new();

$app = Test::MockObject::Extends->new($app);
$app->mock(
    'make_cmd',
    sub {
        my ($self, $cmd, $path, $id_param, $id_value) = @_;

        return "/$path/$cmd?$id_param=$id_value";
    }
);

$app->pre_run();

SKIP: {
    skip <<WHY, 1;
    Временно отключил этот тест, так как сейчас происходит процесс миграции
    данных из ПИ1 в ПИ2 (PI-1303) - там делается преенос пользоватлей у которых
    нет client_id. После того как миграция закончится (и все будет в
    продакшкене) нужно будет использовать скрипт utils/find_client_id.pl для
    создания client_id у этих партнеров + раскоментить этот тест
WHY
    my $res = $app->partner_db->users->get_all(filter => [AND => [[id => '>' => \0,], [client_id => '=' => \0]]]) || [];

    is(@$res, 0, 'all users have client_id');
}

$app->post_run();
done_testing();
exit;
