#!/usr/bin/perl

=encoding UTF-8

=head1 Описание

Тест проверяет, что после всех функций gettext() в templates, стоит фильтр bem.

=cut

use Test::More;
use Carp;
use File::Find;
use Term::ANSIColor qw(colored);

sub _search_filter_bem {
    my ($filename, $result) = @_;

    return unless $filename =~ m#\.bem\.tt2$#;

    open FILE, "< :encoding(UTF-8)", $filename or croak "Can't open file '$filename': $!. Stopped";
    my @lines = <FILE>;
    close FILE;

    my $i = 0;
    foreach my $line (@lines) {
        $i++;

        while ($line =~ m#(\[%\s+[n|p]?gettext\((.*?)%\])#ig) {
            my $error = $1;
            my ($end) = ($2 =~ m#.*\)([^)]+)#i);
            push(
                @$result,
                {
                    file       => "$filename:$i",
                    file_color => colored($filename, 'red') . ":" . colored($i, 'green'),
                    error      => $error
                }
            ) unless $end =~ m#\|\s+bem\s+#i;
        }

    }
}

my @result = ();

find(
    {
        wanted => sub {_search_filter_bem($File::Find::fullname, \@result)},
        follow => 1,
    },
    './templates/',
);

if (@result) {
    foreach (@result) {
        my $expected = $_->{'error'};
        $expected =~ s#\s%\]$# | bem %]#;
        is($_->{'error'}, $expected, "No filter \"bem\" in $_->{file}");
        note($_->{'file_color'});
    }
} else {
    is(@result, 0, 'Filter "bem" used everywhere');
}

done_testing(scalar(@result) ? scalar(@result) : 1);
