#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::RosettaServer;

my %tests = (
    'authorization' => {
        requests  => [authorization_request('ok')],
        responses => [
            {
                "result"        => "ok",
                "display_login" => "yndx.developer",
                "client_id"     => undef,
                "request_id"    => "1490711915159-23-578",
                "user_id"       => "731583645",
                "login"         => "yndx-developer",
            }
        ],
    },
    'authorization need_auth' => {
        requests  => [authorization_request('need_auth')],
        responses => [
            {
                "result"     => "need_auth",
                "data"       => 'ARRAY',
                "request_id" => "1490711915159-23-578",
            }
        ],
    },
    'authorization need_resign' => {
        requests  => [authorization_request('need_resign')],
        responses => [
            {
                "result"     => "need_resign",
                "data"       => 'ARRAY',
                "request_id" => "1490711915159-23-578",
            }
        ],
    },
    'authorization need_real_login' => {
        requests  => [authorization_request('need_real_login')],
        responses => [
            {
                "result"     => "need_real_login",
                "data"       => 'ARRAY',
                "request_id" => "1490711915159-23-578",
            }
        ],
    },
    'authorization exception' => {
        requests  => [authorization_request('exception')],
        responses => [
            {
                "result"     => "error",
                "message"    => "Exception from mocked blackbox",
                "request_id" => "1490711915159-23-578",
            }
        ],
    },
);

run_tests(
    sub {
        my ($app) = @_;
        run_rosetta_tests($app, \%tests);
    },
    application_package  => 'Rosetta',
    dont_create_database => 1,
    locale               => 'C',
);
