#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::RosettaServer;
use Test::Partner2::Mock;

my %tests = (
    'call after need_auth' => {
        requests => [
            authorization_request('need_auth'),
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449922115-733429-1",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "frontend",
                "method"           => "get_locales",
                "args"             => []
            },
        ],
        responses => [
            {
                "result"     => "need_auth",
                "data"       => 'ARRAY',
                "request_id" => "1490711915159-23-578",
            },
            {
                'data'       => 'ARRAY',
                'request_id' => '1490449922115-733429-1',
                'result'     => 'ok'
            },
        ],
    },
    'dashboard' => {
        requests => [
            authorization_request('ok'),
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449922116-733429-2",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "frontend",
                "method"           => "simple_lang_detect",
                "args"             => [
                    "ip", "2a02:6b8:0:c33::1:58", "my_cookie", undef, "yandex_gid_cookie", "213", "host",
                    "dev-partner2.yandex.ru", "accept_language", "ru"
                ]
            },
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449922116-733429-3",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "rbac",
                "method"           => "get_roles_by_user_id",
                "args"             => ["461966656"]
            },
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449922943-733429-4",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "rbac",
                "method"           => "get_roles_rights",
                "args"             => ["fields", ["right"], "role_id", ["2"]]
            },
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449923116-733429-6",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "users",
                "method"           => "get",
                "args"             => [
                    "461966656",
                    "fields",
                    [
                        "available_fields",          "editable_fields",
                        "adfox_info",                "client_id",
                        "editable_fields",           "email",
                        "excluded_domains",          "excluded_phones",
                        "has_tutby_agreement",       "id",
                        "lastname",                  "login",
                        "midname",                   "multistate_name",
                        "name",                      "newsletter",
                        "no_stat_monitoring_emails", "phone",
                        "roles"
                    ]
                ]
            },
            {
                "rosetta_type"     => "call",
                "request_id"       => "1490449923152-733429-7",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "widgets",
                "method"           => "get_widgets",
                "args"             => []
            },
        ],
        responses => [
            {
                "result"        => "ok",
                "display_login" => "yndx.developer",
                "client_id"     => undef,
                "request_id"    => "1490711915159-23-578",
                "user_id"       => "731583645",
                "login"         => "yndx-developer",
            },
            {
                "result"     => "ok",
                "request_id" => "1490449922116-733429-2",
                "data"       => "ARRAY",
            },
            {
                "result"     => "ok",
                "request_id" => "1490449922116-733429-3",
                "data"       => "ARRAY",
            },
            {
                "result"     => "ok",
                "request_id" => "1490449922943-733429-4",
                "data"       => "ARRAY",
            },
            {
                "result"     => "ok",
                "request_id" => "1490449923116-733429-6",
                "data"       => "ARRAY",
            },
            {
                "result"     => "ok",
                "request_id" => "1490449923152-733429-7",
                "data"       => "ARRAY",
            },
        ],
    },
);

run_tests(
    sub {
        my ($app) = @_;

        mock_app($app);

        run_rosetta_tests($app, \%tests);
    },
    application_package  => 'Rosetta',
    dont_create_database => 1,
    locale               => 'C',
);

sub mock_app {
    my ($app) = @_;

    mock_geobase($app);
    mock_blackbox($app);

    mock_subs(
        {
            'Application::Model::Statistics::MobileMediation::is_available' => sub {TRUE},
            'Application::Model::Statistics::Product::is_available'         => sub {TRUE},
        }
    );
}
