#!/usr/bin/perl -w

use qbit;

use Test::More;
use Test::Partner2::Simple;

use RosettaProtocol qw(interact);

run_tests(
    sub {
        my ($app) = @_;

        no strict 'refs';
        no warnings 'redefine';

        *{'Rosetta::pre_run'} = sub {
            throw Exception 'Mocked pre_run fail';
        };
        *{'Application::Model::ExceptionDumper::dump_as_html_file'} = sub {
            ok($_[1]->message, 'Mocked pre_run fail');
        };

        subtest 'Failed interact' => sub {
            plan tests => 1;
            interact(undef, $app);
        };
    },
    application_package  => 'Rosetta',
    dont_create_database => 1,
    locale               => 'C',
    init                 => [qw(exception_dumper)]
);
