#!/usr/bin/perl -w

use qbit;

use Test::Partner2::Simple;
use Test::Partner2::RosettaServer;

my %tests = (
    'unknown authorization type' => {
        requests => [
            {
                rosetta_type => 'authentication',
                login        => 'yndx.madamada',
            },
        ],
        responses => [
            {
                result  => 'error',
                message => 'Unexpected request type: authentication',
            },
        ],
    },
    'unknown method type after authorization' => {
        requests => [
            authorization_request('ok'),
            {
                "rosetta_type"     => "get",
                "request_id"       => "1490449922115-733429-1",
                "nginx_request_id" => "3fc7afdcb752722ea57fa4fddea22652",
                "model"            => "frontend",
                "method"           => "get_available_resources",
                "args"             => []
            },
        ],
        responses => [
            {
                "result"        => "ok",
                "display_login" => "yndx.developer",
                "client_id"     => undef,
                "request_id"    => "1490711915159-23-578",
                "user_id"       => "731583645",
                "login"         => "yndx-developer",
            },
            {
                "result"  => "error",
                "message" => "Unexpected request type: get",
            },
        ],
    },
);

run_tests(
    sub {
        my ($app) = @_;
        run_rosetta_tests($app, \%tests);
    },
    application_package  => 'Rosetta',
    dont_create_database => 1,
    locale               => 'C',
);
